/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenSuperImplementationAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenSuperImplementationAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("OpenSuperImplementationAction.label"));
        this.setDescription(ActionMessages.getString("OpenSuperImplementationAction.description"));
        this.setToolTipText(ActionMessages.getString("OpenSuperImplementationAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.open_super_implementation_action");
    }

    public OpenSuperImplementationAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        IMethod method = this.getMethod(selection);
        this.setEnabled(method != null && this.checkMethod(method));
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        IJavaElement element = this.elementAtOffset();
        if (element == null || !(element instanceof IMethod)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)ActionMessages.getString("OpenSuperImplementationAction.not_applicable"));
            return;
        }
        this.run((IMethod)element);
    }

    public void run(IStructuredSelection selection) {
        this.run(this.getMethod(selection));
    }

    public void run(IMethod method) {
        if (method == null) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), method)) {
            return;
        }
        if (!this.checkMethod(method)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)ActionMessages.getFormattedString("OpenSuperImplementationAction.no_super_implementation", method.getElementName()));
            return;
        }
        try {
            IType type = method.getDeclaringType();
            IMethod impl = this.findSuperImplementation(type, method.getElementName(), method.getParameterTypes(), method.isConstructor());
            if (impl != null) {
                OpenActionUtil.open(impl);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            String message = ActionMessages.getString("OpenSuperImplementationAction.error.message");
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)message, (IStatus)e.getStatus());
        }
    }

    private IMethod findSuperImplementation(IType declaringType, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(declaringType);
        IMethod impl = JavaModelUtil.findMethodImplementationInHierarchy(hierarchy, declaringType, name, paramTypes, isConstructor);
        if (impl == null) {
            impl = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, declaringType, name, paramTypes, isConstructor);
        }
        return impl;
    }

    private IMethod getMethod(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IMethod) {
            return (IMethod)element;
        }
        return null;
    }

    private boolean checkMethod(IMethod method) {
        block3: {
            try {
                int flags = method.getFlags();
                if (!Flags.isStatic((int)flags) && !Flags.isPrivate((int)flags)) {
                    IType declaringType = method.getDeclaringType();
                    return !SuperTypeHierarchyCache.hasInCache(declaringType) || this.findSuperImplementation(declaringType, method.getElementName(), method.getParameterTypes(), method.isConstructor()) != null;
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block3;
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    private IJavaElement elementAtOffset() {
        try {
            return SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static String getDialogTitle() {
        return ActionMessages.getString("OpenSuperImplementationAction.error.title");
    }
}

