/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.Assert;

public class JUnitStatus
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;

    public JUnitStatus() {
        this(0, null);
    }

    public JUnitStatus(int severity, String message) {
        this.fStatusMessage = message;
        this.fSeverity = severity;
    }

    public static IStatus createError(String message) {
        return new JUnitStatus(4, message);
    }

    public static IStatus createWarning(String message) {
        return new JUnitStatus(2, message);
    }

    public static IStatus createInfo(String message) {
        return new JUnitStatus(1, message);
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public void setError(String errorMessage) {
        Assert.isNotNull((Object)errorMessage);
        this.fStatusMessage = errorMessage;
        this.fSeverity = 4;
    }

    public void setWarning(String warningMessage) {
        Assert.isNotNull((Object)warningMessage);
        this.fStatusMessage = warningMessage;
        this.fSeverity = 2;
    }

    public void setInfo(String infoMessage) {
        Assert.isNotNull((Object)infoMessage);
        this.fStatusMessage = infoMessage;
        this.fSeverity = 1;
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public boolean matches(int severityMask) {
        return (this.fSeverity & severityMask) != 0;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getPlugin() {
        return "org.eclipse.jdt.junit";
    }

    public Throwable getException() {
        return null;
    }

    public int getCode() {
        return this.fSeverity;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }
}

