/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.swt.SWT;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.internal.forms.widgets.BreakSegment;
import org.eclipse.ui.internal.forms.widgets.BulletParagraph;
import org.eclipse.ui.internal.forms.widgets.HyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageSegment;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormTextModel {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private boolean whitespaceNormalized = true;
    private Vector paragraphs;
    private HyperlinkSegment[] hyperlinks;
    private int selectedLinkIndex = -1;
    private HyperlinkSettings hyperlinkSettings;
    public static final String BOLD_FONT_ID = "f.____bold";

    public FormTextModel() {
        this.reset();
    }

    public Paragraph[] getParagraphs() {
        if (this.paragraphs == null) {
            return new Paragraph[0];
        }
        return this.paragraphs.toArray(new Paragraph[this.paragraphs.size()]);
    }

    public String getAccessibleText() {
        if (this.paragraphs == null) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            Paragraph paragraph = (Paragraph)this.paragraphs.get(i);
            String text = paragraph.getAccessibleText();
            sbuf.append(text);
        }
        return sbuf.toString();
    }

    public void parseTaggedText(String taggedText, boolean expandURLs) {
        if (taggedText == null) {
            this.reset();
            return;
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(taggedText.getBytes("UTF8"));
            this.parseInputStream(stream, expandURLs);
        }
        catch (UnsupportedEncodingException e) {
            SWT.error((int)42, (Throwable)e);
        }
    }

    public void parseInputStream(InputStream is, boolean expandURLs) {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        this.reset();
        try {
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            InputSource source = new InputSource(is);
            Document doc = parser.parse(source);
            this.processDocument(doc, expandURLs);
        }
        catch (ParserConfigurationException e) {
            SWT.error((int)13, (Throwable)e);
        }
        catch (SAXException e) {
            SWT.error((int)13, (Throwable)e);
        }
        catch (IOException e) {
            SWT.error((int)39, (Throwable)e);
        }
    }

    private void processDocument(Document doc, boolean expandURLs) {
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Paragraph p;
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                String text = this.getSingleNodeText(child);
                if (text == null || this.isIgnorableWhiteSpace(text, true)) continue;
                p = new Paragraph(true);
                p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), null);
                this.paragraphs.add(p);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            String tag = child.getNodeName().toLowerCase();
            if (tag.equals("p")) {
                p = this.processParagraph(child, expandURLs);
                if (p == null) continue;
                this.paragraphs.add(p);
                continue;
            }
            if (!tag.equals("li") || (p = this.processListItem(child, expandURLs)) == null) continue;
            this.paragraphs.add(p);
        }
    }

    private Paragraph processParagraph(Node paragraph, boolean expandURLs) {
        NodeList children = paragraph.getChildNodes();
        NamedNodeMap atts = paragraph.getAttributes();
        Node addSpaceAtt = atts.getNamedItem("addVerticalSpace");
        boolean addSpace = true;
        if (addSpaceAtt == null) {
            addSpaceAtt = atts.getNamedItem("vspace");
        }
        if (addSpaceAtt != null) {
            String value = addSpaceAtt.getNodeValue();
            addSpace = value.equalsIgnoreCase("true");
        }
        Paragraph p = new Paragraph(addSpace);
        this.processSegments(p, children, expandURLs);
        return p;
    }

    private Paragraph processListItem(Node listItem, boolean expandURLs) {
        String value;
        NodeList children = listItem.getChildNodes();
        NamedNodeMap atts = listItem.getAttributes();
        Node addSpaceAtt = atts.getNamedItem("addVerticalSpace");
        Node styleAtt = atts.getNamedItem("style");
        Node valueAtt = atts.getNamedItem("value");
        Node indentAtt = atts.getNamedItem("indent");
        Node bindentAtt = atts.getNamedItem("bindent");
        int style = 1;
        int indent = -1;
        int bindent = -1;
        String text = null;
        boolean addSpace = true;
        if (addSpaceAtt != null) {
            value = addSpaceAtt.getNodeValue();
            addSpace = value.equalsIgnoreCase("true");
        }
        if (styleAtt != null) {
            value = styleAtt.getNodeValue();
            if (value.equalsIgnoreCase("text")) {
                style = 2;
            } else if (value.equalsIgnoreCase("image")) {
                style = 3;
            } else if (value.equalsIgnoreCase("bullet")) {
                style = 1;
            }
        }
        if (valueAtt != null) {
            text = valueAtt.getNodeValue();
            if (style == 3) {
                text = "i." + text;
            }
        }
        if (indentAtt != null) {
            value = indentAtt.getNodeValue();
            try {
                indent = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (bindentAtt != null) {
            value = bindentAtt.getNodeValue();
            try {
                bindent = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        BulletParagraph p = new BulletParagraph(addSpace);
        p.setIndent(indent);
        p.setBulletIndent(bindent);
        p.setBulletStyle(style);
        p.setBulletText(text);
        this.processSegments(p, children, expandURLs);
        return p;
    }

    private void processSegments(Paragraph p, NodeList children, boolean expandURLs) {
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            ParagraphSegment segment = null;
            if (child.getNodeType() == 3) {
                String value = this.getSingleNodeText(child);
                if (value != null && !this.isIgnorableWhiteSpace(value, false)) {
                    p.parseRegularText(value, expandURLs, this.getHyperlinkSettings(), null);
                }
            } else if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                if (name.equalsIgnoreCase("img")) {
                    segment = this.processImageSegment(child);
                } else if (name.equalsIgnoreCase("a")) {
                    segment = this.processHyperlinkSegment(child, this.getHyperlinkSettings());
                } else if (name.equalsIgnoreCase("span")) {
                    this.processTextSegment(p, expandURLs, child);
                } else if (name.equalsIgnoreCase("b")) {
                    String text = this.getNodeText(child);
                    String fontId = BOLD_FONT_ID;
                    p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), fontId);
                } else if (name.equalsIgnoreCase("br")) {
                    segment = new BreakSegment();
                }
            }
            if (segment == null) continue;
            p.addSegment(segment);
        }
    }

    private boolean isIgnorableWhiteSpace(String text, boolean ignoreSpaces) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (ignoreSpaces && c == ' ' || c == '\n' || c == '\r' || c == '\f') continue;
            return false;
        }
        return true;
    }

    private ParagraphSegment processImageSegment(Node image) {
        String value;
        ImageSegment segment = new ImageSegment();
        NamedNodeMap atts = image.getAttributes();
        Node id = atts.getNamedItem("href");
        Node align = atts.getNamedItem("align");
        if (id != null) {
            value = id.getNodeValue();
            segment.setObjectId("i." + value);
        }
        if (align != null) {
            value = align.getNodeValue().toLowerCase();
            if (value.equals("top")) {
                segment.setVerticalAlignment(1);
            } else if (value.equals("middle")) {
                segment.setVerticalAlignment(2);
            } else if (value.equals("bottom")) {
                segment.setVerticalAlignment(3);
            }
        }
        return segment;
    }

    private void appendText(String value, StringBuffer buf, int[] spaceCounter) {
        if (!this.whitespaceNormalized) {
            buf.append(value);
        } else {
            for (int j = 0; j < value.length(); ++j) {
                char c = value.charAt(j);
                if (c == ' ' || c == '\t') {
                    spaceCounter[0] = spaceCounter[0] + 1;
                    if (spaceCounter[0] != 1) continue;
                    buf.append(c);
                    continue;
                }
                if (c == '\n' || c == '\r' || c == '\f') {
                    spaceCounter[0] = spaceCounter[0] + 1;
                    if (spaceCounter[0] != 1) continue;
                    buf.append(' ');
                    continue;
                }
                spaceCounter[0] = 0;
                buf.append(c);
            }
        }
    }

    private String getNormalizedText(String text) {
        int[] spaceCounter = new int[1];
        StringBuffer buf = new StringBuffer();
        if (text == null) {
            return null;
        }
        this.appendText(text, buf, spaceCounter);
        return buf.toString();
    }

    private String getSingleNodeText(Node node) {
        return this.getNormalizedText(node.getNodeValue());
    }

    private String getNodeText(Node node) {
        NodeList children = node.getChildNodes();
        StringBuffer buf = new StringBuffer();
        int[] spaceCounter = new int[1];
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            String value = child.getNodeValue();
            this.appendText(value, buf, spaceCounter);
        }
        return buf.toString().trim();
    }

    private ParagraphSegment processHyperlinkSegment(Node link, HyperlinkSettings settings) {
        String value;
        Node nowrap;
        String text = this.getNodeText(link);
        HyperlinkSegment segment = new HyperlinkSegment(text, settings, null);
        NamedNodeMap atts = link.getAttributes();
        Node href = atts.getNamedItem("href");
        if (href != null) {
            String value2 = href.getNodeValue();
            segment.setHref(value2);
        }
        if ((nowrap = atts.getNamedItem("nowrap")) != null && (value = nowrap.getNodeValue()) != null && value.equalsIgnoreCase("true")) {
            segment.setWordWrapAllowed(false);
        }
        return segment;
    }

    private void processTextSegment(Paragraph p, boolean expandURLs, Node textNode) {
        String text = this.getNodeText(textNode);
        NamedNodeMap atts = textNode.getAttributes();
        Node font = atts.getNamedItem("font");
        Node color = atts.getNamedItem("color");
        String fontId = null;
        String colorId = null;
        if (font != null) {
            fontId = "f." + font.getNodeValue();
        }
        if (color != null) {
            colorId = "c." + color.getNodeValue();
        }
        p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), fontId, colorId);
    }

    public void parseRegularText(String regularText, boolean convertURLs) {
        this.reset();
        if (regularText == null) {
            return;
        }
        regularText = this.getNormalizedText(regularText);
        Paragraph p = new Paragraph(true);
        this.paragraphs.add(p);
        int pstart = 0;
        for (int i = 0; i < regularText.length(); ++i) {
            char c = regularText.charAt(i);
            if (p == null) {
                p = new Paragraph(true);
                this.paragraphs.add(p);
            }
            if (c != '\n') continue;
            String text = regularText.substring(pstart, i);
            pstart = i + 1;
            p.parseRegularText(text, convertURLs, this.getHyperlinkSettings(), null);
            p = null;
        }
        if (p != null) {
            String text = regularText.substring(pstart);
            p.parseRegularText(text, convertURLs, this.getHyperlinkSettings(), null);
        }
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.hyperlinkSettings;
    }

    public void setHyperlinkSettings(HyperlinkSettings settings) {
        this.hyperlinkSettings = settings;
    }

    private void reset() {
        if (this.paragraphs == null) {
            this.paragraphs = new Vector();
        }
        this.paragraphs.clear();
        this.selectedLinkIndex = -1;
        this.hyperlinks = null;
    }

    HyperlinkSegment[] getHyperlinks() {
        if (this.hyperlinks != null || this.paragraphs == null) {
            return this.hyperlinks;
        }
        Vector<ParagraphSegment> result = new Vector<ParagraphSegment>();
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            Paragraph p = (Paragraph)this.paragraphs.get(i);
            ParagraphSegment[] segments = p.getSegments();
            for (int j = 0; j < segments.length; ++j) {
                if (!(segments[j] instanceof HyperlinkSegment)) continue;
                result.add(segments[j]);
            }
        }
        this.hyperlinks = result.toArray(new HyperlinkSegment[result.size()]);
        return this.hyperlinks;
    }

    public HyperlinkSegment findHyperlinkAt(int x, int y) {
        HyperlinkSegment[] links = this.getHyperlinks();
        for (int i = 0; i < links.length; ++i) {
            if (!links[i].contains(x, y)) continue;
            return links[i];
        }
        return null;
    }

    public TextSegment findSegmentAt(int x, int y) {
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            Paragraph p = (Paragraph)this.paragraphs.get(i);
            TextSegment segment = p.findSegmentAt(x, y);
            if (segment == null) continue;
            return segment;
        }
        return null;
    }

    public HyperlinkSegment getSelectedLink() {
        if (this.selectedLinkIndex == -1) {
            return null;
        }
        return this.hyperlinks[this.selectedLinkIndex];
    }

    public boolean traverseLinks(boolean next) {
        HyperlinkSegment[] links = this.getHyperlinks();
        if (links == null) {
            return false;
        }
        int size = links.length;
        this.selectedLinkIndex = next ? ++this.selectedLinkIndex : --this.selectedLinkIndex;
        if (this.selectedLinkIndex < 0 || this.selectedLinkIndex > size - 1) {
            this.selectedLinkIndex = -1;
        }
        return this.selectedLinkIndex != -1;
    }

    public void selectLink(HyperlinkSegment link) {
        if (link == null) {
            this.selectedLinkIndex = -1;
        } else {
            HyperlinkSegment[] links = this.getHyperlinks();
            this.selectedLinkIndex = -1;
            if (links == null) {
                return;
            }
            for (int i = 0; i < links.length; ++i) {
                if (!links[i].equals(link)) continue;
                this.selectedLinkIndex = i;
                break;
            }
        }
    }

    public boolean hasFocusSegments() {
        HyperlinkSegment[] links = this.getHyperlinks();
        return links.length > 0;
    }

    public void dispose() {
        this.paragraphs = null;
        this.selectedLinkIndex = -1;
        this.hyperlinks = null;
    }

    public boolean isWhitespaceNormalized() {
        return this.whitespaceNormalized;
    }

    public void setWhitespaceNormalized(boolean whitespaceNormalized) {
        this.whitespaceNormalized = whitespaceNormalized;
    }
}

