/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointFieldLocator;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifierJob;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointMethodLocator;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    static /* synthetic */ Class class$org$eclipse$ui$texteditor$IEditorStatusLine;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IClassFile;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(class$org$eclipse$ui$texteditor$IEditorStatusLine == null ? (class$org$eclipse$ui$texteditor$IEditorStatusLine = ToggleBreakpointAdapter.class$("org.eclipse.ui.texteditor.IEditorStatusLine")) : class$org$eclipse$ui$texteditor$IEditorStatusLine);
        if (statusLine != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
            JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return type;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            this.report(null, part);
            IEditorPart editorPart = (IEditorPart)part;
            ITextSelection textSelection = (ITextSelection)selection;
            IType type = this.getType(textSelection);
            IEditorInput editorInput = editorPart.getEditorInput();
            IDocument document = ((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)editorInput);
            int lineNumber = textSelection.getStartLine() + 1;
            int offset = textSelection.getOffset();
            try {
                Object resource;
                IClassFile classFile;
                if (type == null && (classFile = (IClassFile)editorInput.getAdapter(class$org$eclipse$jdt$core$IClassFile == null ? (class$org$eclipse$jdt$core$IClassFile = ToggleBreakpointAdapter.class$("org.eclipse.jdt.core.IClassFile")) : class$org$eclipse$jdt$core$IClassFile)) != null && (type = classFile.getType()).getDeclaringType() != null) {
                    ISourceRange sourceRange = type.getSourceRange();
                    int start = sourceRange.getOffset();
                    int end = start + sourceRange.getLength();
                    if (offset < start || offset > end) {
                        IStatusLineManager statusLine = editorPart.getEditorSite().getActionBars().getStatusLineManager();
                        statusLine.setErrorMessage(MessageFormat.format(ActionMessages.getString("ManageBreakpointRulerAction.Breakpoints_can_only_be_created_within_the_type_associated_with_the_editor__{0}._1"), type.getTypeQualifiedName()));
                        Display.getCurrent().beep();
                        return;
                    }
                }
                String typeName = null;
                IJavaLineBreakpoint breakpoint = null;
                if (type == null) {
                    resource = editorInput instanceof IFileEditorInput ? ((IFileEditorInput)editorInput).getFile() : ResourcesPlugin.getWorkspace().getRoot();
                } else {
                    typeName = type.getFullyQualifiedName();
                    IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((String)typeName, (int)lineNumber);
                    if (existingBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                        return;
                    }
                    resource = BreakpointUtils.getBreakpointResource((IMember)type);
                    HashMap attributes = new HashMap(10);
                    try {
                        IRegion line = document.getLineInformation(lineNumber - 1);
                        int start = line.getOffset();
                        int end = start + line.getLength() - 1;
                        BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, start, end);
                    }
                    catch (BadLocationException ble) {
                        JDIDebugUIPlugin.log(ble);
                    }
                    breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, attributes);
                }
                new BreakpointLocationVerifierJob(document, breakpoint, lineNumber, typeName, type, (IResource)resource, (IEditorStatusLine)editorPart.getAdapter(class$org$eclipse$ui$texteditor$IEditorStatusLine == null ? (class$org$eclipse$ui$texteditor$IEditorStatusLine = ToggleBreakpointAdapter.class$("org.eclipse.ui.texteditor.IEditorStatusLine")) : class$org$eclipse$ui$texteditor$IEditorStatusLine)).schedule();
            }
            catch (CoreException ce) {
                ExceptionHandler.handle(ce, ActionMessages.getString("ManageBreakpointActionDelegate.error.title1"), ActionMessages.getString("ManageBreakpointActionDelegate.error.message1"));
                return;
            }
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.report(null, part);
        selection = this.translateToMembers(part, selection);
        if (selection instanceof ITextSelection) {
            CompilationUnit compilationUnit;
            ITextSelection textSelection = (ITextSelection)selection;
            if (selection != null && (compilationUnit = this.parseCompilationUnit((ITextEditor)part)) != null) {
                BreakpointMethodLocator locator = new BreakpointMethodLocator(textSelection.getOffset());
                compilationUnit.accept((ASTVisitor)locator);
                String methodName = locator.getMethodName();
                if (methodName == null) {
                    this.report(ActionMessages.getString("ManageMethodBreakpointActionDelegate.CantAdd"), part);
                    return;
                }
                String typeName = locator.getTypeName();
                String methodSignature = locator.getMethodSignature();
                if (methodSignature == null) {
                    this.report(ActionMessages.getString("ManageMethodBreakpointActionDelegate.methodNonAvailable"), part);
                    return;
                }
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
                for (int i = 0; i < breakpoints.length; ++i) {
                    IJavaMethodBreakpoint methodBreakpoint;
                    IBreakpoint breakpoint = breakpoints[i];
                    if (!(breakpoint instanceof IJavaMethodBreakpoint) || !typeName.equals((methodBreakpoint = (IJavaMethodBreakpoint)breakpoint).getTypeName()) || !methodName.equals(methodBreakpoint.getMethodName()) || !methodSignature.equals(methodBreakpoint.getMethodSignature())) continue;
                    breakpointManager.removeBreakpoint((IBreakpoint)methodBreakpoint, true);
                    return;
                }
                JDIDebugModel.createMethodBreakpoint((IResource)ToggleBreakpointAdapter.getResource((IEditorPart)part), (String)typeName, (String)methodName, (String)methodSignature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)true, new HashMap(10));
            }
        } else if (selection instanceof IStructuredSelection) {
            IMethod[] members = this.getMethods((IStructuredSelection)selection);
            if (members.length == 0) {
                this.report(ActionMessages.getString("ToggleBreakpointAdapter.9"), part);
                return;
            }
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            int length = members.length;
            for (int i = 0; i < length; ++i) {
                IMethod method = members[i];
                IJavaBreakpoint breakpoint = this.getBreakpoint((IMember)method);
                if (breakpoint == null) {
                    int start = -1;
                    int end = -1;
                    ISourceRange range = method.getNameRange();
                    if (range != null) {
                        start = range.getOffset();
                        end = start + range.getLength();
                    }
                    HashMap attributes = new HashMap(10);
                    BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)method);
                    String methodName = method.getElementName();
                    if (method.isConstructor()) {
                        methodName = "<init>";
                    }
                    IType type = method.getDeclaringType();
                    String methodSignature = method.getSignature();
                    if (!type.isBinary() && (methodSignature = ToggleBreakpointAdapter.resolveMethodSignature(type, methodSignature)) == null) {
                        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, "Source method signature could not be resolved", null);
                        throw new CoreException((IStatus)status);
                    }
                    JDIDebugModel.createMethodBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)method), (String)type.getFullyQualifiedName(), (String)methodName, (String)methodSignature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
                    continue;
                }
                breakpointManager.removeBreakpoint((IBreakpoint)breakpoint, true);
            }
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.getMethods(ss).length > 0;
        }
        return selection instanceof ITextSelection;
    }

    protected IMethod[] getMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList methods = new ArrayList(selection.size());
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object thing = iterator.next();
            try {
                if (!(thing instanceof IMethod) || Flags.isAbstract((int)((IMethod)thing).getFlags())) continue;
                methods.add(thing);
            }
            catch (JavaModelException e) {}
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected IField[] getFields(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IField[0];
        }
        ArrayList fields = new ArrayList(selection.size());
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            IField field;
            Object thing = iterator.next();
            if (thing instanceof IField) {
                fields.add(thing);
                continue;
            }
            if (!(thing instanceof IJavaFieldVariable) || (field = this.getField((IJavaFieldVariable)thing)) == null) continue;
            fields.add(field);
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private boolean isFields(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object thing = iterator.next();
                if (thing instanceof IField || thing instanceof IJavaFieldVariable) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.report(null, part);
        selection = this.translateToMembers(part, selection);
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            CompilationUnit compilationUnit = this.parseCompilationUnit((ITextEditor)part);
            if (compilationUnit != null) {
                BreakpointFieldLocator locator = new BreakpointFieldLocator(textSelection.getOffset());
                compilationUnit.accept((ASTVisitor)locator);
                String fieldName = locator.getFieldName();
                if (fieldName == null) {
                    this.report(ActionMessages.getString("ManageWatchpointActionDelegate.CantAdd"), part);
                    return;
                }
                String typeName = locator.getTypeName();
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
                for (int i = 0; i < breakpoints.length; ++i) {
                    IJavaWatchpoint watchpoint;
                    IBreakpoint breakpoint = breakpoints[i];
                    if (!(breakpoint instanceof IJavaWatchpoint) || !typeName.equals((watchpoint = (IJavaWatchpoint)breakpoint).getTypeName()) || !fieldName.equals(watchpoint.getFieldName())) continue;
                    breakpointManager.removeBreakpoint((IBreakpoint)watchpoint, true);
                    return;
                }
                JDIDebugModel.createWatchpoint((IResource)ToggleBreakpointAdapter.getResource((IEditorPart)part), (String)typeName, (String)fieldName, (int)-1, (int)-1, (int)-1, (int)0, (boolean)true, new HashMap(10));
            }
        } else if (selection instanceof IStructuredSelection) {
            IField[] members = this.getFields((IStructuredSelection)selection);
            if (members.length == 0) {
                this.report(ActionMessages.getString("ToggleBreakpointAdapter.10"), part);
                return;
            }
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            int length = members.length;
            for (int i = 0; i < length; ++i) {
                IField element = members[i];
                IJavaBreakpoint breakpoint = this.getBreakpoint((IMember)element);
                if (breakpoint == null) {
                    IType type = element.getDeclaringType();
                    int start = -1;
                    int end = -1;
                    ISourceRange range = element.getNameRange();
                    if (range != null) {
                        start = range.getOffset();
                        end = start + range.getLength();
                    }
                    HashMap attributes = new HashMap(10);
                    BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)element);
                    JDIDebugModel.createWatchpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)type), (String)type.getFullyQualifiedName(), (String)element.getElementName(), (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
                    continue;
                }
                breakpointManager.removeBreakpoint((IBreakpoint)breakpoint, true);
            }
        }
    }

    public static String resolveMethodSignature(IType type, String methodSignature) throws JavaModelException {
        String[] parameterTypes = Signature.getParameterTypes((String)methodSignature);
        int length = parameterTypes.length;
        String[] resolvedParameterTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            resolvedParameterTypes[i] = ToggleBreakpointAdapter.resolveType(type, parameterTypes[i]);
            if (resolvedParameterTypes[i] != null) continue;
            return null;
        }
        String resolvedReturnType = ToggleBreakpointAdapter.resolveType(type, Signature.getReturnType((String)methodSignature));
        if (resolvedReturnType == null) {
            return null;
        }
        return Signature.createMethodSignature((String[])resolvedParameterTypes, (String)resolvedReturnType);
    }

    private static String resolveType(IType type, String typeSignature) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeSignature);
        String elementTypeSignature = Signature.getElementType((String)typeSignature);
        if (elementTypeSignature.length() == 1) {
            return typeSignature;
        }
        String elementTypeName = Signature.toString((String)elementTypeSignature);
        String[][] resolvedElementTypeNames = type.resolveType(elementTypeName);
        if (resolvedElementTypeNames == null || resolvedElementTypeNames.length != 1) {
            return null;
        }
        String resolvedElementTypeName = Signature.toQualifiedName((String[])resolvedElementTypeNames[0]);
        String resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true).replace('.', '/');
        return Signature.createArraySignature((String)resolvedElementTypeSignature, (int)count);
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        Object resource = editorInput instanceof IFileEditorInput ? ((IFileEditorInput)editorInput).getFile() : ResourcesPlugin.getWorkspace().getRoot();
        return resource;
    }

    protected IMethod getMethodHandle(IEditorPart editorPart, String typeName, String methodName, String signature) throws CoreException {
        IJavaElement element = (IJavaElement)editorPart.getEditorInput().getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = ToggleBreakpointAdapter.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        IType type = null;
        if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getAllTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].getFullyQualifiedName().equals(typeName)) continue;
                type = types[i];
                break;
            }
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        }
        if (type != null) {
            String[] sigs = Signature.getParameterTypes((String)signature);
            return type.getMethod(methodName, sigs);
        }
        return null;
    }

    protected IJavaBreakpoint getBreakpoint(IMember element) {
        block11: {
            IBreakpoint[] breakpoints;
            block10: {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
                if (!(element instanceof IMethod)) break block10;
                IMethod method = (IMethod)element;
                for (int i = 0; i < breakpoints.length; ++i) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (!(breakpoint instanceof IJavaMethodBreakpoint)) continue;
                    IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                    IMember container = null;
                    try {
                        container = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                        return null;
                    }
                    if (container == null) {
                        try {
                            if (method.getDeclaringType().getFullyQualifiedName().equals(methodBreakpoint.getTypeName()) && method.getElementName().equals(methodBreakpoint.getMethodName()) && method.getSignature().equals(methodBreakpoint.getMethodSignature())) {
                                return methodBreakpoint;
                            }
                        }
                        catch (CoreException e) {
                            JDIDebugUIPlugin.log(e);
                        }
                        continue;
                    }
                    if (!(container instanceof IMethod) || !method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) || !method.isSimilar((IMethod)container)) continue;
                    return methodBreakpoint;
                }
                break block11;
            }
            if (!(element instanceof IField)) break block11;
            for (int i = 0; i < breakpoints.length; ++i) {
                IBreakpoint breakpoint = breakpoints[i];
                if (!(breakpoint instanceof IJavaWatchpoint)) continue;
                try {
                    if (!this.equalFields(element, (IJavaWatchpoint)breakpoint)) continue;
                    return (IJavaBreakpoint)breakpoint;
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        }
        return null;
    }

    private boolean equalFields(IMember breakpointField, IJavaWatchpoint watchpoint) throws CoreException {
        return breakpointField.getElementName().equals(watchpoint.getFieldName()) && breakpointField.getDeclaringType().getFullyQualifiedName().equals(watchpoint.getTypeName());
    }

    protected CompilationUnit parseCompilationUnit(ITextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(document.get().toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.isFields(ss);
        }
        return selection instanceof ITextSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection && part instanceof IEditorPart) {
            ITextSelection textSelection = (ITextSelection)selection;
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput editorInput = editorPart.getEditorInput();
            IMember m = null;
            IClassFile classFile = (IClassFile)editorInput.getAdapter(class$org$eclipse$jdt$core$IClassFile == null ? (class$org$eclipse$jdt$core$IClassFile = ToggleBreakpointAdapter.class$("org.eclipse.jdt.core.IClassFile")) : class$org$eclipse$jdt$core$IClassFile);
            if (classFile != null) {
                IJavaElement e = classFile.getElementAt(textSelection.getOffset());
                if (e instanceof IMember) {
                    m = (IMember)e;
                }
            } else {
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit unit = manager.getWorkingCopy(editorInput);
                if (unit != null) {
                    ICompilationUnit iCompilationUnit = unit;
                    synchronized (iCompilationUnit) {
                        unit.reconcile(0, false, null, null);
                    }
                    IJavaElement e = unit.getElementAt(textSelection.getOffset());
                    if (e instanceof IMember) {
                        m = (IMember)e;
                    }
                }
            }
            if (m != null) {
                return new StructuredSelection((Object)m);
            }
        }
        return selection;
    }

    protected static List searchForTypes(String typeName, ILaunch launch) {
        ArrayList<IType> types = new ArrayList<IType>();
        if (launch == null) {
            return types;
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        IJavaProject[] javaProjects = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (configuration != null) {
            try {
                String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                if (projectName.length() != 0) {
                    javaProjects = new IJavaProject[]{JavaCore.create((IProject)workspace.getRoot().getProject(projectName))};
                } else {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    ArrayList<IJavaProject> projectList = new ArrayList<IJavaProject>();
                    int numProjects = projects.length;
                    for (int i = 0; i < numProjects; ++i) {
                        IProject project = projects[i];
                        if (!project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                        projectList.add(JavaCore.create((IProject)project));
                    }
                    javaProjects = new IJavaProject[projectList.size()];
                    projectList.toArray(javaProjects);
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        if (javaProjects == null) {
            return types;
        }
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(javaProjects, (boolean)true);
        ArrayList typeRefsFound = new ArrayList(3);
        TypeInfoRequestor requestor = new TypeInfoRequestor(typeRefsFound);
        try {
            engine.searchAllTypeNames(ToggleBreakpointAdapter.getPackage(typeName), ToggleBreakpointAdapter.getTypeName(typeName), 8, 5, scope, (ITypeNameRequestor)requestor, 3, null);
        }
        catch (JavaModelException x) {
            JDIDebugUIPlugin.log(x);
            return types;
        }
        Iterator iter = typeRefsFound.iterator();
        TypeInfo typeInfo = null;
        while (iter.hasNext()) {
            typeInfo = (TypeInfo)iter.next();
            try {
                types.add(typeInfo.resolveType(scope));
            }
            catch (JavaModelException jme) {
                JDIDebugUIPlugin.log(jme);
            }
        }
        return types;
    }

    private static char[] getPackage(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index == -1) {
            return new char[0];
        }
        return fullyQualifiedName.substring(0, index).toCharArray();
    }

    private static char[] getTypeName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        String typeName = fullyQualifiedName;
        if (index >= 0) {
            typeName = fullyQualifiedName.substring(index + 1);
        }
        if ((index = typeName.lastIndexOf(36)) >= 0) {
            typeName = typeName.substring(index + 1);
        }
        return typeName.toCharArray();
    }

    private IField getField(IJavaFieldVariable variable) {
        String varName = null;
        try {
            varName = variable.getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        String declaringType = null;
        try {
            declaringType = variable.getDeclaringType().getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        List types = ToggleBreakpointAdapter.searchForTypes(declaringType, variable.getLaunch());
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            IField field = type.getField(varName);
            if (!field.exists()) continue;
            return field;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

