/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.HashSet;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.debug.ui.launcher.AppletLaunchConfigurationUtils;

public class JavaElementPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_APPLET = "isApplet";
    private static final String PROPERTY_HAS_MAIN_TYPE = "hasMainType";
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IJavaElement javaElement = null;
        if (receiver instanceof IAdaptable) {
            javaElement = (IJavaElement)((IAdaptable)receiver).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = JavaElementPropertyTester.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        }
        if (javaElement != null && !javaElement.exists()) {
            return false;
        }
        if (javaElement instanceof IJavaProject || javaElement instanceof IPackageFragmentRoot || javaElement instanceof IPackageFragment) {
            return true;
        }
        if (javaElement != null) {
            if (PROPERTY_IS_APPLET.equals(method)) {
                return this.isApplet(javaElement);
            }
            if (PROPERTY_HAS_MAIN_TYPE.equals(method)) {
                return this.hasMain(javaElement);
            }
        }
        return false;
    }

    private boolean isApplet(IJavaElement element) {
        try {
            HashSet result = new HashSet();
            AppletLaunchConfigurationUtils.collectTypes(element, (IProgressMonitor)new NullProgressMonitor(), result);
            if (result.size() > 0) {
                return true;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return false;
    }

    private boolean hasMain(IJavaElement element) {
        try {
            IType mainType = null;
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                mainType = cu.getType(Signature.getQualifier((String)cu.getElementName()));
            } else if (element instanceof IClassFile) {
                mainType = ((IClassFile)element).getType();
            } else if (element instanceof IType) {
                mainType = (IType)element;
            } else if (element instanceof IMember) {
                mainType = ((IMember)element).getDeclaringType();
            }
            if (mainType != null && mainType.exists() && JavaModelUtil.hasMainMethod((IType)mainType)) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

