/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class CloseResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.CloseResourceAction";

    public CloseResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.getString("CloseResourceAction.text"));
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.getString("CloseResourceAction.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.close_resource_action_context");
    }

    List getDirtyEditors(List projects) {
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>(0);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        for (int i = 0; i < windows.length; ++i) {
            IWorkbenchPage[] pages = windows[i].getPages();
            for (int j = 0; j < pages.length; ++j) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                for (int k = 0; k < editors.length; ++k) {
                    IFile inputFile;
                    IEditorPart editor = editors[k];
                    IEditorInput input = editor.getEditorInput();
                    if (!(input instanceof IFileEditorInput) || !projects.contains((inputFile = ((IFileEditorInput)input).getFile()).getProject()) || !editor.isDirty()) continue;
                    dirtyEditors.add(editor);
                }
            }
        }
        return dirtyEditors;
    }

    List getEditorsToSave(List dirtyEditors) {
        if (dirtyEditors.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<IEditorPart> saveEditors = new ArrayList<IEditorPart>(0);
        ArrayList<IFile> dirtyInputs = new ArrayList<IFile>(0);
        Iterator iter = dirtyEditors.iterator();
        while (iter.hasNext()) {
            IEditorPart editor = (IEditorPart)iter.next();
            IEditorInput input = editor.getEditorInput();
            IFile inputFile = ((IFileEditorInput)input).getFile();
            if (dirtyInputs.contains(inputFile)) continue;
            dirtyInputs.add(inputFile);
            saveEditors.add(editor);
        }
        AdaptableList input = new AdaptableList(saveEditors);
        ListSelectionDialog dlg = new ListSelectionDialog(this.getShell(), (Object)input, (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), IDEWorkbenchMessages.getString("EditorManager.saveResourcesMessage"));
        dlg.setInitialSelections(saveEditors.toArray(new Object[saveEditors.size()]));
        dlg.setTitle(IDEWorkbenchMessages.getString("EditorManager.saveResourcesTitle"));
        int result = dlg.open();
        if (result == 1) {
            return null;
        }
        return Arrays.asList(dlg.getResult());
    }

    String getOperationMessage() {
        return "";
    }

    String getProblemsMessage() {
        return IDEWorkbenchMessages.getString("CloseResourceAction.problemMessage");
    }

    String getProblemsTitle() {
        return IDEWorkbenchMessages.getString("CloseResourceAction.title");
    }

    void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).close(monitor);
    }

    public void run() {
        if (!this.saveDirtyEditors()) {
            return;
        }
        super.run();
    }

    boolean saveDirtyEditors() {
        List projects = this.getSelectedResources();
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        final List dirtyEditors = this.getDirtyEditors(projects);
        final List saveEditors = this.getEditorsToSave(dirtyEditors);
        if (saveEditors == null) {
            return false;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Iterator iter = dirtyEditors.iterator();
                while (iter.hasNext()) {
                    IEditorPart editor = (IEditorPart)iter.next();
                    IWorkbenchPage page = editor.getEditorSite().getPage();
                    if (saveEditors.contains(editor)) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    page.closeEditor(editor, false);
                }
            }
        });
        return true;
    }

    boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject currentResource = (IProject)resources.next();
            if (!currentResource.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            for (int i = 0; i < projDeltas.length; ++i) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) == 0 || !sel.contains(projDelta.getResource())) continue;
                this.selectionChanged(this.getStructuredSelection());
                return;
            }
        }
    }
}

