/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.eclipse.ant.internal.ui.dtd.IAttribute;
import org.eclipse.ant.internal.ui.dtd.IDfm;
import org.eclipse.ant.internal.ui.dtd.IElement;
import org.eclipse.ant.internal.ui.dtd.ISchema;
import org.eclipse.ant.internal.ui.dtd.ParseError;
import org.eclipse.ant.internal.ui.dtd.Parser;
import org.eclipse.ant.internal.ui.editor.AntCompletionProposal;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.editor.TaskDescriptionProvider;
import org.eclipse.ant.internal.ui.editor.model.AntDefiningTaskNode;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntProjectNode;
import org.eclipse.ant.internal.ui.editor.model.AntTargetNode;
import org.eclipse.ant.internal.ui.editor.model.AntTaskNode;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.templates.AntContext;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateAccess;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateProposal;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AntEditorCompletionProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor {
    private Comparator proposalComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int type2;
            int type1 = this.getProposalType(o1);
            if (type1 != (type2 = this.getProposalType(o2))) {
                if (type1 > type2) {
                    return 1;
                }
                return -1;
            }
            String string1 = ((ICompletionProposal)o1).getDisplayString();
            String string2 = ((ICompletionProposal)o2).getDisplayString();
            return string1.compareToIgnoreCase(string2);
        }

        private int getProposalType(Object o) {
            if (o instanceof AntCompletionProposal) {
                return ((AntCompletionProposal)o).getType();
            }
            return 1;
        }
    };
    protected static final int PROPOSAL_MODE_NONE = 0;
    protected static final int PROPOSAL_MODE_BUILDFILE = 1;
    protected static final int PROPOSAL_MODE_TASK_PROPOSAL = 2;
    protected static final int PROPOSAL_MODE_PROPERTY_PROPOSAL = 3;
    protected static final int PROPOSAL_MODE_ATTRIBUTE_PROPOSAL = 4;
    protected static final int PROPOSAL_MODE_TASK_PROPOSAL_CLOSING = 5;
    protected static final int PROPOSAL_MODE_ATTRIBUTE_VALUE_PROPOSAL = 6;
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    private int additionalProposalOffset = -1;
    private static final String ANT_DTD_FILENAME = "/ant1.6.0.dtd";
    protected static ISchema dtd;
    protected int cursorPosition = -1;
    private ITextViewer viewer;
    private char[] autoActivationChars = null;
    private TaskDescriptionProvider descriptionProvider = TaskDescriptionProvider.getDefault();
    private String errorMessage;
    protected AntModel antModel;
    private int currentProposalMode = -1;
    protected String currentPrefix = null;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$MacroInstance;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Reference;

    public AntEditorCompletionProcessor(AntModel model) {
        if (dtd == null) {
            try {
                dtd = this.parseDtd();
            }
            catch (IOException e) {
                AntUIPlugin.log(e);
            }
            catch (ParseError e) {
                AntUIPlugin.log(e);
            }
        }
        this.antModel = model;
    }

    private ISchema parseDtd() throws ParseError, IOException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(ANT_DTD_FILENAME);
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        Parser parser = new Parser();
        ISchema schema = parser.parseDTD(reader, "project");
        reader.close();
        return schema;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer refViewer, int documentOffset) {
        this.viewer = refViewer;
        ICompletionProposal[] matchingProposals = this.determineProposals();
        ICompletionProposal[] matchingTemplateProposals = this.determineTemplateProposals(refViewer, documentOffset);
        this.currentPrefix = null;
        this.currentProposalMode = -1;
        return this.mergeProposals(matchingProposals, matchingTemplateProposals);
    }

    private ICompletionProposal[] determineTemplateProposals(ITextViewer refViewer, int documentOffset) {
        ICompletionProposal[] matchingTemplateProposals;
        String prefix = this.getCurrentPrefix();
        if (prefix.length() == 0) {
            matchingTemplateProposals = super.computeCompletionProposals(refViewer, documentOffset);
        } else {
            ICompletionProposal[] templateProposals = super.computeCompletionProposals(refViewer, documentOffset);
            ArrayList<ICompletionProposal> templateProposalList = new ArrayList<ICompletionProposal>(templateProposals.length);
            for (int i = 0; i < templateProposals.length; ++i) {
                if (!templateProposals[i].getDisplayString().toLowerCase().startsWith(prefix)) continue;
                templateProposalList.add(templateProposals[i]);
            }
            matchingTemplateProposals = templateProposalList.toArray(new ICompletionProposal[templateProposalList.size()]);
        }
        return matchingTemplateProposals;
    }

    private ICompletionProposal[] mergeProposals(ICompletionProposal[] proposals1, ICompletionProposal[] proposals2) {
        ICompletionProposal[] combinedProposals = new ICompletionProposal[proposals1.length + proposals2.length];
        System.arraycopy(proposals1, 0, combinedProposals, 0, proposals1.length);
        System.arraycopy(proposals2, 0, combinedProposals, proposals1.length, proposals2.length);
        Arrays.sort(combinedProposals, this.proposalComparator);
        return combinedProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer refViewer, int documentOffset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private ICompletionProposal[] determineProposals() {
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        this.cursorPosition = selection.getOffset() + selection.getLength();
        IDocument doc = this.viewer.getDocument();
        try {
            this.lineNumber = doc.getLineOfOffset(this.cursorPosition);
            this.columnNumber = this.cursorPosition - doc.getLineOffset(this.lineNumber);
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
        String prefix = this.getCurrentPrefix();
        if (prefix == null || this.cursorPosition == -1) {
            AntUIPlugin.getStandardDisplay().beep();
            return NO_PROPOSALS;
        }
        ICompletionProposal[] proposals = this.getProposalsFromDocument(doc, prefix);
        return proposals;
    }

    protected ICompletionProposal[] getProposalsFromDocument(IDocument document, String prefix) {
        String taskString = null;
        ICompletionProposal[] proposals = null;
        this.currentProposalMode = this.determineProposalMode(document, this.cursorPosition, prefix);
        switch (this.currentProposalMode) {
            case 4: {
                taskString = this.getTaskStringFromDocumentStringToPrefix(document.get().substring(0, this.cursorPosition - prefix.length()));
                proposals = this.getAttributeProposals(taskString, prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.28");
                break;
            }
            case 2: {
                String parentName = this.getParentName(document, this.lineNumber, this.columnNumber);
                if (parentName == null || parentName.length() == 0) {
                    proposals = NO_PROPOSALS;
                    this.currentProposalMode = 0;
                } else {
                    proposals = this.getTaskProposals(document, parentName, prefix);
                }
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.29");
                break;
            }
            case 1: {
                proposals = this.getBuildFileProposals(document, prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.29");
                break;
            }
            case 5: {
                ICompletionProposal proposal = this.getClosingTaskProposal(this.getOpenElementName(), prefix, true);
                if (proposal == null) {
                    this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.30");
                    proposals = NO_PROPOSALS;
                    break;
                }
                proposals = new ICompletionProposal[]{proposal};
                break;
            }
            case 6: {
                String textToSearch = document.get().substring(0, this.cursorPosition - prefix.length());
                taskString = this.getTaskStringFromDocumentStringToPrefix(textToSearch);
                String attributeString = this.getAttributeStringFromDocumentStringToPrefix(textToSearch);
                proposals = "target".equalsIgnoreCase(taskString) ? this.getTargetAttributeValueProposals(document, textToSearch, prefix, attributeString) : ("refid".equalsIgnoreCase(attributeString) ? this.getReferencesValueProposals(prefix) : this.getAttributeValueProposals(taskString, attributeString, prefix));
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.31");
                break;
            }
            case 3: {
                proposals = this.getPropertyProposals(document, prefix, this.cursorPosition);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.32");
                break;
            }
            default: {
                proposals = NO_PROPOSALS;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.33");
            }
        }
        if (proposals.length > 0) {
            this.errorMessage = "";
        }
        return proposals;
    }

    private ICompletionProposal[] getReferencesValueProposals(String prefix) {
        Project project = this.antModel.getProjectNode().getProject();
        Hashtable references = project.getReferences();
        if (references.isEmpty()) {
            return NO_PROPOSALS;
        }
        Set refIds = references.keySet();
        AntElementNode node = this.antModel.getNode(this.cursorPosition, false);
        while (node.getParentNode() instanceof AntTaskNode) {
            node = node.getParentNode();
        }
        String id = null;
        if (node instanceof AntTaskNode) {
            id = ((AntTaskNode)node).getId();
        }
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>(refIds.size());
        int i = 0;
        Iterator iter = refIds.iterator();
        while (iter.hasNext()) {
            String refId = (String)iter.next();
            if (!refId.equals(id) && (prefix.length() == 0 || refId.toLowerCase().startsWith(prefix))) {
                AntCompletionProposal proposal = new AntCompletionProposal(refId, this.cursorPosition - prefix.length(), prefix.length(), refId.length(), null, refId, null, 1);
                proposals.add(proposal);
            }
            ++i;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected ICompletionProposal[] getTargetAttributeValueProposals(IDocument document, String textToSearch, String prefix, String attributeName) {
        if (attributeName.equalsIgnoreCase("depends")) {
            return this.getDependsValueProposals(document, prefix);
        }
        if ((attributeName.equalsIgnoreCase("if") || attributeName.equalsIgnoreCase("unless")) && !textToSearch.trim().endsWith(",")) {
            return this.getPropertyProposals(document, prefix, this.cursorPosition);
        }
        return NO_PROPOSALS;
    }

    private ICompletionProposal[] getDependsValueProposals(IDocument document, String prefix) {
        ArrayList<String> possibleDependencies = new ArrayList<String>();
        String currentTargetName = this.getEnclosingTargetName(document, this.lineNumber, this.columnNumber);
        if (currentTargetName == null) {
            return NO_PROPOSALS;
        }
        Map targets = this.getTargets();
        Set targetNames = targets.keySet();
        Iterator itr = targetNames.iterator();
        Enumeration dependencies = null;
        while (itr.hasNext()) {
            String targetName = (String)itr.next();
            if (targetName.equals(currentTargetName)) {
                Target currentTarget = (Target)targets.get(targetName);
                dependencies = currentTarget.getDependencies();
                continue;
            }
            if (!targetName.toLowerCase().startsWith(prefix) || targetName.length() <= 0) continue;
            possibleDependencies.add(targetName);
        }
        if (dependencies != null) {
            while (dependencies.hasMoreElements()) {
                possibleDependencies.remove(dependencies.nextElement());
            }
        }
        ICompletionProposal[] proposals = new ICompletionProposal[possibleDependencies.size()];
        int i = 0;
        Iterator iter = possibleDependencies.iterator();
        while (iter.hasNext()) {
            String targetName = (String)iter.next();
            AntCompletionProposal proposal = new AntCompletionProposal(targetName, this.cursorPosition - prefix.length(), prefix.length(), targetName.length(), null, targetName, null, 1);
            proposals[i] = proposal;
            ++i;
        }
        return proposals;
    }

    protected ICompletionProposal[] getAttributeProposals(String taskName, String prefix) {
        ArrayList proposals = new ArrayList();
        IElement element = dtd.getElement(taskName);
        if (element != null) {
            Iterator keys = element.getAttributes().keySet().iterator();
            while (keys.hasNext()) {
                String attrName = (String)keys.next();
                if (prefix.length() != 0 && !attrName.toLowerCase().startsWith(prefix)) continue;
                IAttribute dtdAttributes = (IAttribute)element.getAttributes().get(attrName);
                String replacementString = attrName + "=\"\"";
                String displayString = attrName;
                String[] items = dtdAttributes.getEnum();
                if (items != null) {
                    if (items.length > 1) {
                        displayString = displayString + " - (";
                    }
                    for (int i = 0; i < items.length; ++i) {
                        displayString = displayString + items[i];
                        displayString = i + 1 < items.length ? displayString + " | " : displayString + ")";
                    }
                }
                this.addAttributeProposal(taskName, prefix, proposals, attrName, replacementString, displayString, true);
            }
        } else {
            Class taskClass = this.getTaskClass(taskName);
            if (taskClass != null) {
                if (taskClass == (class$org$apache$tools$ant$taskdefs$MacroInstance == null ? (class$org$apache$tools$ant$taskdefs$MacroInstance = AntEditorCompletionProcessor.class$("org.apache.tools.ant.taskdefs.MacroInstance")) : class$org$apache$tools$ant$taskdefs$MacroInstance)) {
                    this.addMacroDefAttributeProposals(taskName, prefix, proposals);
                } else {
                    IntrospectionHelper helper = this.getIntrospectionHelper(taskClass);
                    if (helper != null) {
                        this.addAttributeProposals(helper, taskName, prefix, proposals);
                    }
                }
            } else {
                IntrospectionHelper helper;
                Class nestedType = this.getNestedType();
                if (nestedType != null && (helper = this.getIntrospectionHelper(nestedType)) != null) {
                    this.addAttributeProposals(helper, taskName, prefix, proposals);
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void addAttributeProposals(IntrospectionHelper helper, String taskName, String prefix, List proposals) {
        Enumeration attributes = helper.getAttributes();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            if (prefix.length() != 0 && !attribute.toLowerCase().startsWith(prefix)) continue;
            String replacementString = attribute + "=\"\"";
            this.addAttributeProposal(taskName, prefix, proposals, attribute, replacementString, attribute, false);
        }
    }

    private Class getNestedType() {
        IntrospectionHelper helper;
        Class taskClass;
        String parentName;
        AntElementNode currentNode = this.antModel.getNode(this.cursorPosition, false);
        AntElementNode parent = currentNode.getParentNode();
        if (parent instanceof AntTaskNode && this.hasNestedElements(parentName = parent.getName()) && (taskClass = this.getTaskClass(parentName)) != null && (helper = this.getIntrospectionHelper(taskClass)) != null) {
            Class nestedType = null;
            try {
                nestedType = helper.getElementType(currentNode.getName());
            }
            catch (BuildException be) {
                // empty catch block
            }
            return nestedType;
        }
        return null;
    }

    private IntrospectionHelper getIntrospectionHelper(Class taskClass) {
        IntrospectionHelper helper = null;
        try {
            helper = IntrospectionHelper.getHelper((Project)this.antModel.getProjectNode().getProject(), (Class)taskClass);
        }
        catch (NoClassDefFoundError e) {
            AntUIPlugin.log(MessageFormat.format(AntEditorMessages.getString("AntEditorCompletionProcessor.0"), taskClass.getName()), e);
        }
        return helper;
    }

    private void addMacroDefAttributeProposals(String taskName, String prefix, List proposals) {
        this.currentProposalMode = 4;
        AntProjectNode projectNode = this.antModel.getProjectNode();
        AntDefiningTaskNode node = projectNode.getDefininingTaskNode(taskName);
        Object task = node.getRealTask();
        if (!(task instanceof MacroDef)) {
            return;
        }
        List attributes = ((MacroDef)task).getAttributes();
        Iterator itr = attributes.iterator();
        while (itr.hasNext()) {
            String deflt;
            MacroDef.Attribute attribute = (MacroDef.Attribute)itr.next();
            String attributeName = attribute.getName();
            if (prefix.length() != 0 && !attributeName.toLowerCase().startsWith(prefix)) continue;
            String replacementString = attributeName + "=\"\"";
            String proposalInfo = null;
            String description = attribute.getDescription();
            if (description != null) {
                proposalInfo = description;
            }
            if ((deflt = attribute.getDefault()) != null && deflt.length() > 0) {
                proposalInfo = proposalInfo == null ? "<BR><BR>" : (proposalInfo = proposalInfo + "<BR><BR>");
                proposalInfo = proposalInfo + MessageFormat.format(AntEditorMessages.getString("AntEditorCompletionProcessor.59"), deflt);
            }
            AntCompletionProposal proposal = new AntCompletionProposal(replacementString, this.cursorPosition - prefix.length(), prefix.length(), attributeName.length() + 2, null, attributeName, proposalInfo, 1);
            proposals.add(proposal);
        }
    }

    private void addMacroDefElementProposals(String taskName, String prefix, List proposals) {
        this.currentProposalMode = 4;
        AntProjectNode projectNode = this.antModel.getProjectNode();
        AntDefiningTaskNode node = projectNode.getDefininingTaskNode(taskName);
        Object task = node.getRealTask();
        if (!(task instanceof MacroDef)) {
            return;
        }
        Map elements = ((MacroDef)task).getElements();
        Iterator itr = elements.keySet().iterator();
        while (itr.hasNext()) {
            String elementName = (String)itr.next();
            if (prefix.length() != 0 && !elementName.toLowerCase().startsWith(prefix)) continue;
            MacroDef.TemplateElement element = (MacroDef.TemplateElement)elements.get(elementName);
            String replacementString = MessageFormat.format("<{0}>\n</{1}>", elementName, elementName);
            String proposalInfo = null;
            String description = element.getDescription();
            if (description != null) {
                proposalInfo = description;
            }
            proposalInfo = proposalInfo == null ? "<BR><BR>" : (proposalInfo = proposalInfo + "<BR><BR>");
            proposalInfo = element.isOptional() ? proposalInfo + AntEditorMessages.getString("AntEditorCompletionProcessor.1") : proposalInfo + AntEditorMessages.getString("AntEditorCompletionProcessor.2");
            AntCompletionProposal proposal = new AntCompletionProposal(replacementString, this.cursorPosition - prefix.length(), prefix.length(), elementName.length() + 2, null, elementName, proposalInfo, 1);
            proposals.add(proposal);
        }
    }

    private void addAttributeProposal(String taskName, String prefix, List proposals, String attrName, String replacementString, String displayString, boolean lookupDescription) {
        String proposalInfo = null;
        if (lookupDescription) {
            String description;
            String required = this.descriptionProvider.getRequiredAttributeForTaskAttribute(taskName, attrName);
            if (required != null && required.length() > 0) {
                proposalInfo = AntEditorMessages.getString("AntEditorCompletionProcessor.Required___4") + required;
                proposalInfo = proposalInfo + "<BR><BR>";
            }
            if ((description = this.descriptionProvider.getDescriptionForTaskAttribute(taskName, attrName)) != null) {
                proposalInfo = proposalInfo == null ? "" : proposalInfo;
                proposalInfo = proposalInfo + description;
            }
        }
        AntCompletionProposal proposal = new AntCompletionProposal(replacementString, this.cursorPosition - prefix.length(), prefix.length(), attrName.length() + 2, null, displayString, proposalInfo, 1);
        proposals.add(proposal);
    }

    private ICompletionProposal[] getAttributeValueProposals(String taskName, String attributeName, String prefix) {
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>();
        IElement taskElement = dtd.getElement(taskName);
        if (taskElement != null) {
            String[] items;
            IAttribute attribute = (IAttribute)taskElement.getAttributes().get(attributeName);
            if (attribute != null && (items = attribute.getEnum()) != null) {
                for (int i = 0; i < items.length; ++i) {
                    String item = items[i];
                    if (prefix.length() != 0 && !item.toLowerCase().startsWith(prefix)) continue;
                    proposals.add(new AntCompletionProposal(item, this.cursorPosition - prefix.length(), prefix.length(), item.length(), null, item, null, 1));
                }
            }
        } else {
            Class taskClass = this.getTaskClass(taskName);
            if (taskClass != null) {
                IntrospectionHelper helper = this.getIntrospectionHelper(taskClass);
                if (helper != null) {
                    this.addAttributeValueProposals(helper, attributeName, prefix, proposals);
                }
            } else {
                IntrospectionHelper helper;
                Class nestedType = this.getNestedType();
                if (nestedType != null && (helper = this.getIntrospectionHelper(nestedType)) != null) {
                    this.addAttributeValueProposals(helper, attributeName, prefix, proposals);
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void addAttributeValueProposals(IntrospectionHelper helper, String attributeName, String prefix, List proposals) {
        Enumeration attributes = helper.getAttributes();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            if (!attribute.equals(attributeName)) continue;
            Class attributeType = helper.getAttributeType(attribute);
            this.addAttributeValueProposalsForAttributeType(attributeType, prefix, proposals);
            break;
        }
    }

    private void addAttributeValueProposalsForAttributeType(Class attributeType, String prefix, List proposals) {
        if ((attributeType == Boolean.TYPE || attributeType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AntEditorCompletionProcessor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) && prefix.length() <= 5) {
            this.addBooleanAttributeValueProposals(prefix, proposals);
        } else if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? (class$org$apache$tools$ant$types$EnumeratedAttribute = AntEditorCompletionProcessor.class$("org.apache.tools.ant.types.EnumeratedAttribute")) : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(attributeType)) {
            try {
                this.addEnumeratedAttributeValueProposals(attributeType, prefix, proposals);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {}
        } else if ((class$org$apache$tools$ant$types$Reference == null ? (class$org$apache$tools$ant$types$Reference = AntEditorCompletionProcessor.class$("org.apache.tools.ant.types.Reference")) : class$org$apache$tools$ant$types$Reference) == attributeType) {
            proposals.addAll(Arrays.asList(this.getReferencesValueProposals(prefix)));
        }
    }

    private void addEnumeratedAttributeValueProposals(Class type, String prefix, List proposals) throws InstantiationException, IllegalAccessException {
        EnumeratedAttribute ea = (EnumeratedAttribute)type.newInstance();
        String[] values = ea.getValues();
        for (int i = 0; i < values.length; ++i) {
            String enumerated = values[i].toLowerCase();
            if (prefix.length() != 0 && !enumerated.startsWith(prefix)) continue;
            proposals.add(new AntCompletionProposal(enumerated, this.cursorPosition - prefix.length(), prefix.length(), enumerated.length(), null, enumerated, null, 1));
        }
    }

    private void addBooleanAttributeValueProposals(String prefix, List proposals) {
        String[] booleanValues = new String[]{"true", "false", "on", "off", "yes", "no"};
        for (int i = 0; i < booleanValues.length; ++i) {
            String booleanAssist = booleanValues[i].toLowerCase();
            if (prefix.length() != 0 && !booleanAssist.startsWith(prefix)) continue;
            proposals.add(new AntCompletionProposal(booleanAssist, this.cursorPosition - prefix.length(), prefix.length(), booleanAssist.length(), null, booleanAssist, null, 1));
        }
    }

    protected ICompletionProposal[] getPropertyProposals(IDocument document, String prefix, int aCursorPosition) {
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>();
        HashMap<String, AntCompletionProposal> displayStringToProposals = new HashMap<String, AntCompletionProposal>();
        Map properties = this.findPropertiesFromDocument();
        Image image = AntUIImages.getImage("org.eclipse.ant.ui.IMG_PROPERTY");
        int replacementLength = prefix.length();
        int replacementOffset = 0;
        String text = document.get();
        String stringToPrefix = text.substring(0, aCursorPosition - prefix.length());
        String lastTwoCharacters = stringToPrefix.substring(stringToPrefix.length() - 2, stringToPrefix.length());
        boolean appendBraces = true;
        if (lastTwoCharacters.equals("${")) {
            replacementLength += 2;
            replacementOffset = aCursorPosition - prefix.length() - 2;
        } else if (lastTwoCharacters.endsWith("$")) {
            ++replacementLength;
            replacementOffset = aCursorPosition - prefix.length() - 1;
        } else {
            replacementOffset = aCursorPosition - prefix.length();
            appendBraces = false;
        }
        if (text.length() > aCursorPosition && text.charAt(aCursorPosition) == '}') {
            ++replacementLength;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            if (prefix.length() != 0 && !propertyName.toLowerCase().startsWith(prefix)) continue;
            String additionalPropertyInfo = (String)properties.get(propertyName);
            StringBuffer replacementString = new StringBuffer();
            if (appendBraces) {
                replacementString.append("${");
            }
            replacementString.append(propertyName);
            if (appendBraces) {
                replacementString.append('}');
            }
            if (displayStringToProposals.get(propertyName) != null) continue;
            AntCompletionProposal proposal = new AntCompletionProposal(replacementString.toString(), replacementOffset, replacementLength, replacementString.length(), image, propertyName, additionalPropertyInfo, 2);
            proposals.add(proposal);
            displayStringToProposals.put(propertyName, proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected ICompletionProposal[] getTaskProposals(IDocument document, String parentName, String prefix) {
        ICompletionProposal proposal;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(250);
        if (this.areTasksOrTypesValidChildren(parentName)) {
            Project project = this.antModel.getProjectNode().getProject();
            Hashtable tasksAndTypes = ComponentHelper.getComponentHelper((Project)project).getAntTypeTable();
            this.createProposals(document, prefix, proposals, tasksAndTypes);
            if (parentName.equals("project") && "target".startsWith(prefix)) {
                proposals.add(this.newCompletionProposal(document, prefix, "target"));
            }
        } else {
            IElement parent = dtd.getElement(parentName);
            if (parent != null) {
                IDfm dfm = parent.getDfm();
                String[] accepts = dfm.getAccepts();
                for (int i = 0; i < accepts.length; ++i) {
                    String elementName = accepts[i];
                    if (prefix.length() != 0 && !elementName.toLowerCase().startsWith(prefix)) continue;
                    proposal = this.newCompletionProposal(document, prefix, elementName);
                    proposals.add(proposal);
                }
            } else {
                Class taskClass = this.getTaskClass(parentName);
                if (taskClass != null) {
                    if (taskClass == (class$org$apache$tools$ant$taskdefs$MacroInstance == null ? (class$org$apache$tools$ant$taskdefs$MacroInstance = AntEditorCompletionProcessor.class$("org.apache.tools.ant.taskdefs.MacroInstance")) : class$org$apache$tools$ant$taskdefs$MacroInstance)) {
                        this.addMacroDefElementProposals(parentName, prefix, proposals);
                    } else {
                        IntrospectionHelper helper = this.getIntrospectionHelper(taskClass);
                        if (helper != null) {
                            Enumeration nested = helper.getNestedElements();
                            while (nested.hasMoreElements()) {
                                String nestedElement = (String)nested.nextElement();
                                if (prefix.length() != 0 && !nestedElement.toLowerCase().startsWith(prefix)) continue;
                                proposal = this.newCompletionProposal(document, prefix, nestedElement);
                                proposals.add(proposal);
                            }
                        }
                    }
                }
            }
        }
        proposal = this.getClosingTaskProposal(this.getOpenElementName(), prefix, false);
        if (proposal != null) {
            proposals.add(proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean areTasksOrTypesValidChildren(String parentName) {
        return parentName == "project" || parentName == "target" || parentName == "sequential" || parentName == "presetdef" || parentName == "parallel" || parentName == "daemons";
    }

    protected ICompletionProposal[] getBuildFileProposals(IDocument document, String prefix) {
        String rootElementName = "project";
        IElement rootElement = dtd.getElement(rootElementName);
        if (rootElement != null && rootElementName.toLowerCase().startsWith(prefix)) {
            ICompletionProposal proposal = this.newCompletionProposal(document, prefix, rootElementName);
            return new ICompletionProposal[]{proposal};
        }
        return NO_PROPOSALS;
    }

    private void createProposals(IDocument document, String prefix, List proposals, Map tasks) {
        Iterator keys = tasks.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (prefix.length() != 0 && !key.toLowerCase().startsWith(prefix)) continue;
            ICompletionProposal proposal = this.newCompletionProposal(document, prefix, key);
            proposals.add(proposal);
        }
    }

    private ICompletionProposal newCompletionProposal(IDocument document, String aPrefix, String elementName) {
        int proposalCursorPosition;
        this.additionalProposalOffset = 0;
        Image proposalImage = AntUIImages.getImage("org.eclipse.ant.ui.html_tab_obj");
        String proposalInfo = this.descriptionProvider.getDescriptionForTask(elementName);
        boolean hasNestedElements = this.hasNestedElements(elementName);
        String replacementString = this.getTaskProposalReplacementString(elementName, hasNestedElements);
        int replacementOffset = this.cursorPosition - aPrefix.length();
        int replacementLength = aPrefix.length();
        if (replacementOffset > 0 && document.get().charAt(replacementOffset - 1) == '<') {
            --replacementOffset;
            ++replacementLength;
        }
        if (hasNestedElements) {
            proposalCursorPosition = elementName.length() + 2 + this.additionalProposalOffset;
        } else {
            this.additionalProposalOffset = this.additionalProposalOffset > 0 ? (this.additionalProposalOffset += 2) : ++this.additionalProposalOffset;
            proposalCursorPosition = elementName.length() + this.additionalProposalOffset;
        }
        return new AntCompletionProposal(replacementString, replacementOffset, replacementLength, proposalCursorPosition, proposalImage, elementName, proposalInfo, 1);
    }

    private ICompletionProposal getClosingTaskProposal(String openElementName, String prefix, boolean closingMode) {
        char previousChar = this.getPreviousChar();
        AntCompletionProposal proposal = null;
        if (openElementName != null && (prefix.length() == 0 || openElementName.toLowerCase().startsWith(prefix))) {
            StringBuffer replaceString = new StringBuffer();
            if (!closingMode && previousChar != '/') {
                if (previousChar != '<') {
                    replaceString.append('<');
                }
                replaceString.append('/');
            }
            replaceString.append(openElementName);
            replaceString.append('>');
            StringBuffer displayString = new StringBuffer("</");
            displayString.append(openElementName);
            displayString.append('>');
            proposal = new AntCompletionProposal(replaceString.toString(), this.cursorPosition - prefix.length(), prefix.length(), replaceString.length(), null, displayString.toString(), AntEditorMessages.getString("AntEditorCompletionProcessor.39"), 0);
        }
        return proposal;
    }

    protected char getPreviousChar() {
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        char previousChar = '?';
        try {
            previousChar = this.viewer.getDocument().getChar(offset - 1);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return previousChar;
    }

    private String getTaskProposalReplacementString(String aTaskName, boolean hasNested) {
        StringBuffer replacement = new StringBuffer("<");
        replacement.append(aTaskName);
        Node attributeNode = this.descriptionProvider.getAttributesNode(aTaskName);
        if (attributeNode != null) {
            this.appendRequiredAttributes(replacement, attributeNode);
        } else if ("project".equals(aTaskName)) {
            replacement.append(" default=\"\"");
            this.additionalProposalOffset = 9;
        }
        if (hasNested) {
            replacement.append("></");
            replacement.append(aTaskName);
            replacement.append('>');
        } else {
            replacement.append("/>");
        }
        return replacement.toString();
    }

    private void appendRequiredAttributes(StringBuffer replacement, Node attributeNode) {
        boolean requiredAdded = false;
        NodeList attributes = attributeNode.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String required = this.descriptionProvider.getRequiredOfNode(attribute);
            if (!required.equalsIgnoreCase("yes")) continue;
            String attributeName = this.descriptionProvider.getTaskAttributeName(attribute);
            replacement.append(' ');
            replacement.append(attributeName);
            replacement.append("=\"\"");
            if (requiredAdded) continue;
            this.additionalProposalOffset = attributeName.length() + 2;
            requiredAdded = true;
        }
    }

    private boolean hasNestedElements(String elementName) {
        IntrospectionHelper helper;
        IElement element = dtd.getElement(elementName);
        if (element != null) {
            return !element.isEmpty();
        }
        Class taskClass = this.getTaskClass(elementName);
        if (taskClass != null && (helper = this.getIntrospectionHelper(taskClass)) != null) {
            Enumeration nested = helper.getNestedElements();
            return nested.hasMoreElements();
        }
        return false;
    }

    protected Element findChildElementNamedOf(Element anElement, String aChildElementName) {
        NodeList nodeList = anElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(aChildElementName)) continue;
            return (Element)childNode;
        }
        return null;
    }

    private String getCurrentPrefix() {
        if (this.currentPrefix != null) {
            return this.currentPrefix;
        }
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        IDocument doc = this.viewer.getDocument();
        return this.getPrefixFromDocument(doc.get(), selection.getOffset() + selection.getLength()).toLowerCase();
    }

    protected String getPrefixFromDocument(String aDocumentText, int anOffset) {
        if (this.currentPrefix != null) {
            return this.currentPrefix;
        }
        int startOfWordToken = anOffset;
        char token = 'a';
        if (startOfWordToken > 0) {
            token = aDocumentText.charAt(startOfWordToken - 1);
        }
        while (startOfWordToken > 0 && (Character.isJavaIdentifierPart(token) || '.' == token || '-' == token || ';' == token) && '$' != token && --startOfWordToken != 0) {
            token = aDocumentText.charAt(startOfWordToken - 1);
        }
        this.currentPrefix = startOfWordToken != anOffset ? aDocumentText.substring(startOfWordToken, anOffset).toLowerCase() : "";
        return this.currentPrefix;
    }

    protected int determineProposalMode(IDocument document, int aCursorPosition, String aPrefix) {
        if (this.currentProposalMode != -1) {
            return this.currentProposalMode;
        }
        if (this.antModel != null && this.antModel.getProjectNode() == null) {
            return 1;
        }
        if (document.getLength() == 0 || document.getLength() == 1 && document.get().equals("<")) {
            return 1;
        }
        String text = document.get();
        String stringToPrefix = text.substring(0, aCursorPosition - aPrefix.length());
        if (stringToPrefix.length() == 0) {
            return 1;
        }
        String trimmedString = stringToPrefix.trim();
        char lastChar = '\u0000';
        if (trimmedString.length() <= 0) {
            return 2;
        }
        lastChar = trimmedString.charAt(trimmedString.length() - 1);
        if (stringToPrefix.charAt(stringToPrefix.length() - 1) != lastChar && lastChar != '>' && lastChar != ',') {
            String taskString;
            if (lastChar != '>' && lastChar != '<' && (taskString = this.getTaskStringFromDocumentStringToPrefix(trimmedString)) != null && this.isKnownElement(taskString)) {
                return 4;
            }
        } else if (stringToPrefix.charAt(stringToPrefix.length() - 1) == '\"' || trimmedString.charAt(trimmedString.length() - 1) == ',') {
            String taskString = this.getTaskStringFromDocumentStringToPrefix(trimmedString);
            if (taskString != null && this.isKnownElement(taskString)) {
                return 6;
            }
        } else {
            int spaceIndex = stringToPrefix.lastIndexOf(32);
            int lessThanIndex = stringToPrefix.lastIndexOf(60);
            int greaterThanIndex = stringToPrefix.lastIndexOf(62);
            if (lessThanIndex > spaceIndex && greaterThanIndex < lessThanIndex) {
                int slashIndex = stringToPrefix.lastIndexOf(47);
                if (slashIndex == lessThanIndex + 1) {
                    return 5;
                }
                return 2;
            }
            if (lessThanIndex < greaterThanIndex) {
                if (this.isPropertyProposalMode(stringToPrefix)) {
                    return 3;
                }
                return 2;
            }
        }
        if (this.isPropertyProposalMode(stringToPrefix)) {
            return 3;
        }
        return 0;
    }

    private boolean isPropertyProposalMode(String stringToPrefix) {
        String lastTwoChars;
        return stringToPrefix.length() >= 2 && ((lastTwoChars = stringToPrefix.substring(stringToPrefix.length() - 2, stringToPrefix.length())).equals("${") || stringToPrefix.charAt(stringToPrefix.length() - 1) == '$');
    }

    private String getTaskStringFromDocumentStringToPrefix(String aDocumentStringToPrefix) {
        int lessThanIndex = aDocumentStringToPrefix.lastIndexOf(60);
        if (lessThanIndex > -1) {
            String taskString = aDocumentStringToPrefix.trim();
            int index = (taskString = taskString.substring(lessThanIndex + 1, taskString.length())).indexOf(32);
            if (index > 0) {
                taskString = taskString.substring(0, index);
            }
            if ((index = taskString.indexOf(10)) > 0) {
                taskString = taskString.substring(0, index);
            }
            if ((index = taskString.indexOf(13)) > 0) {
                taskString = taskString.substring(0, index);
            }
            return taskString;
        }
        return null;
    }

    private String getAttributeStringFromDocumentStringToPrefix(String docStringToPrefix) {
        int index = docStringToPrefix.lastIndexOf(61);
        String subString = docStringToPrefix.substring(0, index);
        index = (subString = subString.trim()).lastIndexOf(32);
        if (index > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        if ((index = subString.lastIndexOf(10)) > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        if ((index = subString.lastIndexOf(13)) > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        return this.trimBeginning(subString);
    }

    private String trimBeginning(String toBeTrimmed) {
        int i;
        for (i = 0; i != toBeTrimmed.length() && Character.isWhitespace(toBeTrimmed.charAt(i)); ++i) {
        }
        return toBeTrimmed.substring(i);
    }

    protected boolean isKnownElement(String elementName) {
        if (elementName.equals("target") || elementName.equals("project")) {
            return true;
        }
        AntProjectNode node = this.antModel.getProjectNode();
        if (node != null) {
            Project antProject = node.getProject();
            if (ComponentHelper.getComponentHelper((Project)antProject).getDefinition(elementName) != null) {
                return true;
            }
            if (dtd.getElement(elementName) != null) {
                return true;
            }
            if (this.getNestedType() != null) {
                return true;
            }
        }
        return false;
    }

    private Class getTaskClass(String taskName) {
        AntProjectNode node = this.antModel.getProjectNode();
        if (node != null) {
            Project antProject = node.getProject();
            Hashtable tasksAndTypes = ComponentHelper.getComponentHelper((Project)antProject).getAntTypeTable();
            return (Class)tasksAndTypes.get(taskName);
        }
        return null;
    }

    protected String getParentName(IDocument document, int aLineNumber, int aColumnNumber) {
        if (document.getLength() == 0) {
            return null;
        }
        AntProjectNode project = this.antModel.getProjectNode();
        if (project == null) {
            return null;
        }
        int offset = this.getOffset(document, aLineNumber, aColumnNumber);
        if (offset == -1) {
            return null;
        }
        AntElementNode node = project.getNode(offset);
        if (node == null) {
            node = this.antModel.getOpenElement();
        }
        if (node == null) {
            return "";
        }
        if (node instanceof AntTaskNode) {
            String name = node.getName();
            if (offset <= node.getOffset() + name.length() - 1) {
                node = node.getParentNode();
            } else {
                return name;
            }
        }
        if (node instanceof AntTaskNode) {
            return node.getName();
        }
        if (node instanceof AntTargetNode) {
            return "target";
        }
        return "project";
    }

    private Map findPropertiesFromDocument() {
        Project project = this.antModel.getProjectNode().getProject();
        return project.getProperties();
    }

    private Map getTargets() {
        Project project = this.antModel.getProjectNode().getProject();
        return project.getTargets();
    }

    protected File getEditedFile() {
        IWorkbenchPage page = AntUIPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        FileEditorInput input = (FileEditorInput)editor.getEditorInput();
        String projectPath = input.getFile().getProject().getLocation().toFile().getAbsolutePath();
        String projectRelativeFilePath = input.getFile().getFullPath().removeFirstSegments(1).makeRelative().toString();
        return new File(projectPath + File.separator + projectRelativeFilePath);
    }

    private String getOpenElementName() {
        AntElementNode node = this.antModel.getOpenElement();
        if (node == null) {
            return null;
        }
        return node.getName();
    }

    private String getEnclosingTargetName(IDocument document, int aLineNumber, int aColumnNumber) {
        AntProjectNode project = this.antModel.getProjectNode();
        int offset = this.getOffset(document, aLineNumber, aColumnNumber);
        if (offset == -1) {
            return null;
        }
        AntElementNode node = project.getNode(offset);
        if (node instanceof AntTaskNode) {
            if (!((node = node.getParentNode()) instanceof AntTargetNode)) {
                node = null;
            }
        } else if (node instanceof AntProjectNode) {
            node = null;
        }
        String targetName = null;
        if (node == null || (targetName = ((AntTargetNode)node).getTarget().getName()) == null || targetName.length() == 0) {
            return null;
        }
        return targetName;
    }

    private int getOffset(IDocument document, int line, int column) {
        try {
            return document.getLineOffset(line) + column - 1;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.autoActivationChars = activationSet;
    }

    protected String extractPrefix(ITextViewer textViewer, int offset) {
        return this.getPrefixFromDocument(textViewer.getDocument().get(), offset);
    }

    protected int getRelevance(Template template, String prefix) {
        if (prefix.startsWith("<")) {
            prefix = prefix.substring(1);
        }
        if (template.getName().startsWith(prefix)) {
            return 90;
        }
        return 0;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return AntTemplateAccess.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer textViewer, IRegion region) {
        switch (this.determineProposalMode(textViewer.getDocument(), this.cursorPosition, this.getCurrentPrefix())) {
            case 2: {
                return AntTemplateAccess.getDefault().getContextTypeRegistry().getContextType("org.eclipse.ant.ui.templateContextType.task");
            }
            case 1: {
                return AntTemplateAccess.getDefault().getContextTypeRegistry().getContextType("org.eclipse.ant.ui.templateContextType.buildFile");
            }
        }
        return null;
    }

    protected Image getImage(Template template) {
        return AntUIImages.getImage("org.eclipse.ant.ui.template_obj");
    }

    protected TemplateContext createContext(ITextViewer contextViewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(contextViewer, region);
        if (contextType != null) {
            IDocument document = contextViewer.getDocument();
            return new AntContext(contextType, document, this.antModel, region.getOffset(), region.getLength());
        }
        return null;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, Region region, int relevance) {
        return new AntTemplateProposal(template, context, (IRegion)region, this.getImage(template), relevance);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

