/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.outline.IProblem;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AntEditorMarkerUpdater {
    private AntModel fModel = null;
    private List fCollectedProblems = new ArrayList();
    public static final String BUILDFILE_PROBLEM_MARKER = "org.eclipse.ant.ui.buildFileProblem";
    private IFile fFile = null;

    public synchronized void acceptProblem(IProblem problem) {
        if (this.fCollectedProblems.contains(problem)) {
            return;
        }
        this.fCollectedProblems.add(problem);
    }

    public synchronized void beginReporting() {
        this.fCollectedProblems.clear();
    }

    private void removeProblems() {
        IFile file = this.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        try {
            file.deleteMarkers(BUILDFILE_PROBLEM_MARKER, false, 2);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
    }

    private void createMarker(IProblem problem) {
        IFile file = this.getFile();
        Map attributes = this.getMarkerAttributes(problem);
        try {
            MarkerUtilities.createMarker((IResource)file, (Map)attributes, (String)BUILDFILE_PROBLEM_MARKER);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
    }

    public void setModel(AntModel model) {
        this.fModel = model;
    }

    public synchronized void updateMarkers() {
        IFile file = this.getFile();
        if (file != null) {
            ArrayList problems = new ArrayList(this.fCollectedProblems.size());
            Iterator e = this.fCollectedProblems.iterator();
            while (e.hasNext()) {
                problems.add(e.next());
            }
            this.fCollectedProblems.clear();
            AntEditorMarkerUpdaterJob job = new AntEditorMarkerUpdaterJob(problems);
            job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)file));
            job.schedule();
        }
    }

    private void updateMarkers0(List problems) {
        this.removeProblems();
        if (!this.shouldAddMarkers()) {
            return;
        }
        if (problems.size() > 0) {
            Iterator e = problems.iterator();
            while (e.hasNext()) {
                IProblem problem = (IProblem)e.next();
                this.createMarker(problem);
            }
        }
    }

    private IFile getFile() {
        if (this.fFile == null) {
            this.fFile = this.fModel.getFile();
        }
        return this.fFile;
    }

    private Map getMarkerAttributes(IProblem problem) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(11);
        int severity = 2;
        if (problem.isWarning()) {
            severity = 1;
        }
        MarkerUtilities.setMessage(attributes, (String)problem.getUnmodifiedMessage());
        MarkerUtilities.setLineNumber(attributes, (int)problem.getLineNumber());
        MarkerUtilities.setCharStart(attributes, (int)problem.getOffset());
        MarkerUtilities.setCharEnd(attributes, (int)(problem.getOffset() + problem.getLength()));
        attributes.put("severity", new Integer(severity));
        return attributes;
    }

    private boolean shouldAddMarkers() {
        IContentDescription description;
        IFile file = this.getFile();
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            description = file.getContentDescription();
        }
        catch (CoreException e) {
            return false;
        }
        if (description != null) {
            IContentType type = description.getContentType();
            return type != null && "org.eclipse.ant.core.antBuildFile".equals(type.getId());
        }
        return false;
    }

    class AntEditorMarkerUpdaterJob
    extends WorkspaceJob {
        private final List fProblems;

        public AntEditorMarkerUpdaterJob(List problems) {
            super("Ant editor marker updater job");
            this.fProblems = problems;
            this.setSystem(true);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            AntEditorMarkerUpdater.this.updateMarkers0(this.fProblems);
            return new Status(0, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
        }
    }
}

