/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.editors.text.ColorEditor;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class TextEditorPreferencePage2
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[][] fAppearanceColorListModel = new String[][]{{TextEditorMessages.getString("TextEditorPreferencePage.lineNumberForegroundColor"), "lineNumberColor", null}, {TextEditorMessages.getString("TextEditorPreferencePage.currentLineHighlighColor"), "currentLineColor", null}, {TextEditorMessages.getString("TextEditorPreferencePage.printMarginColor"), "printMarginColor", null}, {TextEditorMessages.getString("TextEditorPreferencePage.selectionForegroundColor"), "AbstractTextEditor.Color.SelectionForeground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault"}, {TextEditorMessages.getString("TextEditorPreferencePage.selectionBackgroundColor"), "AbstractTextEditor.Color.SelectionBackground", "AbstractTextEditor.Color.SelectionBackground.SystemDefault"}};
    private OverlayPreferenceStore fOverlayStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            TextEditorPreferencePage2.this.fOverlayStore.setValue((String)TextEditorPreferencePage2.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            TextEditorPreferencePage2.this.fOverlayStore.setValue((String)TextEditorPreferencePage2.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TextEditorPreferencePage2.this.numberFieldChanged((Text)e.widget);
        }
    };
    private List fAppearanceColorList;
    private ColorEditor fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private boolean fFieldsInitialized = false;
    private ArrayList fMasterSlaveListeners = new ArrayList();

    public TextEditorPreferencePage2() {
        this.setDescription(TextEditorMessages.getString("TextEditorPreferencePage.description"));
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "tabWidth"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.UseCustomCarets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.WideCaret"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionForeground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionForeground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionBackground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionBackground.SystemDefault"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.text_editor_preference_page_context");
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.fOverlayStore.getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = TextEditorMessages.getString("TextEditorPreferencePage.displayedTabWidth");
        this.addTextField(appearanceComposite, label, "tabWidth", 3, 0, true);
        label = TextEditorMessages.getString("TextEditorPreferencePage.printMarginColumn");
        this.addTextField(appearanceComposite, label, "printMarginColumn", 3, 0, true);
        label = TextEditorMessages.getString("TextEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, label, "overviewRuler", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, label, "lineNumberRuler", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, label, "currentLine", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, label, "printMargin", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.accessibility.disableCustomCarets");
        Button master = this.addCheckBox(appearanceComposite, label, "AbstractTextEditor.Accessibility.UseCustomCarets", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.accessibility.wideCaret");
        Button slave = this.addCheckBox(appearanceComposite, label, "AbstractTextEditor.Accessibility.WideCaret", 0);
        this.createDependency(master, "AbstractTextEditor.Accessibility.UseCustomCarets", (Control)slave);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(TextEditorMessages.getString("TextEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(TextEditorMessages.getString("TextEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = TextEditorPreferencePage2.this.fAppearanceColorDefault.getSelection();
                TextEditorPreferencePage2.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = TextEditorPreferencePage2.this.fAppearanceColorList.getSelectionIndex();
                String key = TextEditorPreferencePage2.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    TextEditorPreferencePage2.this.fOverlayStore.setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText(TextEditorMessages.getString("TextEditorPreferencePage.systemDefault"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextEditorPreferencePage2.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TextEditorPreferencePage2.this.fAppearanceColorList.getSelectionIndex();
                String key = TextEditorPreferencePage2.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)TextEditorPreferencePage2.this.fOverlayStore, (String)key, (RGB)TextEditorPreferencePage2.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control control = this.createAppearancePage(parent);
        this.initialize();
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private void initialize() {
        this.initializeFields();
        for (int i = 0; i < this.fAppearanceColorListModel.length; ++i) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (TextEditorPreferencePage2.this.fAppearanceColorList != null && !TextEditorPreferencePage2.this.fAppearanceColorList.isDisposed()) {
                    TextEditorPreferencePage2.this.fAppearanceColorList.select(0);
                    TextEditorPreferencePage2.this.handleAppearanceColorListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
        this.fFieldsInitialized = true;
        this.updateStatus(this.validatePositiveNumber("0"));
        Iterator iter = this.fMasterSlaveListeners.iterator();
        while (iter.hasNext()) {
            SelectionListener listener = (SelectionListener)iter.next();
            listener.widgetSelected(null);
        }
    }

    private void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionBackground")) {
            rgb = this.getControl().getDisplay().getSystemColor(26).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionForeground")) {
            rgb = this.getControl().getDisplay().getSystemColor(27).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        EditorsPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void createDependency(final Button master, String masterKey, final Control slave) {
        TextEditorPreferencePage2.indent(slave);
        boolean masterState = this.fOverlayStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(TextEditorMessages.getString("TextEditorPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(TextEditorMessages.getFormattedString("TextEditorPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException e) {
                status.setError(TextEditorMessages.getFormattedString("TextEditorPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    void updateStatus(IStatus status) {
        if (!this.fFieldsInitialized) {
            return;
        }
        if (!status.matches(4)) {
            for (int i = 0; i < this.fNumberFields.size(); ++i) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = s.getSeverity() > status.getSeverity() ? s : status;
            }
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

