/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.FeatureAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;

public class FeatureReferenceAdapter
extends FeatureAdapter {
    private IFeatureReference featureRef;
    private boolean touched;

    public FeatureReferenceAdapter(IFeatureReference featureRef) {
        this.featureRef = featureRef;
        this.setIncluded(featureRef instanceof IIncludedFeatureReference);
    }

    public IFeature getFeature(IProgressMonitor monitor) throws CoreException {
        return this.featureRef.getFeature(monitor);
    }

    public String getFastLabel() {
        return this.featureRef.getURL().toString();
    }

    public ISite getSite() {
        return this.featureRef.getSite();
    }

    public URL getURL() {
        return this.featureRef.getURL();
    }

    public boolean isOptional() {
        return this.featureRef instanceof IIncludedFeatureReference ? ((IIncludedFeatureReference)this.featureRef).isOptional() : false;
    }

    public void touchIncludedFeatures(IRunnableContext context) {
        IIncludedFeatureReference[] included;
        if (this.touched) {
            return;
        }
        try {
            included = this.getFeature(null).getIncludedFeatureReferences();
        }
        catch (CoreException e) {
            return;
        }
        if (included.length == 0) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress((IFeatureReference[])included){
            private final /* synthetic */ IFeatureReference[] val$included;
            {
                this.val$included = val$included;
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(UpdateUI.getString("SiteBookmark.downloading"), this.val$included.length);
                for (int i = 0; i < this.val$included.length; ++i) {
                    IFeatureReference ref = this.val$included[i];
                    try {
                        monitor.subTask(ref.getURL().toString());
                        ref.getFeature((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        continue;
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                }
                monitor.done();
            }
        };
        try {
            context.run(true, false, op);
            this.touched = true;
        }
        catch (InvocationTargetException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public IFeatureAdapter[] getIncludedFeatures(IProgressMonitor monitor) {
        try {
            IIncludedFeatureReference[] included = this.getFeature(monitor).getIncludedFeatureReferences();
            IFeatureAdapter[] result = new FeatureReferenceAdapter[included.length];
            for (int i = 0; i < included.length; ++i) {
                result[i] = new FeatureReferenceAdapter((IFeatureReference)included[i]);
            }
            return result;
        }
        catch (CoreException e) {
            return new IFeatureAdapter[0];
        }
    }

    public IFeatureReference getFeatureReference() {
        return this.featureRef;
    }
}

