/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.FeatureReferenceAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UIModelObject;

public class SiteCategory
extends UIModelObject {
    Vector children;
    private ICategory category;
    private String name;
    private boolean touched;
    private int featureCount;
    private boolean canceled;
    private SiteBookmark bookmark;

    public SiteCategory(SiteBookmark bookmark, String name, ICategory category) {
        this.bookmark = bookmark;
        if (category == null) {
            this.name = UpdateUI.getString("SiteCategory.other.label");
            this.category = new OtherCategory();
        } else {
            this.name = name;
            this.category = category;
        }
        this.children = new Vector();
    }

    public SiteBookmark getBookmark() {
        return this.bookmark;
    }

    public boolean isOtherCategory() {
        return this.category instanceof OtherCategory;
    }

    public Object[] getChildren() {
        return this.canceled ? new Object[]{} : this.children.toArray();
    }

    public int getChildCount() {
        return this.canceled ? 0 : this.children.size();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.category.getName();
    }

    public String toString() {
        return this.category.getLabel();
    }

    public ICategory getCategory() {
        return this.category;
    }

    void add(Object child) {
        if (child instanceof IFeatureAdapter) {
            ++this.featureCount;
        }
        this.children.add(child);
    }

    public void touchFeatures(IRunnableContext context) {
        if (this.children.size() == 0 || this.touched || this.featureCount == 0) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(UpdateUI.getString("SiteBookmark.downloading"), SiteCategory.this.featureCount);
                for (int i = 0; i < SiteCategory.this.children.size(); ++i) {
                    Object child = SiteCategory.this.children.get(i);
                    if (monitor.isCanceled()) break;
                    if (!(child instanceof IFeatureAdapter)) continue;
                    IFeatureAdapter adapter = (IFeatureAdapter)child;
                    monitor.subTask(adapter.getFastLabel());
                    try {
                        adapter.getFeature((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        continue;
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                }
                monitor.done();
            }
        };
        try {
            context.run(true, true, op);
            this.touched = true;
        }
        catch (InterruptedException e) {
            this.canceled = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void addFeaturesTo(Vector flatList) {
        for (int i = 0; i < this.children.size(); ++i) {
            Object child = this.children.get(i);
            if (child instanceof FeatureReferenceAdapter) {
                FeatureReferenceAdapter cfeature = (FeatureReferenceAdapter)child;
                if (this.findFeature(flatList, cfeature.getFeatureReference()) != null) continue;
                flatList.add(child);
                continue;
            }
            if (!(child instanceof SiteCategory)) continue;
            ((SiteCategory)((Object)child)).addFeaturesTo(flatList);
        }
    }

    private FeatureReferenceAdapter findFeature(Vector flatList, IFeatureReference featureRef) {
        for (int i = 0; i < flatList.size(); ++i) {
            FeatureReferenceAdapter cfeature = (FeatureReferenceAdapter)flatList.get(i);
            if (!cfeature.getFeatureReference().equals(featureRef)) continue;
            return cfeature;
        }
        return null;
    }

    class OtherCategory
    implements ICategory {
        IURLEntry entry = new IURLEntry(this){
            private final /* synthetic */ OtherCategory this$1;
            {
                this.this$1 = this$1;
            }

            public String getAnnotation() {
                return UpdateUI.getString("SiteCategory.other.description");
            }

            public URL getURL() {
                return null;
            }

            public Object getAdapter(Class clazz) {
                return null;
            }

            public int getType() {
                return 0;
            }
        };

        public String getName() {
            return SiteCategory.this.getName();
        }

        public String getLabel() {
            return SiteCategory.this.getName();
        }

        public IURLEntry getDescription() {
            return this.entry;
        }

        public Object getAdapter(Class clazz) {
            return null;
        }
    }
}

