/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.operation.AccumulatingProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

public class ModalContext {
    private static boolean debug = false;
    private static int modalLevel = 0;
    private static boolean runInSeparateThread = true;

    public static boolean canProgressMonitorBeUsed(IProgressMonitor monitor1, IProgressMonitor monitor2) {
        if (monitor1 == monitor2) {
            return true;
        }
        while (monitor1 instanceof ProgressMonitorWrapper) {
            if ((monitor1 = ((ProgressMonitorWrapper)monitor1).getWrappedProgressMonitor()) != monitor2) continue;
            return true;
        }
        return false;
    }

    public static void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static ModalContextThread getCurrentModalContextThread() {
        Thread t = Thread.currentThread();
        if (t instanceof ModalContextThread) {
            return (ModalContextThread)t;
        }
        return null;
    }

    public static int getModalLevel() {
        return modalLevel;
    }

    public static boolean isModalContextThread(Thread thread) {
        return thread instanceof ModalContextThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(IRunnableWithProgress operation, boolean fork, IProgressMonitor monitor, Display display) throws InvocationTargetException, InterruptedException {
        Assert.isTrue(operation != null && monitor != null);
        ++modalLevel;
        try {
            if (monitor != null) {
                monitor.setCanceled(false);
            }
            if (!fork || !runInSeparateThread) {
                ModalContext.runInCurrentThread(operation, monitor);
            } else {
                ModalContextThread t = ModalContext.getCurrentModalContextThread();
                if (t != null) {
                    Assert.isTrue(ModalContext.canProgressMonitorBeUsed(monitor, t.progressMonitor));
                    ModalContext.runInCurrentThread(operation, monitor);
                } else {
                    t = new ModalContextThread(operation, monitor, display);
                    t.start();
                    t.block();
                    Throwable throwable = t.throwable;
                    if (throwable != null) {
                        if (debug && !(throwable instanceof InterruptedException) && !(throwable instanceof OperationCanceledException)) {
                            System.err.println("Exception in modal context operation:");
                            throwable.printStackTrace();
                            System.err.println("Called from:");
                            new InvocationTargetException(null).printStackTrace();
                        }
                        if (throwable instanceof InvocationTargetException) {
                            throw (InvocationTargetException)throwable;
                        }
                        if (throwable instanceof InterruptedException) {
                            throw (InterruptedException)throwable;
                        }
                        if (throwable instanceof OperationCanceledException) {
                            throw new InterruptedException(throwable.getMessage());
                        }
                        throw new InvocationTargetException(throwable);
                    }
                }
            }
        }
        finally {
            --modalLevel;
        }
    }

    private static void runInCurrentThread(IRunnableWithProgress runnable, IProgressMonitor progressMonitor) throws InterruptedException, InvocationTargetException {
        try {
            if (runnable != null) {
                runnable.run(progressMonitor);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InvocationTargetException(e);
        }
        catch (Error e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void setDebugMode(boolean debugMode) {
        debug = debugMode;
    }

    private static class ModalContextThread
    extends Thread {
        private IRunnableWithProgress runnable;
        private Throwable throwable;
        private IProgressMonitor progressMonitor;
        private Display display;
        private volatile boolean continueEventDispatching = true;

        private ModalContextThread(IRunnableWithProgress operation, IProgressMonitor monitor, Display display) {
            super("ModalContext");
            Assert.isTrue(monitor != null && display != null);
            this.runnable = operation;
            this.progressMonitor = new AccumulatingProgressMonitor(monitor, display);
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block8: {
                    try {
                        if (this.runnable == null) break block8;
                        this.runnable.run(this.progressMonitor);
                    }
                    catch (InvocationTargetException e) {
                        this.throwable = e;
                        Object var3_2 = null;
                        this.display.syncExec(new Runnable(this){
                            private final /* synthetic */ ModalContextThread this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public void run() {
                            }
                        });
                        this.continueEventDispatching = false;
                        this.display.asyncExec(null);
                        return;
                    }
                    catch (InterruptedException e) {
                        this.throwable = e;
                        Object var3_3 = null;
                        this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        this.continueEventDispatching = false;
                        this.display.asyncExec(null);
                        return;
                    }
                    catch (RuntimeException e) {
                        this.throwable = e;
                        Object var3_4 = null;
                        this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        this.continueEventDispatching = false;
                        this.display.asyncExec(null);
                        return;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Error e) {
                        this.throwable = e;
                        Object var3_5 = null;
                        this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        this.continueEventDispatching = false;
                        this.display.asyncExec(null);
                        return;
                    }
                }
                Object var3_1 = null;
                this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                this.continueEventDispatching = false;
                this.display.asyncExec(null);
                return;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                this.continueEventDispatching = false;
                this.display.asyncExec(null);
                throw throwable;
            }
        }

        public void block() {
            if (this.display == Display.getCurrent()) {
                while (this.continueEventDispatching) {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
            } else {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    this.throwable = e;
                }
            }
        }
    }
}

