/* File: Inputline.m
 *
 * By: Tom Hageman <Tom_Hageman@RnA.nl>, Gerben Wierda <Gerben_Wierda@RnA.nl>
 * As inspired by Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date: 8 june 1994
 *
 * Modified:
 *	[17-Feb-96 TRH] Fix for Application option munching (like -NXHost).
 *	[12-Mar-96 TRH] add -V -H -A options; add EditMenu keyEquiv support.
 *
 * Copyright: 1994,1996 by R&A
 *
 * This program may be distributed without restriction.
 */

#define USES_APPICON
#define USES_KEYEQUIV
#import "ShellPanel.h"

#define TIMEOUT 0

#define DEFAULTWIDTH	300 //364
#define DEFAULTHEIGHT	60  //185
#define DEFAULTX	250
#define DEFAULTY	450

#define USAGE "\
usage: %s [-p prompt] [-t title] [-T sec] [-n|-e] [-V] [-H] [initial-text]\n"

#define HELP "\
options:\n\
 -p prompt    set prompt\n\
 -t title     set title (default %s)\n\
 -i iconfile  pathname of application icon to use (default none)\n\
 -T seconds   timeout in seconds, 0 means wait indefinitely (default "STRINGIZE(TIMEOUT)")\n\
 -n           don't echo input characters (default if invoked as `Password')\n\
 -e           echo input characters (default otherwise)\n\
 -V           print version string and exit\n\
 -H           this help\n\
"
#if 0
 -x xpos\n\
 -y ypos      set origin of window, in screen coordinates.\n\

#endif

#import "InputlinePanel.m"	// Cheat.  Again.


void timer(DPSTimedEntry teNumber, double now, int status) { exit(status); }


void main(int argc, char *argv[])
{
    const char *prompt = NULL;
    const char *title = NULL;
    const char *initialInput = "";
    const char *iconFile = NULL;
    double timeout = TIMEOUT;
    int option, status = EXIT_SUCCESS;
    BOOL invisible = NO;
    NXPoint topleft = { 0, 0 };
///    NXSize size = { DEFAULTWIDTH, DEFAULTHEIGHT };
    DPSTimedEntry teNumber = NULL;

///    NXApp = [InputlineApp new];
    NXApp = [Application new];
    argc = NXArgc, argv = NXArgv;	// Application may munch options.

    if (strcmp([NXApp appName], "Password") == 0) invisible = YES;

    while ((option = getopt(argc, argv, "p:t:i:x:y:T:neVH")) != EOF)
    {
	switch (option)
	{
	case 'p': prompt = optarg;		break;
	case 't': title = optarg;		break;
	case 'i': iconFile = optarg;		break;
	case 'x': topleft.x = atof(optarg);	break;
	case 'y': topleft.y = atof(optarg);	break;
	case 'T': timeout = atol(optarg);	break;
	case 'n': invisible = YES;		break;
	case 'e': invisible = NO;		break;
	case 'V': status = EXIT_VERSION;	break;
	case 'H': status = EXIT_HELP;		break;
	default : status = EXIT_USAGE;
	}
    }
    HandleUsageHelpVersion(status, USAGE, HELP);

    SetAppIconToFile(iconFile);
    ProvideKeyEquivalents();

    if (prompt == NULL) prompt = (invisible) ? "Password:" : "Input:";
    if (title == NULL) title = [NXApp appName];
/// if (title == NULL) title = (invisible) ? "Password" : "Inputline";
    if (optind < argc) initialInput = argv[optind];

    {
	int context;
	InputlinePanel *panel = [InputlinePanel new];

	if (panel == nil)
	{
		// XXX Error mesage knows about .nib name and search order.
		const char *const *searchPaths = [InputlinePanel resourcePaths];

		fprintf(stderr, "%s: cannot load InputlinePanel.nib,\n", [NXApp appName]);
		fprintf(stderr, "from: %s", [[NXBundle mainBundle] directory]);
		while (*searchPaths) {
			fprintf(stderr, ", %s", *searchPaths++);
		}
		fprintf(stderr, "\n");
		exit(EXIT_FAILURE);
	}

	context = [NXApp activateSelf:YES];

	[panel setTitle:title];
	[panel setPrompt:prompt];

	if ([panel runModalWithInputline:initialInput invisible:invisible])
	{
	    puts([panel inputline]);
	}
	else
	    status = EXIT_FAILURE;

	if(timeout) DPSRemoveTimedEntry(teNumber);

	if (context) (void) [NXApp activate:context];
	[panel free];
    }
    [NXApp free];

    exit(status);
}
