/* File: Menu.m - (Interactive) Unix shell version of Menu
 *
 * By: Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date: 10 November 1992
 *
 * Modified:
 *	[17-Feb-96 TRH] Fix for Application option munching (like -NXHost).
 *	[12-Mar-96 TRH] add -V -H -A options; add EditMenu keyEquiv support.
 *
 * Copyright: 1990, 1991 & 1992 by The Leland Stanford Junior University.
 * This program may be distributed without restriction for non-commercial use.
 */

#import "ShellPanel.h"

#define SELECTOR @selector(stop:)
#define KEYCODE '1'
#define TIMEOUT 30

#define USAGE "\
usage: %s [-c char] [-t title] [-x xpos -y ypos] [-T seconds] [-V] [-H] item [item [...]]\n"

#define HELP "\
options:\n\
 -c char      set first key equivalent\n\
 -t title     set title (default none)\n\
 -x xpos\n\
 -y ypos      set origin of window, in screen coordinates.\n\
 -T seconds   timeout in seconds, 0 means wait indefinitely (default "STRINGIZE(TIMEOUT)")\n\
 -V           print version string and exit\n\
 -H           this help\n\
"


@interface MenuApp : Application { }

- appDidInit:sender;

@end

@implementation MenuApp : Application

- appDidInit:sender
{
	[[self appIcon] orderOut:self];

	return self;
}

@end

void timer(DPSTimedEntry teNumber, double now, int status) { exit(status); }

void main(int argc, char *argv[])
{
	const char *title = NULL;
	double timeout = TIMEOUT;
	unsigned short keyCode = KEYCODE;
	int option, status = EXIT_SUCCESS;
	NXPoint point = { -1.0, -1.0 };
	DPSTimedEntry teNumber = NULL;

	NXApp = [MenuApp new];
	argc = NXArgc, argv = NXArgv;	// Application may munch options.

	while ((option = getopt(argc, argv, "c:t:x:y:T:VH")) != EOF)
		switch (option) {
		case 'c': keyCode = optarg[0]; break;
		case 't': title = optarg; break;
		case 'x': point.x = atof(optarg); break;
		case 'y': point.y = atof(optarg); break;
		case 'T': timeout = atol(optarg); break;
		case 'V': status = EXIT_VERSION; break;
		case 'H': status = EXIT_HELP; break;
		default : status = EXIT_USAGE;
		}
	if (status == EXIT_SUCCESS && optind == argc) status = EXIT_USAGE;

	HandleUsageHelpVersion(status, USAGE, HELP);

	{
		int context = [NXApp activateSelf:YES];
		id menu = [Menu newTitle:(title == NULL) ? [NXApp appName] : title];

		//[TRH} This does not work in 3.2, move to beyond setMainMenu:
		//if(point.x >= 0.0 && point.y >= 0.0) [menu moveTopLeftTo:point.x :point.y];

		for(option = optind; option < argc; option++)
			[[menu addItem:argv[option] action:SELECTOR keyEquivalent:keyCode++] setTarget:NXApp];

		[NXApp setMainMenu:menu];

		//[TRH] moved to beyond setMainMenu in the hope it works. 
		if(point.x >= 0.0 && point.y >= 0.0) [menu moveTopLeftTo:point.x :point.y];

		if(timeout) teNumber = DPSAddTimedEntry(timeout, (DPSTimedEntryProc) &timer, (void *) EXIT_FAILURE, NX_BASETHRESHOLD);

		[NXApp run];

		if(timeout) DPSRemoveTimedEntry(teNumber);

		(void) printf("%s\n", [[[menu itemList] selectedCell] title]);

		if(context) (void) [NXApp activate:context];
	}

	[NXApp free];

	exit(status);
}
