/* File: NIOpen.m - (Interactive) Unix shell version of NIOpenPanel
 *
 * By: Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date: 10 November 1992
 *
 * Modified:
 *	[17-Feb-96 TRH] Fix for Application option munching (like -NXHost).
 *	[15-Mar-96 TRH] add -V -H -i options; add EditMenu keyEquiv support.
 *
 * Copyright: 1991 & 1992 by The Leland Stanford Junior University.
 * This program may be distributed without restriction for non-commercial use.
 */

#define USES_APPICON
#define USES_KEYEQUIV
#import "ShellPanel.h"

#import <nikit/NIOpenPanel.h>

#define USAGE "\
usage: %s [-d directory] [-t title] [-i icon] [-p prompt] [-V] [-H]\n"

#define HELP "\
options:\n\
 -d directory open netinfo directory\n\
 -t title     set title\n\
 -p prompt    set prompt\n\
 -i iconfile  pathname of application icon to use (default none)\n\
 -V           print version string and exit\n\
 -H           this help\n\
"

#define SEPARATOR "/"

const char *fullPath(const char *parent, const char *name)
{
	static char buffer[MAXPATHLEN];

	if(parent == NULL) return name;

	if(strcmp(strcpy(buffer, parent), SEPARATOR) != 0) (void) strcat(buffer, SEPARATOR);

	return strcat(buffer, name);
}

void main(int argc, char *argv[])
{
	const char *iconFile = NULL;
	const char *title = NULL, *prompt = NULL, *path = NULL;
	int option, status = EXIT_SUCCESS;

	NXApp = [Application new];
	argc = NXArgc, argv = NXArgv;	// Application may munch options.

	while ((option = getopt(argc, argv, "d:t:p:i:VH")) != EOF)
		switch (option) {
		case 'd': path = optarg; break;
		case 't': title = optarg; break;
		case 'p': prompt = optarg; break;
		case 'i': iconFile = optarg; break;
		case 'V': status = EXIT_VERSION; break;
		case 'H': status = EXIT_HELP; break;
		default : status = EXIT_USAGE;
		}
	if (optind < argc) status = EXIT_USAGE;

	HandleUsageHelpVersion(status, USAGE, HELP);

	SetAppIconToFile(iconFile);
	ProvideKeyEquivalents();

	{
		int flags, context = [NXApp activateSelf:YES];	
		NIOpenPanel *panel = [NIOpenPanel new];

		if (title != NULL) [panel setPanelTitle:(char *) title];
		if (prompt != NULL) [panel setListTitle:(char *) prompt];
		if (path != NULL) {
			if (strncmp(SEPARATOR, path, strlen(SEPARATOR)) != 0) {
				/* If `path' doesn't start with SEPARATOR,
				   NIOpenPanel screams back at you with a
				   number of alert panels... */
				char *newPath = malloc(strlen(SEPARATOR) + strlen(path) + 1);

				sprintf(newPath, "%s%s", SEPARATOR, path);
				path = newPath;
			}
			[panel setDirectoryPath:path];
		}

		if ((flags = [panel runModal]) == NX_OKTAG)
		{
			/* Some ad-hoc hackery since [panel directory] does
			   not return complete directory path. */
			char fullDomain[MAXPATHLEN];

			strcpy(fullDomain, [panel domain]);
			if (path != NULL) {
				if (strcmp(fullDomain, SEPARATOR) == 0)
					strcpy(fullDomain, path);
				else
					strcat(fullDomain, path);
			}
			(void) puts(fullPath(fullDomain, [panel directory]));
		}
		else status = flags;

		[panel free];

		if (context) (void) [NXApp activate:context];
	}

	[NXApp free];

	exit(status);
}
