/* File:	ShellPanel.h - support routines for ShellPanel utilities.
 *
 * By:		Tom Hageman <Tom_Hageman@RnA.nl>
 *
 * Date:	12-Mar-96
 */

#import <stdio.h>
#import <stdlib.h>
#import <appkit/appkit.h>
#import "getopt.h"

#ifndef EXIT_USAGE
#   define EXIT_USAGE	2
#endif

// dummy exit codes -- used only internally.
#define EXIT_HELP	(-2)
#define EXIT_VERSION	(-3)

#define VERSION "2.0 (R&A)"
#define VERSION_DATE	"May 1996"

#define _STRINGIZE(x)	#x
#define STRINGIZE(x)	_STRINGIZE(x)	// Indirection to expand cpp macros.

#ifdef USES_APPICON
void SetAppIconToFile(const char *iconFile)
{
	NXImage *icon;

	if (!iconFile) return;

	icon = [[NXImage alloc] init];

	if ([icon loadFromFile:iconFile]) {
		NXSize orgsize, newsize = {48, 48};

		[icon getSize:&orgsize];
		if (orgsize.width > orgsize.height) {
			newsize.height = newsize.height * orgsize.height / orgsize.width;
		}
		else if (orgsize.width < orgsize.height) {
			newsize.width = newsize.width * orgsize.width / orgsize.height;
		}
		[icon setScalable:YES];
		[icon setSize:&newsize];
		[icon setName:"app"];	// Works with NS 3.x at least.
	}
}
#endif

#ifdef USES_KEYEQUIV
void ProvideKeyEquivalents(void)
{
	static struct HiddenKey {
		const char *methodName;
		short keyEquiv;
	} HiddenKeys[] = {
		"cut:",		'x',
		"copy:",	'c',
		"paste:",	'v',
		"selectAll:",	'a',
#ifdef KEY_EQUIVALENTS
		KEY_EQUIVALENTS
#endif
	};
	const int HiddenKeyCount = sizeof(HiddenKeys)/sizeof(HiddenKeys[0]);
	Menu *menu = [Menu new];
	int i;

	for (i = 0;  i < HiddenKeyCount;  i++) {
		struct HiddenKey *hp = &HiddenKeys[i];

		[menu addItem:hp->methodName
		 action:sel_getUid(hp->methodName)
		 keyEquivalent:hp->keyEquiv];
	}
}
#endif

void HandleUsageHelpVersion(int what, const char *usage, const char *help)
{
	const char *appName = [NXApp appName];

	switch (what) {
	case EXIT_USAGE:
		fprintf(stderr, usage, appName);
		fprintf(stderr, "try `%s -H' for more information.\n", appName); 
		break;
	case EXIT_HELP:
		printf(usage, appName);
		printf(help, appName);
		what = EXIT_SUCCESS;
		break;
	case EXIT_VERSION:
		printf("%s: ShellPanel version %s, %s.\n",
		       appName, VERSION, VERSION_DATE);
		what = EXIT_SUCCESS;
		break;
	default:
		return; // no-op.
	}
	[NXApp free];
	exit(what);
}
