static char SCCSID[] = "@(#)wline.c	1.2 89/02/22";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC drawWhite, drawBlack;
static XSegment *segments;
#define NSEG        64
#define LINEWIDTH   5

/*
 * wide lines
 *
 * currently seldom used (becaus most implementations are slow) -
 * as cad applications will appear, this (and dashed lines)
 * may be used more often.
 */
wline_setup(dpy, win, len)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int i;
	XSegment *sp;

	drawWhite = XCreateGC(dpy, win, 0L, NULL);
	if (! drawWhite) return 1;
	XSetForeground(dpy, drawWhite, WhitePixel(dpy, screen));
	XSetBackground(dpy, drawWhite, BlackPixel(dpy, screen));
	XSetLineAttributes(dpy, drawWhite, LINEWIDTH, LineSolid, CapButt, JoinMiter);

	drawBlack = XCreateGC(dpy, win, 0L, NULL);
	if (!drawBlack) return 1;
	XSetForeground(dpy, drawBlack, BlackPixel(dpy, screen));
	XSetBackground(dpy, drawBlack, WhitePixel(dpy, screen));
	XSetLineAttributes(dpy, drawBlack, LINEWIDTH, LineSolid, CapButt, JoinMiter);

	segments = (XSegment *)malloc(sizeof(XSegment) * 6 * NSEG);
	if (segments == (XSegment *)0)
	    return 1;

	sp = segments;
	for (i=0; i<NSEG; i++) {
	    sp->x1 = i; sp->y1 = i;
	    sp->x2 = i+len; sp->y2 = i;
	    sp++;

	    sp->x1 = i; sp->y1 = i;
	    sp->x2 = i; sp->y2 = i+len;
	    sp++;

	    sp->x1 = i+len; sp->y1 = i;
	    sp->x2 = i; sp->y2 = i+len;
	    sp++;

	    sp->x1 = i; sp->y1 = i;
	    sp->x2 = i+len; sp->y2 = i+len;
	    sp++;

	    sp->x1 = i+len; sp->y1 = i;
	    sp->x2 = i+len; sp->y2 = i+len;
	    sp++;

	    sp->x1 = i; sp->y1 = i+len;
	    sp->x2 = i+len; sp->y2 = i+len;
	    sp++;
	}
	return 0;
}

wline_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, drawWhite);
	XFreeGC(dpy, drawBlack);
	free(segments);
}

wline_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int nline;

	nline = 0;
	while (benchRunning) {
	    XDrawSegments(dpy, win, drawWhite, segments, 6*NSEG);
	    XDrawSegments(dpy, win, drawBlack, segments, 6*NSEG);
	    nline += NSEG * 6 * 2;
	    if (sync) XSync(dpy, 0);
	}
	return nline;
}

wline_msg(deltaT, nline, len, rate)
double rate;
{
	printf("WIDE LINES\n");
	printf("\n");
	printf("%d wide vectors (linewidth=%d) of len. %d in %d secs\n",
				nline, LINEWIDTH, len, deltaT);
	printf("rate = %8.2f vectors/sec\n", rate);
}
