/*
 * Copyright (c) 1983 Eric P. Allman
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)conf.h	5.17 (Berkeley) 6/1/90
 */

#ifndef CONF_H
# define CONF_H
# ifndef lint
#  ifdef _DEFINE
static char *conf_h_sccs_id = "@(#)conf.h	5.17 (Berkeley) 6/1/90";
static char *conf_h_rcs_id = "@(#)$Id: conf.h,v 5.17.0.34 1992/08/21 05:15:02 paul Exp $";
#  endif /* _DEFINE */
# endif /* !lint */

/*
**  CONF.H -- User-configurable parameters for sendmail
*/

/*
**  Table sizes, etc....
**	There shouldn't be much need to change these....
*/

# define MAXLINE	1024		/* max line length */
# define MAXNAME	256		/* max length of a name */
# define MAXFIELD	4096		/* max total length of a hdr field */
# define MAXPV		40		/* max # of parms to mailers */
# define MAXHOP		25		/* max value of HopCount */
# define MAXATOM	200		/* max atoms per address */
# define MAXMAILERS	25		/* maximum mailers known to system */
# define MAXRWSETS	40		/* max # of sets of rewriting rules */
# define MAXPRIORITIES	25		/* max values for Precedence: field */
# define MAXTRUST	30		/* maximum number of trusted users */
# define QUEUESIZE	600		/* max # of jobs per queue run */
# define MAXMXHOSTS	10		/* max # of MX records */

/*
** Compilation platform.  Include one from the following list:
**
** 3b1.h aix3.h aixrt.h bsd43.h bsd44.h convex.h dgux.h domainos.h
** dynix.h epix.h esix.h hpux7.h hpux8.h irix.h isc.h newsos5.h next.h
** osx.h ptx.h riscos.h s5r4.h sunos3.h sunos4.h ultrix3.h ultrix4.h
** umax.h unisoft.h usg.h xenix.h
*/

# include "config/bsd44.h"

/*
**  Compilation options.
**
**	#define these if they are available; comment them out otherwise.
*/

# define DBM		1	/* use DBM library (may require -ldbm) */
# define NO_PADDING	1	/* don't pad dbm strings with ASCII NULL */

/*
 * Define only 1 of the various {N,G,S,M,H}DBM libraries.  N.B., HDBM
 * assumes that ndbm.o was included in the libhash.a file.
 */
# define NDBM		1	/* new DBM library available (requires DBM) */
/*# define GDBM		1	/* gnu DBM library available (requires DBM) */
/*# define SDBM		1	/* Ozan Yigit's PD ndbm (requires DBM) */
/*# define MDBM		1	/* UMaryland's ndbm variant (requires DBM) */
/*# define HDBM		1	/* Berkeley's hashing package (requires DBM) */

/*# define YP		1	/* enable Yellow Pages code */
/*# define FUZZY	1	/* enable fuzzy matching of local user names */
# define LOG		1	/* enable logging */
# define SMTP		1	/* enable user and server SMTP */
# define QUEUE		1	/* enable queueing */
# define QUEUE_MACVALUE	'$'	/* save the $r and $s macros in queue file */
# define UGLYUUCP	1	/* output ugly UUCP From lines */
# define DAEMON		1	/* include the daemon (requires IPC & SMTP) */
# define NAMED_BIND	1	/* use Berkeley Internet Domain Server */
/*# define TTYNAME	1	/* set macro y to basename of tty device */
/*# define NOTUNIX	1	/* Define if msgs lack a UNIX "From " line */

/*
 * Enable non-standard SMTP mods for talking to the DEC mail11v3 program.
 * This option is necessary only on Ultrix machines that wish to act as
 * Internet <=> Decnet mail gateways.  DECNETNAME must also be defined
 * in your ida/cf/foo.m4 file to include the Decnet rulesets in the sendmail.cf
 * file.
 */
/*# define MAIL11V3	1	/* */

/*
 * Munge argv to display current status for ps.  This will not work on systems
 * derived from System 5.  On some systems such as Apollos, it will cause core
 * dumps.  The wrapper around SETPROCTITLE is guaranteed to be incomplete.
 */
#if !defined(SYSV) && !defined(apollo) && !defined(_SEQUENT_) && \
    !defined(_AIX) && !defined(AIX) && !defined(__convex__) && \
    !defined(SYSTYPE_SYSV)
# define SETPROCTITLE	1	/* */
#endif /* !SYSV && !apollo && !_SEQUENT_ && !_AIX && !AIX && etc, etc */

/*
 * Compile in support for Dan Bernstein's (brnstnd@nyu.edu) authd
 * authentication server (RFC 931).  Sets $F for use in sendmail.cf to
 * contain the real user name or "unauthenticated" in case the sending
 * host doesn't support RFC 931.  Requires linking with -lauthuser .
 */
/*# define AUTH		1	/* */

/*
 * Support character set translation and 8-bit mailers between cooperating
 * sites.  Intended for sites whose character set is not US ASCII.  See
 * ../ida/charset.
 */
# define BIT8		1	/* */

/*
 * Enable the use of bind/hesiod for alias lookups.  Defining it here
 * and linking with -lhesiod only enables the code in sendmail.  To actually
 * use it, "Oh" must be set in sendmail.cf.
 */
/*# define HESIOD		1	/* use HESIOD (bind) alias lookups */

/*
** Change this to the location where sendmail should read its configuration
** file.  Older systems used /usr/lib/sendmail.cf, some newer systems move
** this file to /etc/sendmail.cf.
*/
# define	_PATH_SENDMAILCF	"/etc/sendmail.cf"	/* */

/*
** Comment out the following lines if freeze files don't work on your platform.
** Freeze files will not work on the Next (no sbrk()), nor Apollo v10.3 boxes.
** Freeze files will work under v10.4.
*/
# if defined(NeXT) || defined(ISC) || (defined(apollo) && !defined(_TIME_T))
#  undef	_PATH_SENDMAILFC
# else
#  define	_PATH_SENDMAILFC	"/etc/sendmail.fc"	/* */
# endif /* NeXT || ISC || (apollo && !_TIME_T) */

/*
** Comment out this line if you don't want sendmail to write a file with
** the daemon's pid.
*/
# ifdef apollo
#  define	_PATH_SENDMAILPID	"`node_data/etc/sendmail.pid"	/* */
# else /* !apollo */
#  define	_PATH_SENDMAILPID	"/var/run/sendmail.pid"	/* */
# endif /* apollo */

/*
** Various hardware/OS #defines are used in the code.  Most of these
** are typically set by the C preprocessor or compiler.  In some cases
** you may need to #define some of these here, or use a -D CFLAGS argument
** in the Makefile.  Many are used only in the getloadavg.c file.  These
** are the macros currently in use:
**
** AIX        ISC        USG        __hpux     hp9000s800 sgi
** BSD4_4     M_XENIX    UTEK       alliant    i386       sun
** CRAY       NeXT       _AIX       apollo     macII      unixpc
** CRAY2      SYSV       _SEQUENT_  att        mips       vax
** DGUX       UMAX       __convex__ hp9000     sequent
*/
#endif /* !CONF_H */
