
# line 2 "test.y"
/*
 * this file implements the grammar for the password tests
 * the escapes are handled in the caller
 */

#include "passwd.h"


# line 14 "test.y"
typedef union  {
	char *cval;		/* something parsed as a string */
	int ival;		/* something parsed as a number */
} YYSTYPE;
# define AND 257
# define DIV 258
# define EOL 259
# define EQ 260
# define FILENAME 261
# define GE 262
# define GT 263
# define LE 264
# define LPAR 265
# define LT 266
# define MINUS 267
# define MOD 268
# define NE 269
# define NOT 270
# define NUMBER 271
# define OR 272
# define PATEQ 273
# define PATNE 274
# define STRING 275
# define PLUS 276
# define PROGRAM 277
# define RPAR 278
# define TIMES 279
# define UNK 280

# line 67 "test.y"

/*
 * variables
 */
static int retval;		/* 1 if test passed, 0 if not */
static char *lptr;		/* used to walk input string */
static int ateol;		/* 1 when you hit end of string */

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 221 "test.y"


/*
 * this is the lexer -- it's pretty dumb
 */
yylex()
{
	static char parbuf[BUFSIZ];	/* used to save strings */
	register int rval;		/* used for return values */
	register char quo;		/* used to hold terminal quote mark */

	/*
	 * this is hit at the end of string
	 * we need to do it this way because the '\0' (EOL)
	 * token must be returned, so we have toi return
	 * another "end of input" token -- in other words,
	 * the end of input character is NOT the same as 
	 * the end of string (EOL) character

	 */
	if (ateol){
		ateol = 0;
		return(-1);	/* YACC's end of file character */
	}

	/*
	 * eat leading white spaces; may have a backslash in front
	 * (since a tab separates the test field and the message
	 * field, if there is a tab in the test field it must be
	 * escaped)
	 */
	while(*lptr)
		if (isspace(*lptr))
			lptr++;
		else if (*lptr == '\\'){
			if (isspace(lptr[1]))
				lptr += 2;
			else
				break;
		}
		else
			break;

	/*
	 * hit end of string character
	 * indicate there's nothing more with ateol
	 * (so next tile we return YACC's end of file)
	 * and return the EOL token
	 */
	if (*lptr == '\0'){
		ateol = 1;
		return(EOL);
	}

	/*
	 * number -- just return it
	 */
	if (isdigit(*lptr)){
		for(rval = 0; isdigit(*lptr); lptr++)
			rval = rval * 10 + *lptr - '0';
		yylval.ival = rval;
		return(NUMBER);
	}

	/*
	 * something else -- analyze it
	 */
	switch(*lptr++){
	case '@':		/* rest of line is comment */
	case '\t':		/* rest of line is error message */
	case '\n':		/* end of line */
	case '\0':		/* end of line */
		ateol = 1;
		return(EOL);
	case '(':		/* begin grouping */
		return(LPAR);
	case ')':		/* end grouping */
		return(RPAR);
	case '~':		/* negation */
		return(NOT);
	case '+':		/* add */
		return(PLUS);
	case '-':		/* subtract */
		return(MINUS);
	case '*':		/* multiply */
		return(TIMES);
	case '/':		/* divide */
		return(DIV);
	case '%':		/* remainder */
		return(MOD);
	case '&':		/* disjunction */
		if (*lptr++ == '&')	/* && */
			return(AND);
		--lptr;			/* & */
		return(AND);
	case '|':		/* conjunction */
		if (*lptr++ == '|')	/* || */
			return(OR);
		--lptr;			/* | */
		return(OR);
	case '>':		/* relation */
		if (*lptr++ == '=')	/* >= */
			return(GE);
		--lptr;			/* > */
		return(GT);
	case '<':		/* relation */
		if (*lptr++ == '=')	/* <= */
			return(LE);
		--lptr;			/* < */
		return(LT);
	case '!':		/* relation, logical negation */
		if (*lptr++ == '=')	/* != */
			return(NE);
		--lptr;	
		if (*lptr++ == '~')	/* !~ */
			return(PATNE);
		--lptr;			/* logical negation */
		return(NOT);
	case '=':
		if (*lptr++ == '=')	/* == */
			return(EQ);
		--lptr;	
		if (*lptr++ == '~')	/* =~ */
			return(PATEQ);
		--lptr;			/* = */
		return(EQ);
	case '\'':			/* pattern */
	case '"':			/* pattern */
	case '{':			/* program */
	case '[':			/* file */
		/*
		 * figure out what you're dealing with
		 */
		if (lptr[-1] == '\'' || lptr[-1] == '"'){	/* pattern */
			quo = lptr[-1];
			rval = STRING;
		}
		else if (lptr[-1] == '{'){	/* program */
			quo = '}';
			rval = PROGRAM;
		}
		else{				/* file */
			quo = ']';
			rval = FILENAME;
		}
		/*
		 * collect the file or program or pattern
		 */
		lptr = getcstring(lptr, parbuf, quo);
		/*
		 * if no closing quote, warn but accept;
		 * if a closing quote, skip it
		 */
		if (!*lptr)
			yyerror("missing quote -- supplying it");
		else
			lptr++;
		/*
		 * return the file or program as the value
		 */
		yylval.cval = strsave(parbuf);
		return(rval);
	}

	/*
	 * unknown
	 */
	return(UNK);
}

/*
 * report error on a pattern (malformed ...)
 */
paterr(msg)
char *msg;		/* error message from pattern compiler/matcher */
{
	/*
	 * print the error message
	 */
	LOG3(LG_SYNTAX, "%s at line %d (at \"%s\")", msg, linect, lptr-1);
}

/*
 * report system errors
 */
sysyyerror(s)
char *s;		/* what screwed up */
{
	char buf[BUFSIZ];	/* buffer for error message */

	/*
	 * print the system error message if available,
	 * or the error number if not
	 */
	if (errno < sys_nerr)
		SPRINTF(buf, "line %d: %s: %s at \"%s\"",
					linect, s, sys_errlist[errno], lptr-1);
	else
		SPRINTF(buf, "line %d: %s: unknown error #%d at \"%s\"",
						linect, s, errno, lptr-1);
	LOG0(LG_SYSTEM, buf);
}

/*
 * report grammar errors (yacc)
 */
yyerror(s)
char *s;		/* how the parse screwed up */
{
	/*
	 * print the error message
	 */
	LOG3(LG_SYNTAX, "%s at line %d (at \"%s\")", s, linect, lptr-1);

	/*
	 * signal end of test
	 */
	ateol = 1;
}

/*==================== DRIVER ====================*/
/*
 * this runs the test in "buf" on the password
 * and returns 1 if it passes, 0 of not
 */
passtest(buf)
char *buf;			/* the test */
{
	/*
	 * clear the end of line flag
	 */
	ateol = 0;

	/*
	 * clobber any trailing newline
	 */
	lptr = &buf[strlen(buf)-1];
	if (*lptr == '\n')
		*lptr = '\0';
	else
		lptr[2] = '\0';

printf("TEST :%s:\n", buf);
	/*
	 * set up the pointer to the input
	 * for yylex, the lexical analyzer
	 */
	lptr = buf;

	/*
	 * parse the date and process the result
	 */
	if (yyparse()){
#ifdef DEBUG
		PRINTF("illegal test for password\n");
#endif
		return(0);
	}

	/*
	 * test is syntactically and semantically correct
	 * and return the result
	 */
#ifdef DEBUG
	PRINTF("password \"%s\" %s this test\n",
			password, retval ? "passes" : "does not pass");
#endif
	return(retval);
}
	



/*===================== M A I N  C A L L I N G  R O U T I N E S ==============*/
/*
 * two sets of main routines
 * if "DEBUG" is defined, you get a main routine that reads in one date,
 * parses it, and prints the result
 * if "DEBUG" is not defined, you get a routine that returns 1 if the current
 * time is within the time range of the argument string, 0 if not
 *
 * "DEBUG" san be set to two levels; "1" gives you just the result (1 or 0),
 * but you can use the print function "prtime()" to print out key times in
 * the parse.  "2" gives you complete debugging info from YACC as well
 */

#ifdef DEBUG

/*
 * set the flag YYDEBUG
 */
#if DEBUG > 1
#define YYDEBUG		/* flag so YACC will generate debugging info */
extern int yydebug;	/* constant to tell YACC to generate debugging info */
#endif

int linect = 0;		/* number of expression being tested */
char *password;		/* password being tested */

/*
 * main routine -- execute the given test and print the result
 */
main()
{
	char buf[BUFSIZ];		/* input buffer */
	char pbuf[BUFSIZ];		/* buffer for password */
	register char *p, *b;		/* used to load password */

#if DEBUG > 1
	yydebug = 1;		/* YACC is to give full debugging output */
#endif

	/*
	 * initialize the password to nothing
	 */
	pbuf[0] = '\0';

	/*
	 * get the input; if EOF, quit
	 */
	while(fgets(buf, BUFSIZ, stdin) != CH_NULL){
		/*
		 * if it is a new password change the old one
		 */
		if (buf[0] == 'p'){
			for(b = &buf[1]; isspace(*b); b++)
			p = pbuf;
			while(*b && *b != '\n')
				*p++ = *b++;
			*p = '\0';
			PRINTF("new password is \"%s\"\n", pbuf);
			password = pbuf;
			initpw();
			continue;
		}

		/*
		 * if there is no password, warn
		 */
		if (pbuf[0] == '\0'){
			PRINTF("no password; say 'p <password>' to set one\n");
			continue;
		}

		/*
		 * new expression
		 */
		linect++;

		/*
		 * print the buffer
		 */
		PRINTF("buf is <%s>\n", buf);

		/*
		 * parse the date and process the result
		 */
		(void) passtest(buf);
	}

	/*
	 * no problem
	 */
	exit(0);
}

#endif
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 45
# define YYLAST 156
short yyact[]={

  44,  47,  38,  14,  39,  36,  40,  15,  35,  42,
  45,  37,  13,  72,  17,  71,  42,  19,  41,  70,
  52,  43,  44,  69,  38,  41,  39,  36,  40,  18,
  35,  42,  45,  37,  68,  51,   3,  67,  66,   4,
  41,  10,  65,  43,  44,   5,  17,  14,  16,   7,
   6,  15,   2,  42,  45,   9,  13,  11,  20,  22,
   1,  18,  41,  10,  52,  43,  44,   5,  17,  14,
  49,  50,   6,  15,  63,  42,  45,   9,  13,  11,
  60,  57,   8,  18,  41,  54,   0,  43,  62,  31,
  64,  27,   0,   0,  59,  56,  61,  58,  32,  53,
  28,  55,  33,  34,  29,  30,  23,  12,   0,   0,
   0,   0,   0,  21,   0,  24,   0,   0,   0,  25,
  26,  46,  48,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  73,  74,  75,  76,  77,  78,  79,
  80,  81,  82,  83,   0,  84 };
short yypact[]={

-220,-1000,-211,-242,-1000,-198,-198,-1000,-1000,-154,
-169,-171,-236,-264,-264,-1000,-1000,-198,-198,-1000,
-243,-258,-189,-176,-180,-181,-187,-233,-237,-238,
-241,-252,-256,-260,-262,-264,-264,-264,-264,-264,
-264,-264,-264,-264,-264,-264,-251,-264,-251,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-192,-192,-192,-192,-192,-192,-1000,
-1000,-251,-251,-251,-214 };
short yypgo[]={

   0, 107,  82,  60,  49,  52 };
short yyr1[]={

   0,   3,   3,   3,   5,   5,   5,   5,   5,   5,
   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,
   1,   1,   1,   1,   1 };
short yyr2[]={

   0,   2,   2,   1,   3,   3,   3,   2,   1,   1,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   2,   3,
   2,   3,   3,   3,   1 };
short yychk[]={

-1000,  -3,  -5, 256, 259, 265, 270,  -4,  -2, 275,
 261, 277,  -1, 276, 267, 271, 259, 257, 272, 259,
  -5,  -1,  -5, 260, 269, 273, 274, 260, 269, 273,
 274, 260, 269, 273, 274, 266, 263, 269, 260, 262,
 264, 276, 267, 279, 258, 268,  -1, 265,  -1,  -5,
  -5, 278, 278, 275, 261, 277, 275, 261, 277, 275,
 261, 277, 275, 261, 277, 275, 275, 275, 275, 275,
 275, 275, 275,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,  -1 };
short yydef[]={

   0,  -2,   0,   0,   3,   0,   0,   8,   9,   0,
   0,   0,   0,   0,   0,  44,   1,   0,   0,   2,
   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  38,   0,  40,   5,
   6,   4,  36,  10,  14,  18,  11,  15,  19,  12,
  16,  20,  13,  17,  21,  22,  23,  24,  25,  26,
  27,  28,  29,  30,  31,  32,  33,  34,  35,  37,
  39,  41,  42,  43,   0 };
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar 1.6 88/02/08 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 84 "test.y"
{ retval = yypvt[-1].ival ; } break;
case 2:
# line 86 "test.y"
{ retval = 1; } break;
case 3:
# line 88 "test.y"
{ retval = 0; } break;
case 4:
# line 92 "test.y"
{ yyval.ival = yypvt[-1].ival ; } break;
case 5:
# line 94 "test.y"
{ yyval.ival = yypvt[-2].ival && yypvt[-0].ival ; } break;
case 6:
# line 96 "test.y"
{ yyval.ival = yypvt[-2].ival || yypvt[-0].ival ; } break;
case 7:
# line 98 "test.y"
{ yyval.ival = ! yypvt[-0].ival ; } break;
case 8:
# line 100 "test.y"
{ yyval.ival = yypvt[-0].ival ; } break;
case 9:
# line 102 "test.y"
{ yyval.ival = yypvt[-0].ival ; } break;
case 10:
# line 106 "test.y"
{ yyval.ival = (strcmp( yypvt[-2].cval , yypvt[-0].cval ) == 0);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 11:
# line 110 "test.y"
{ yyval.ival = (strcmp( yypvt[-2].cval , yypvt[-0].cval ) != 0);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 12:
# line 114 "test.y"
{ if (smatch( yypvt[-0].cval )) YYERROR; yyval.ival = match( yypvt[-2].cval );
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 13:
# line 118 "test.y"
{ if (smatch( yypvt[-0].cval )) YYERROR; yyval.ival = !match( yypvt[-2].cval );
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 14:
# line 122 "test.y"
{ yyval.ival = strfp(1, yypvt[-2].cval , yypvt[-0].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 15:
# line 126 "test.y"
{ yyval.ival = strfp(0, yypvt[-2].cval , yypvt[-0].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 16:
# line 130 "test.y"
{ yyval.ival = patinfp(1, yypvt[-2].cval , yypvt[-0].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 17:
# line 134 "test.y"
{ yyval.ival = patinfp(0, yypvt[-2].cval , yypvt[-0].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 18:
# line 138 "test.y"
{ yyval.ival = strfp(1, yypvt[-2].cval , yypvt[-0].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 19:
# line 142 "test.y"
{ yyval.ival = strfp(0, yypvt[-2].cval , yypvt[-0].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 20:
# line 146 "test.y"
{ yyval.ival = patinfp(1, yypvt[-2].cval , yypvt[-0].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 21:
# line 150 "test.y"
{ yyval.ival = patinfp(0, yypvt[-2].cval , yypvt[-0].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 22:
# line 154 "test.y"
{ yyval.ival = strfp(1, yypvt[-0].cval , yypvt[-2].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 23:
# line 158 "test.y"
{ yyval.ival = strfp(0, yypvt[-0].cval , yypvt[-2].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 24:
# line 162 "test.y"
{ yyval.ival = patfp(1, yypvt[-0].cval , yypvt[-2].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 25:
# line 166 "test.y"
{ yyval.ival = patfp(0, yypvt[-0].cval , yypvt[-2].cval , fopen, fclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 26:
# line 170 "test.y"
{ yyval.ival = strfp(1, yypvt[-0].cval , yypvt[-2].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 27:
# line 174 "test.y"
{ yyval.ival = strfp(0, yypvt[-0].cval , yypvt[-2].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 28:
# line 178 "test.y"
{ yyval.ival = patfp(1, yypvt[-0].cval , yypvt[-2].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 29:
# line 182 "test.y"
{ yyval.ival = patfp(0, yypvt[-0].cval , yypvt[-2].cval , popen, pclose);
			  (void) free( yypvt[-2].cval ); (void) free( yypvt[-0].cval );
			} break;
case 30:
# line 188 "test.y"
{ yyval.ival = yypvt[-2].ival < yypvt[-0].ival ; } break;
case 31:
# line 190 "test.y"
{ yyval.ival = yypvt[-2].ival > yypvt[-0].ival ; } break;
case 32:
# line 192 "test.y"
{ yyval.ival = yypvt[-2].ival != yypvt[-0].ival ; } break;
case 33:
# line 194 "test.y"
{ yyval.ival = yypvt[-2].ival == yypvt[-0].ival ; } break;
case 34:
# line 196 "test.y"
{ yyval.ival = yypvt[-2].ival >= yypvt[-0].ival ; } break;
case 35:
# line 198 "test.y"
{ yyval.ival = yypvt[-2].ival <= yypvt[-0].ival ; } break;
case 36:
# line 202 "test.y"
{ yyval.ival = yypvt[-1].ival ; } break;
case 37:
# line 204 "test.y"
{ yyval.ival = yypvt[-2].ival + yypvt[-0].ival ; } break;
case 38:
# line 206 "test.y"
{ yyval.ival = yypvt[-1].ival ; } break;
case 39:
# line 208 "test.y"
{ yyval.ival = yypvt[-2].ival - yypvt[-0].ival ; } break;
case 40:
# line 210 "test.y"
{ yyval.ival = - yypvt[-1].ival ; } break;
case 41:
# line 212 "test.y"
{ yyval.ival = yypvt[-2].ival * yypvt[-0].ival ; } break;
case 42:
# line 214 "test.y"
{ yyval.ival = yypvt[-2].ival / yypvt[-0].ival ; } break;
case 43:
# line 216 "test.y"
{ yyval.ival = yypvt[-2].ival % yypvt[-0].ival ; } break;
case 44:
# line 218 "test.y"
{ yyval.ival = yypvt[-0].ival ; } break;
		}
		goto yystack;  /* stack new state and value */

	}
