/*
 * @OSF_FREE_COPYRIGHT@ and Copyright 1992 Transarc Corp.
 */

#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include "timop.h"

void dce_err(char *_1, unsigned long _2);

void timop_getspan(rpc_binding_handle_t _1, idl_long_int _2,
    idl_long_int *_3, idl_long_int *_4, error_status_t *_5);

unsigned_char_t           *server_name;

int main(
    int                   argc,
    char                  *argv[])
{
    unsigned32            status;
    rpc_binding_vector_t  *bind_vector_p;
    uuid_t                obj_uuid;
    uuid_vector_t         obj_uuid_vec;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s server_name\n", argv[0]);
        exit(1);
    }
    server_name = (unsigned_char_t *)argv[1];

    uuid_from_string(STR_UUID, &obj_uuid, &status);
    if (status != uuid_s_ok) {
            dce_err("uuid_from_string", status);
            exit(1);
    }
    obj_uuid_vec.count = 1;
    obj_uuid_vec.uuid[0] = &obj_uuid;

    /* Basic RPC registration with local runtime */
    rpc_server_register_if(timop_v0_0_s_ifspec, NULL, NULL,
        &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_server_register_if", status);
        exit(1);
    }
    rpc_server_use_all_protseqs(rpc_c_protseq_max_reqs_default,
        &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_server_use_all_protseqs", status);
        exit(1);
    }

    /* Security initialization */
    rpc_server_register_auth_info((unsigned_char_t *)"tserver",
        rpc_c_authn_dce_secret, NULL, "FILE:/tmp/timop_keyfile",
        &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_server_register_auth_info", status);
        exit(1);
    }

    /* Register with endpoint mapper and with CDS */
    rpc_server_inq_bindings(&bind_vector_p, &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_server_inq_bindings", status);
        exit(1);
    }
    rpc_ns_binding_export(rpc_c_ns_syntax_dce, server_name,
        timop_v0_0_s_ifspec, bind_vector_p, &obj_uuid_vec, &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_ns_binding_export", status);
        exit(1);
    }
    rpc_ep_register(timop_v0_0_s_ifspec, bind_vector_p, &obj_uuid_vec,
        (unsigned_char_t *)"timop server", &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_ep_register", status);
        exit(1);
    }

    /* Wait for RPCs */
    fprintf(stdout, "Server %s ready.\n", server_name);
    rpc_server_listen(10, &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_server_listen", status);
        exit(1);
    }

    /* Not reached. */
}

void timop_getspan(
    rpc_binding_handle_t  bind_handle,
    idl_long_int          rand_num,
    idl_long_int          *span,
    idl_long_int          *status_p,
    error_status_t        *remote_status_p)
{
    unsigned_char_t       *client_princ_name, *server_princ_name;
    long                  i, n;
    unsigned32            protect_level, authn_svc, authz_svc,
                              status;
    struct timeval        start_time, stop_time;
    struct timezone       tz;
    rpc_authz_handle_t    privs;

    printf("   Server %s answering the call.\n", server_name);

    /* Authorization check */
    rpc_binding_inq_auth_client(bind_handle, &privs,
        &server_princ_name, &protect_level, &authn_svc,
        &authz_svc, &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_binding_inq_auth_client", status);
        *status_p = TIMOP_ERR; return;
    }

    if (protect_level != rpc_c_protect_level_pkt_integ &&
        protect_level != rpc_c_protect_level_pkt_privacy) {
        dce_err("protect_level check", (unsigned long)-1);
        *status_p = TIMOP_ERR; return;
    }

    if (authz_svc != rpc_c_authz_name) {
        dce_err("authz_svc check", (unsigned long)-1);
        *status_p = TIMOP_ERR; return;
    }

    client_princ_name = privs;
    if (strcmp(strrchr(client_princ_name, '/')+1, "tclient")
        != 0) {
        dce_err("client name check", (unsigned long)-1);
        *status_p = TIMOP_ERR; return;
    }

    /* Authorization OK -- now do the work (such as it is...) */
    gettimeofday(&start_time, &tz);
    for (n = i = 1; i <= rand_num; i += 1) {
        n *= i;
    }
    gettimeofday(&stop_time, &tz);
    *span = (stop_time.tv_sec - start_time.tv_sec) * 1000000L;
    *span += (stop_time.tv_usec - start_time.tv_usec);

    *status_p = rand_num;
    return;
}
