
;;; d-dabbrev.el --- extensions to dabbrev

;; Copyright (C) 2006-2013 Davin Pearson

;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: dabbrev extensions
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;; This code extends the functionality of the function dabbrev-expand.
;; In particular text inside the kill-ring, file-name-history,
;; command-history, minibuffer-history, search-ring,
;; apropos-pattern-quoted, buffer-list and deleted text are searched
;; in addition to buffers in memory.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; m4_install_instructions(d-dabbrev)

;;; Known Bugs:

;; None so far!

;;; Code:

(require 'd-key-nav)

(defadvice dabbrev-expand (around d-dabbrev activate)

  (if (not (get-buffer " *dabbrev*"))
      (generate-new-buffer " *dabbrev*"))

  (save-excursion
    (set-buffer " *dabbrev*")
    (erase-buffer)
    (insert (prin1-to-string kill-ring))
    (insert (prin1-to-string file-name-history))
    (insert (prin1-to-string (mapcar 'file-name-nondirectory file-name-history)))
    (insert (prin1-to-string command-history))
    (insert (prin1-to-string minibuffer-history))
    (insert (prin1-to-string search-ring))
    ;; CATT:(if (boundp 'apropos-pattern-quoted) (insert (prin1-to-string apropos-pattern-quoted)))
    (insert (if (boundp 'apropos-pattern-quoted) (prin1-to-string apropos-pattern-quoted) ""))
    ;; CATT: (if (not (boundp 'apropos-pattern-quoted)) (insert (prin1-to-string apropos-pattern-quoted)))
    ;;(insert (if (not (boundp 'apropos-pattern-quoted)) (prin1-to-string apropos-pattern-quoted) ""))
    (insert (prin1-to-string (mapcar 'buffer-name (buffer-list))))
    (insert (prin1-to-string (mapcar 'buffer-file-name (buffer-list))))
    (if (boundp 'd-delete-backspace-list) (insert (prin1-to-string d-delete-backspace-list)))
    )
  ad-do-it
  )

(provide 'd-dabbrev)
;;; d-dabbrev.el ends here
