
;;; d-dired-updown.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-dired-updown.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Dired up/down code
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun d-dired-updown--unmark-all ()
  (save-excursion
    (goto-char (point-min))
    (dired-unmark 1)))

(defun d-dired-updown--mark-all ()
  (save-excursion
    (goto-char (point-min))
    (dired-mark 1)))

(defun d-dired-updown--mark-files (list)
  (let ((ptr list)
        (m   nil))
    (while ptr
      (setq m (concat "^" (regexp-quote (car ptr)) "$"))
      ;;(message "marking %s" m)
      (dired-mark-files-regexp m)
      (setq ptr (cdr ptr)))))

(defun d-dired-down ()
  (interactive)
  (assert (not (string-match (regexp-quote "\\(") d-dired-updown--pre-regexp)))
  (assert (not (string-match (regexp-quote "\\(") d-dired-updown--post-regexp)))
  (let* ((list    (sort (dired-get-marked-files) 'string<))
         (ptr     list)
         (newlist nil))
    (while ptr
      (let ((filename (car ptr)))
        (when (string-match (concat d-dired-updown--pre-regexp "\\([0-9][0-9]\\)") filename)
          (let ((pre    (substring filename 0 (match-beginning 1)))
                (number (read (substring filename (match-beginning 1) (match-end 1))))
                (post   (substring filename (match-end 1)))
                (newname nil))
            (assert (>= number 1))
            (decf number)
            (setq number (format "%02d" number))
            (setq newname (concat pre number post))
            (assert (not (file-exists-p newname)))
            (rename-file filename newname)
            (setq newlist (cons (file-name-nondirectory newname) newlist))
            ;;(d-beeps "oldname=%s, newname=%s" filename newname)
            )))
      (setq ptr (cdr ptr)))
    ;;(debug)
    (d-dired-updown--unmark-all)
    (revert-buffer)
    (d-dired-updown--mark-files newlist)))

(defun d-dired-up ()
  (interactive)
  (assert (not (string-match (regexp-quote "\\(") d-dired-updown--pre-regexp)))
  (assert (not (string-match (regexp-quote "\\(") d-dired-updown--post-regexp)))
  (let* ((list    (nreverse (sort (dired-get-marked-files) 'string<)))
         (ptr     list)
         (newlist nil))
    (while ptr
      (let ((filename (car ptr)))
        (when (string-match (concat d-dired-updown--pre-regexp "\\([0-9][0-9]\\)") filename)
          (let ((pre    (substring filename 0 (match-beginning 1)))
                (number (read (substring filename (match-beginning 1) (match-end 1))))
                (post   (substring filename (match-end 1)))
                (newname nil))
            (assert (<= number 99))
            (incf number)
            (setq number (format "%02d" number))
            (setq newname (concat pre number post))
            (assert (not (file-exists-p newname)))
            (rename-file filename newname)
            (setq newlist (cons (file-name-nondirectory newname) newlist))
            ;;(d-beeps "oldname=%s, newname=%s" filename newname)
            )))
      (setq ptr (cdr ptr)))
    (d-dired-updown--unmark-all)
    (revert-buffer)
    (d-dired-updown--mark-files newlist)))

;;;
;;; NOTE: d-dired-updown--pre-regexp could be /
;;;

(progn
  (setq d-dired-updown--pre-regexp  (regexp-quote "Track"))
  (setq d-dired-updown--post-regexp "\\.flac$")
  )

(provide 'd-dired-updown)

