/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- April 1998
 */

/*
 * BrowseFileView.h -- Implements the view with all the files
 */

#if !defined(AFX_BROWSEFILEVIEW_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_BROWSEFILEVIEW_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CvsEntries.h"
#include "CPStr.h"

enum
{
	kFileIconText = 0,
	kFileIconBinary,
	kFileIconUnknown,
	kFileIconAdded,
	kFileIconConflict,
	kFileIconMiss,
	kFolderIcon,
	kFolderIconUnknown,
	kFolderIconMiss,
	kFileIconTextMod,
	kFileIconBinaryMod,
	kFileIconIgnored,
	kFolderIconIgnored
};

class CWatcherThread : public CWinThread
{
public:
	DECLARE_DYNAMIC(CWatcherThread)

	CWatcherThread();
	virtual ~CWatcherThread();
	virtual void Delete();

	void SetPath(const char *path);
		// change the path currently watched

	void KillThread(void) { m_term = true; }
		// terminate

	bool WasPathModified(bool waitABit = true) const;
	void ResetPathModified(void) { m_Modified = false; }

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWatcherThread)
	//}}AFX_VIRTUAL

	static bool m_lockinit;
	static CRITICAL_SECTION m_lock;

protected:
	HANDLE m_watcher;
	bool m_term;
	CStr m_path;
	CStr m_newpath;
	bool m_Modified;

	virtual BOOL InitInstance();

	// Generated message map functions
	//{{AFX_MSG(CWatcherThread)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

class CBrowseFileView : public CListView
{
protected: // create from serialization only
	CBrowseFileView();
	DECLARE_DYNCREATE(CBrowseFileView)

// Operations
public:

	void ResetView(const char *path, bool notifyBrowser = false);
		// reset to this path and notify optionnaly the directories tree

	void ResetView(bool forceReload = false, bool notifyBrowser = false);
		// - reload and try to guess if something changed
		// according to the mod. time of CVS
		// - notify optionnaly the directories tree
		// - this should *not* be called from another thread. Use
		// the next one if you call from a thread.

	inline void CheckChanges(void) { m_checkChanges = true; }
		// this will call ResetView(forceReload = false)
		// the next time the timer is called. To be used for foreign
		// threads in order to reload the view after cvs ends.

	void Resort(void);
		// resort according to the current key

	void InvalidateView(void);
		// will cause to rebuild the view after cvs returned

	static int GetImageForEntry(EntnodeData *data);
		// return the ID of the image which symbolizes the
		// state of the file/directory

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBrowseFileView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CBrowseFileView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void GetEntriesModTime(time_t & newEntriesMod, time_t & newEntriesLogMod);

	CSortList<ENTNODE> m_entries;
		// CVS/Entries infos
	CStr m_path;
		// current path
	time_t m_entriesMod;
	time_t m_entriesLogMod;
		// time stamp of CVS/*
	int m_sort;
		// sort key
	bool m_ascendant;
		// sort flag
	CWatcherThread *m_watcher;
		// look for watching the file modifications in this path.
	bool m_checkChanges;
		// used by the timer and CheckChanges

// Generated message map functions
protected:
	//{{AFX_MSG(CBrowseFileView)
	afx_msg void OnViewSmallIcons();
	afx_msg void OnViewList();
	afx_msg void OnViewFullRowDetails();
	afx_msg void OnUpdateViewSmallIcons(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewAdd(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewAddB(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewUpdate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRelease(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRmv(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewList(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewFullRowDetails(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnViewAdd();
	afx_msg void OnViewAddb();
	afx_msg void OnViewCommit();
	afx_msg void OnViewRmv();
	afx_msg void OnViewUpdate();
	afx_msg void OnUpdateViewReload(CCmdUI* pCmdUI);
	afx_msg void OnViewReload();
	afx_msg void OnKeydown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnViewUpone();
	afx_msg void OnUpdateViewUpone(CCmdUI* pCmdUI);
	afx_msg void OnViewTrash();
	afx_msg void OnUpdateViewTrash(CCmdUI* pCmdUI);
	afx_msg void OnViewDiff();
	afx_msg void OnViewLog();
	afx_msg void OnViewGraph();
	afx_msg void OnViewStatus();
	afx_msg void OnViewLock();
	afx_msg void OnViewUnlock();
	afx_msg void OnViewWatchOn();
	afx_msg void OnViewWatchOff();
	afx_msg void OnViewEdit();
	afx_msg void OnViewUnedit();
	afx_msg void OnViewWatchers();
	afx_msg void OnViewEditors();
	afx_msg void OnViewRelease();
	afx_msg void OnViewTagNew();
	afx_msg void OnViewTagDelete();
	afx_msg void OnViewTagBranch();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnUpdateMacroSel(CCmdUI* pCmdUI);
	afx_msg void OnViewExplore();
	afx_msg void OnUpdateViewExplore(CCmdUI* pCmdUI);
	afx_msg void OnViewIgnore();
	afx_msg void OnUpdateViewIgnore(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	afx_msg BOOL OnMacroSel(UINT nID);
	DECLARE_MESSAGE_MAP()

// list view image lists
protected:
	void SetFullRowSel(BOOL bFullRowSel);
	static CImageList m_SmallImageList;
	static CImageList m_StateImageList;

// view type helpers
public:
	BOOL SetViewType(DWORD dwViewType);
	DWORD GetViewType();
};

extern CPersistentT<bool> gFileViewIgnore;

#endif // !defined(AFX_BROWSEFILEVIEW_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
