/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// ChildFrm.cpp : implementation of the CLogFrame class
//

#include "stdafx.h"
#include "wincvs.h"

#include "LogFrm.h"
#include "WinCvsBrowser.h"
#include "BrowseFileView.h"
#include "WincvsView.h"

#include "wincvs_winutil.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// inline function(s)

inline BOOL IsKeyMovingFocus(MSG* pMsg) 
{
 	 return ((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == VK_TAB) &&
		 (!(0x8000 & GetKeyState(VK_CONTROL)))
		 );
}

/////////////////////////////////////////////////////////////////////////////
// CLogFrame

IMPLEMENT_DYNCREATE(CLogFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CLogFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CLogFrame)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// persistent values
CPersistentT<int> gSplitterWidth("P_LogSplitter", 200);
CPersistentT<int> gSplitter2Height("P_LogSplitter2", 200);

/////////////////////////////////////////////////////////////////////////////
// CLogFrame construction/destruction

CLogFrame::CLogFrame()
{
	// TODO: add member initialization code here
	
}

CLogFrame::~CLogFrame()
{
}

BOOL CLogFrame::OnCreateClient(LPCREATESTRUCT,
	 CCreateContext* pContext)
{
	MDIMaximize();

	// create a splitter with 1 row, 2 columns
	if (!m_wndSplitter.CreateStatic(this, 1, 2))
	{
		TRACE0("Failed to CreateStaticSplitter\n");
		return FALSE;
	}

	// add the first splitter pane - the default view in column 0
	if (!m_wndSplitter.CreateView(0, 0,
		RUNTIME_CLASS(CWinCvsBrowser), CSize(gSplitterWidth, 200), pContext))
	{
		TRACE0("Failed to create first pane\n");
		return FALSE;
	}

	// add the second splitter pane - which is a nested splitter with 2 rows
	if (!m_wndSplitter2.CreateStatic(
		&m_wndSplitter,     // our parent window is the first splitter
		2, 1,               // the new splitter is 2 rows, 1 column
		WS_CHILD | WS_VISIBLE | WS_BORDER,  // style, WS_BORDER is needed
		m_wndSplitter.IdFromRowCol(0, 1)
			// new splitter is in the first row, 2nd column of first splitter
	   ))
	{
		TRACE0("Failed to create nested splitter\n");
		return FALSE;
	}

	// add the second splitter pane - an input view in column 1
	if (!m_wndSplitter2.CreateView(0, 0,
		RUNTIME_CLASS(CBrowseFileView), CSize(130, gSplitter2Height), pContext))
	{
		TRACE0("Failed to create second pane\n");
		return FALSE;
	}

	// add the second splitter pane - an input view in column 1
	if (!m_wndSplitter2.CreateView(1, 0,
		RUNTIME_CLASS(CWincvsView), CSize(0, 0), pContext))
	{
		TRACE0("Failed to create second pane\n");
		return FALSE;
	}

	// set z-order
	m_wndSplitter.GetPane(0, 1)->SetWindowPos(
		m_wndSplitter.GetPane(0, 0), 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);

	m_wndSplitter2.GetPane(1, 0)->SetWindowPos(
		m_wndSplitter2.GetPane(0, 0), 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);

	// activate the input view
	SetActiveView((CView*)m_wndSplitter2.GetPane(1,0));

	return TRUE;
}

BOOL CLogFrame::PreCreateWindow(CREATESTRUCT& cs)
{
//    cs.style |= WS_MAXIMIZE; 
	return CMDIChildWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CLogFrame diagnostics

#ifdef _DEBUG
void CLogFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CLogFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLogFrame message handlers

void CLogFrame::OnClose() 
{
	// prevent from closing the main frame
	//CMDIChildWnd::OnClose();
}

void CLogFrame::OnDestroy() 
{
	int cCur, cMin;
	m_wndSplitter.GetColumnInfo(0, cCur, cMin);
	gSplitterWidth = cCur;
	m_wndSplitter2.GetRowInfo(0, cCur, cMin);
	gSplitter2Height = cCur;

	CMDIChildWnd::OnDestroy();
}

BOOL CLogFrame::PreTranslateMessage(MSG* pMsg) 
{
	if (IsKeyMovingFocus(pMsg))
	{
		CWnd* pWnd;
		if (0x8000 & GetKeyState(VK_SHIFT))
			pWnd = FindPrevWindow(GetFocus());
		else
			pWnd = FindNextWindow(GetFocus());
		if(pWnd) 
		{
			LRESULT DlgCode = ::SendMessage(pMsg->hwnd, WM_GETDLGCODE, 0, 0);
			if (!(DlgCode & (DLGC_WANTTAB | DLGC_WANTALLKEYS)))
			{
				if (pWnd->IsKindOf(RUNTIME_CLASS(CView)))
					SetActiveView((CView*)pWnd, TRUE);
				else
					pWnd->SetFocus();
			}
		}
		return TRUE;
	}

	return CMDIChildWnd::PreTranslateMessage(pMsg);
}