/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- February 1998
 */

/*
 * CommitDlg.h : the cvs commit dialog
 */

#if !defined(AFX_COMMITDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_COMMITDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"

bool CompatGetCommit(CStr & commit, bool & norecurs, const char *pathTmpl = 0L);
	// get the commit log and misc options...
	// the path is used to read the /path/CVS/Template optionnaly

void combozify(CStr & str);
	// strip the string with the few first words.

#ifdef WIN32
class CCommit_MAIN : public CPropertyPage
{
	DECLARE_DYNCREATE(CCommit_MAIN)

// Construction
public:
	CCommit_MAIN();
	CCommit_MAIN(const char *logmsg, const char *pathTmpl = 0L);
	~CCommit_MAIN();

// Dialog Data
	//{{AFX_DATA(CCommit_MAIN)
	enum { IDD = IDD_COMMIT_MAIN };
	CRichEditCtrl	m_rich;
	CComboBox	m_combodef;
	CString	m_logmsg;
	BOOL	m_norecurs;
	//}}AFX_DATA

	CStr m_tmplPath;


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCommit_MAIN)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCommit_MAIN)
	afx_msg void OnSelchangeCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
#endif /* WIN32 */

#endif // !defined(AFX_COMMITDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
