/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// GetPassword.cpp : implementation file
//

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#	include "QGetPassword.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LEditText.h>

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "GetPassword.h"
#include "CPStr.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// GetPassword dialog


GetPassword::GetPassword(CWnd* pParent /*=NULL*/)
	: CDialog(GetPassword::IDD, pParent)
{
	//{{AFX_DATA_INIT(GetPassword)
	m_passwd = _T("");
	//}}AFX_DATA_INIT
}


void GetPassword::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(GetPassword)
	DDX_Text(pDX, IDC_PASSWD, m_passwd);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(GetPassword, CDialog)
	//{{AFX_MSG_MAP(GetPassword)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// GetPassword message handlers
#endif /* WIN32 */

char *CompatGetPassword(void)
{
#ifdef WIN32
	static char passwd[255];
	GetPassword gp;
	if(gp.DoModal() == IDOK)
	{
		strcpy(passwd, gp.m_passwd);
		return passwd;
	}
	return "";
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Passwd, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static CPStr thepasswd;
	
	LEditText *passwd = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_GetPasswd));
	theDialog->SetLatentSub(passwd);
	
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	
	if(hitMessage == msg_OK)
	{		
		char buf[512];
		Size len;
		passwd->GetText(buf, 511, &len);
		thepasswd.set(buf, len);
		return thepasswd;
	}
	return "";
#endif /* qMacCvsPP */
#ifdef qQT
	QGetPassword pass;
	if(pass.exec() == QDialog::Accepted)
	{
		static CStr thepasswd;
		thepasswd = pass.GetPassword();
		return thepasswd;
	}
	return "";
#endif /* qQT */
}
