/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- March 1998
 */

/*
 * ImportDlg.cpp : the cvs import dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#	include "QImportTab.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include <LCheckBox.h>
#	include <LTextEditView.h>
#	include <LEditText.h>
#	include <LPushButton.h>

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "ImportDlg.h"
#include "CvsPrefs.h"

#ifdef WIN32
#	include "GetPrefs.h"
#	include "PromptFiles.h"
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif

IMPLEMENT_DYNCREATE(CImport_MAIN, CPropertyPage)

CImport_MAIN::CImport_MAIN(const char *logmsg, const char *modname,
						   const char *rtag, const char *vtag) :
	CPropertyPage(CImport_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CImport_MAIN)
	m_logmsg = logmsg;
	m_modname = modname;
	m_rtag = rtag;
	m_vtag = vtag;
	//}}AFX_DATA_INIT
}

CImport_MAIN::CImport_MAIN() : CPropertyPage(CImport_MAIN::IDD)
{
}

CImport_MAIN::~CImport_MAIN()
{
}

void CImport_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CImport_MAIN)
	DDX_Text(pDX, IDC_LOGMSG, m_logmsg);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_RTAG, m_rtag);
	DDX_Text(pDX, IDC_VTAG, m_vtag);
	//}}AFX_DATA_MAP
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_rtag, 1);
	DDV_MinChars(pDX, m_vtag, 1);
}


BEGIN_MESSAGE_MAP(CImport_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CImport_MAIN)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

IMPLEMENT_DYNCREATE(CImport_OPTIONS, CPropertyPage)

CImport_OPTIONS::CImport_OPTIONS(const char *path) :
	CPropertyPage(CImport_OPTIONS::IDD)
{
	//{{AFX_DATA_INIT(CImport_OPTIONS)
	m_path = path;
	//}}AFX_DATA_INIT
}

CImport_OPTIONS::CImport_OPTIONS() : CPropertyPage(CImport_OPTIONS::IDD)
{
}

CImport_OPTIONS::~CImport_OPTIONS()
{
}

void CImport_OPTIONS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CImport_OPTIONS)
	DDX_Text(pDX, IDC_PATH, m_path);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CImport_OPTIONS, CPropertyPage)
	//{{AFX_MSG_MAP(CImport_OPTIONS)
	ON_BN_CLICKED(IDC_BTNPATH2, OnBtnpath)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImport_OPTIONS message handlers

void CImport_OPTIONS::OnBtnpath() 
{
	const char *dir = BrowserGetDirectory("Select a directory to import :");
	if(dir != NULL)
		SetDlgItemText(IDC_PATH, dir);
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_ImportMain(LWindow *theDialog, CPStr & modname, CStr & logmsg, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LTextEditView *editLog = dynamic_cast<LTextEditView*>
		(theDialog->FindPaneByID(item_LogMsg));
	
	if(putValue)
	{
		mname->SetText((Ptr)(const char *)modname, modname.length());	
		editLog->SetTextPtr((Ptr)(const char *)logmsg, logmsg.length());	
		theDialog->SetLatentSub(mname);
		
		// this will take care about an empty module name
		mname->AddListener(CMacCvsApp::app);
		if(modname.length() == 0)
		{
			LPushButton *theOK = dynamic_cast<LPushButton*>
										(theDialog->FindPaneByID(item_OK));
			Assert_(theOK != 0L);
			theOK->Disable();
		}
	}
	else
	{
		Handle hdl = editLog->GetTextHandle();
		Assert_(hdl != 0L);
		logmsg.set(*hdl, GetHandleSize(hdl));
		
		char buf[512];
		Size len;
		mname->GetText(buf, 511, &len);
		modname.set(buf, len);
		
	}
}

static void DoDataExchange_ImportTags(LWindow *theDialog, CPStr & vendortag, CPStr & reltag, bool putValue)
{
	LEditText *vtag = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_Vendortag));
	LEditText *rtag = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_Reltag));
	
	if(putValue)
	{
		vtag->SetText((Ptr)(const char *)vendortag, vendortag.length());	
		rtag->SetText((Ptr)(const char *)reltag, reltag.length());	
		theDialog->SetLatentSub(vtag);
	}
	else
	{
		char buf[512];
		Size len;
		vtag->GetText(buf, 511, &len);
		vendortag.set(buf, len);
		rtag->GetText(buf, 511, &len);
		reltag.set(buf, len);
		
	}
}
#endif /* qMacCvsPP */

bool CompatGetImport(CPStr & modname, CStr & logmsg, CPStr & vendortag,
					CPStr & reltag, CPStr & path)
{
	bool userHitOK = false;
	modname = "";
	logmsg = "";
	vendortag = "";
	reltag = "";
	
	static CPStr sLastModName;
	static CStr sLastMsg;
	static CPStr sLastVTag("avendor");
	static CPStr sLastRTag("arelease");
#ifdef WIN32
	CPropertySheet pages("Import settings");
	CImport_MAIN page1(sLastMsg, sLastModName, sLastRTag, sLastVTag);
	CImport_OPTIONS page2(path);
	CGetPrefs_GLOBALS page3;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	if(pages.DoModal() == IDOK)
	{
		sLastModName = (const char *)page1.m_modname;
		sLastMsg = (const char *)page1.m_logmsg;
		sLastVTag = (const char *)page1.m_vtag;
		sLastRTag = (const char *)page1.m_rtag;
		path = (const char *)page2.m_path;

		page3.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Import, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_ImportTags(theDialog, sLastVTag, sLastRTag, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_ImportMain(theDialog, sLastModName, sLastMsg, true);
	
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_ImportMain(theDialog, sLastModName, sLastMsg, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_ImportTags(theDialog, sLastVTag, sLastRTag, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		
		Assert_(sLastModName.length() != 0);
		
		userHitOK = true;
	}
#endif /* qMacCvsPP */
#ifdef qQT
	QImportTab dlg;
	dlg.fDlg1.DoDataExchange(true, sLastModName, sLastMsg, sLastVTag, sLastRTag);
	dlg.fDlg2.DoDataExchange(true);
	if(dlg.exec() == QDialog::Accepted)
	{
		dlg.fDlg1.DoDataExchange(false, sLastModName, sLastMsg, sLastVTag, sLastRTag);
		dlg.fDlg2.DoDataExchange(false);
		userHitOK = true;
	}
#endif /* qQT */

	if(userHitOK)
	{
		gCvsPrefs.save();
		if(sLastMsg.length() == 0)
			sLastMsg = "no message";
		if(sLastVTag.length() == 0)
			sLastVTag = "initial";
		if(sLastRTag.length() == 0)
			sLastRTag = "start";

		modname = sLastModName;
		logmsg = sLastMsg;
		vendortag = sLastVTag;
		reltag = sLastRTag;
#ifdef macintosh
		logmsg.replace('\015', '\012');
#endif /* macintosh */
	}
	return userHitOK;
}
