/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- March 1998
 */

/*
 * ImportDlg.h : the cvs import dialog
 */

#if !defined(AFX_IMPORTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_IMPORTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"

bool CompatGetImport(CPStr & modname, CStr & logmsg,
					 CPStr & vendortag, CPStr & reltag, CPStr & path);
	// get the import module name and misc options...

#ifdef WIN32
class CImport_MAIN : public CPropertyPage
{
	DECLARE_DYNCREATE(CImport_MAIN)

// Construction
public:
	CImport_MAIN(const char *logmsg, const char *modname,
		const char *rtag, const char *vtag);
	CImport_MAIN();
	~CImport_MAIN();

// Dialog Data
	//{{AFX_DATA(CImport_MAIN)
	enum { IDD = IDD_IMPORT_MAIN };
	CString	m_logmsg;
	CString	m_modname;
	CString	m_rtag;
	CString	m_vtag;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CImport_MAIN)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CImport_MAIN)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CImport_OPTIONS : public CPropertyPage
{
	DECLARE_DYNCREATE(CImport_OPTIONS)

// Construction
public:
	CImport_OPTIONS(const char *path);
	CImport_OPTIONS();
	~CImport_OPTIONS();

// Dialog Data
	//{{AFX_DATA(CImport_OPTIONS)
	enum { IDD = IDD_IMPORT_TAGS };
	CString	m_path;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CImport_OPTIONS)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CImport_OPTIONS)
	afx_msg void OnBtnpath();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_IMPORTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
