/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- March 1998
 */

/*
 * LogDlg.cpp : the cvs log dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LCheckBox.h>
#	include <LEditText.h>
#	include <LPopupGroupBox.h>
#	include <LRadioButton.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#include "LogDlg.h"
#include "CvsPrefs.h"
#include "MultiString.h"

char *sDefLogTagNames[] = 
{
	"1.32:1.35",
	"1.32:",
	":1.35",
	"branch-release1-0",
	"HEAD",
	0L
};

char *sDefLogDateNames[] = 
{
	">1998-3-24",
	"<1998-1-24",
	"1998-1-24<1998-3-24",
	"<=3-24",
	0L
};

char *sDefLogStateNames[] = 
{
	"mystate",
	"dead",
	"exp",
	"mystate,mystate2",
	0L
};

char *sDefLogUserNames[] = 
{
	"johna",
	"garyb",
	"johna,garyb",
	0L
};

static CMString gLogRevNames(10, "P_LogTagNames", sDefLogTagNames);
static CMString gLogDateNames(10, "P_LogDateNames", sDefLogDateNames);
static CMString gLogStateNames(10, "P_LogStateNames", sDefLogStateNames);
static CMString gLogUserNames(10, "P_LogUserNames", sDefLogUserNames);

#ifdef WIN32
#include "GetPrefs.h"

IMPLEMENT_DYNCREATE(CLogMain, CPropertyPage)

CLogMain::CLogMain() : CPropertyPage(CLogMain::IDD)
{
	//{{AFX_DATA_INIT(CLogMain)
	m_defbranch = FALSE;
	m_norecurs = FALSE;
	m_notags = FALSE;
	m_nousers = FALSE;
	m_onlyrcs = FALSE;
	//}}AFX_DATA_INIT
}

CLogMain::~CLogMain()
{
}

void CLogMain::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLogMain)
	DDX_Check(pDX, IDC_DEFBRANCH, m_defbranch);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Check(pDX, IDC_NOTAGS, m_notags);
	DDX_Check(pDX, IDC_NOUSERS, m_nousers);
	DDX_Check(pDX, IDC_ONLYRCS, m_onlyrcs);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLogMain, CPropertyPage)
	//{{AFX_MSG_MAP(CLogMain)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

IMPLEMENT_DYNCREATE(CLogFilters, CPropertyPage)

CLogFilters::CLogFilters(const char * sLastDate, const char * sLastRev,
		const char * sLastUsers, const char * sLastStates) : CPropertyPage(CLogFilters::IDD)
{
	//{{AFX_DATA_INIT(CLogFilters)
	m_date = sLastDate;
	m_rev = sLastRev;
	m_state = sLastStates;
	m_user = sLastUsers;
	//}}AFX_DATA_INIT
}

CLogFilters::CLogFilters() : CPropertyPage(CLogFilters::IDD)
{
}

CLogFilters::~CLogFilters()
{
}

void CLogFilters::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLogFilters)
	DDX_Control(pDX, IDC_COMBOUSER, m_userdef);
	DDX_Control(pDX, IDC_COMBOSTATE, m_statedef);
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_CBString(pDX, IDC_COMBOSTATE, m_state);
	DDX_CBString(pDX, IDC_COMBOUSER, m_user);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	DDX_Check(pDX, IDC_STATE, m_hasstate);
	DDX_Check(pDX, IDC_USER, m_hasuser);
	//}}AFX_DATA_MAP
	if(m_hasstate)
		DDV_MinChars(pDX, m_state, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnRev();
		OnDate();
		OnState();
		OnUser();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gLogRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gLogDateNames, m_datedef);
	DDX_ComboMString(pDX, IDC_COMBOUSER, gLogUserNames, m_userdef);
	DDX_ComboMString(pDX, IDC_COMBOSTATE, gLogStateNames, m_statedef);
}


BEGIN_MESSAGE_MAP(CLogFilters, CPropertyPage)
	//{{AFX_MSG_MAP(CLogFilters)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	ON_BN_CLICKED(IDC_STATE, OnState)
	ON_BN_CLICKED(IDC_USER, OnUser)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLogFilters message handlers

void CLogFilters::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CLogFilters::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CLogFilters::OnState() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_STATE);
	CWnd* wnd = GetDlgItem(IDC_COMBOSTATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CLogFilters::OnUser() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_USER);
	CWnd* wnd = GetDlgItem(IDC_COMBOUSER);
	wnd->EnableWindow(but->GetCheck() == 1);
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_LogFilters(LWindow *theDialog, bool & hasDate, bool & hasStates,
		bool & hasRev, bool & hasUsers,
		CPStr & sLastDate, CPStr & sLastRev,
		CPStr & sLastUsers, CPStr & sLastStates, bool putValue)
{
	LCheckBox *chkd = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogCheckByDate));
	LEditText *editd = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_LogEditByDate));
	LCheckBox *chks = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogCheckByState));
	LEditText *edits = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_LogEditByState));
	LCheckBox *chkr = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogCheckByRev));
	LEditText *editr = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_LogEditByRev));
	LCheckBox *chku = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogCheckByUser));
	LEditText *editu = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_LogEditByUser));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_LogFillByDate));
	LPopupFiller *fillState = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_LogFillByState));
	LPopupFiller *fillRev = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_LogFillByRev));
	LPopupFiller *fillUser = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_LogFillByUser));

	fillDate->DoDataExchange(gLogDateNames, putValue);
	fillState->DoDataExchange(gLogStateNames, putValue);
	fillRev->DoDataExchange(gLogRevNames, putValue);
	fillUser->DoDataExchange(gLogUserNames, putValue);

	if(putValue)
	{
		chkd->SetValue(hasDate ? Button_On : Button_Off);
		editd->SetText((Ptr)(const char *)sLastDate, sLastDate.length());

		chks->SetValue(hasStates ? Button_On : Button_Off);
		edits->SetText((Ptr)(const char *)sLastStates, sLastStates.length());

		chkr->SetValue(hasRev ? Button_On : Button_Off);
		editr->SetText((Ptr)(const char *)sLastRev, sLastRev.length());

		chku->SetValue(hasUsers ? Button_On : Button_Off);
		editu->SetText((Ptr)(const char *)sLastUsers, sLastUsers.length());
	}
	else
	{
		char str[255];
		Size len;

		hasDate = chkd->GetValue() == Button_On;
		editd->GetText(str, 254, &len);
		sLastDate.set(str, len);

		hasStates = chks->GetValue() == Button_On;
		edits->GetText(str, 254, &len);
		sLastStates.set(str, len);

		hasRev = chkr->GetValue() == Button_On;
		editr->GetText(str, 254, &len);
		sLastRev.set(str, len);

		hasUsers = chku->GetValue() == Button_On;
		editu->GetText(str, 254, &len);
		sLastUsers.set(str, len);
	}
}

static void DoDataExchange_LogSettings(LWindow *theDialog, bool & noRecurs, bool & defBranch,
	bool & headerOnly, bool & noTags, bool & onlyRCSfile, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkDefBranch = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogDefBranch));
	LCheckBox *chkHeaderOnly = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogNoUserLogs));
	LCheckBox *chkNoTags = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogNoTags));
	LCheckBox *chkOnlyRCSfile = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_LogOnlyRcs));

	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
		chkDefBranch->SetValue(defBranch ? Button_On : Button_Off);
		chkHeaderOnly->SetValue(headerOnly ? Button_On : Button_Off);
		chkNoTags->SetValue(noTags ? Button_On : Button_Off);
		chkOnlyRCSfile->SetValue(onlyRCSfile ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;
		defBranch = chkDefBranch->GetValue() == Button_On;
		headerOnly = chkHeaderOnly->GetValue() == Button_On;
		noTags = chkNoTags->GetValue() == Button_On;
		onlyRCSfile = chkOnlyRCSfile->GetValue() == Button_On;
	}
}
#endif /* qMacCvsPP */

bool CompatGetLog(bool & noRecurs, bool & defBranch, CPStr & date,
	bool & headerOnly, bool & noTags, bool & onlyRCSfile, bool & hasRev,
	CPStr & rev, CPStr & states, bool & hasUsers, CPStr & users)
{
	bool userHitOK = false;

	static CPStr sLastDate;
	static CPStr sLastRev;
	static CPStr sLastUsers;
	static CPStr sLastStates;

	bool hasDate = false;
	bool hasStates = false;

	hasRev = false;
	hasUsers = false;
	date = "";
	rev = "";
	states = "";
	users = "";
	noRecurs = false;
	defBranch = false;
	headerOnly = false;
	noTags = false;
	onlyRCSfile = false;
	
#ifdef WIN32
	CPropertySheet pages("Log settings");
	CLogMain page1;
	CLogFilters page2(sLastDate, sLastRev, sLastUsers, sLastStates);
	CGetPrefs_GLOBALS page3;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	if(pages.DoModal() == IDOK)
	{
		noRecurs = page1.m_norecurs == TRUE;
		defBranch = page1.m_defbranch == TRUE;
		headerOnly = page1.m_nousers == TRUE;
		noTags = page1.m_notags == TRUE;
		onlyRCSfile = page1.m_onlyrcs == TRUE;

		sLastDate = page2.m_date;
		sLastRev = page2.m_rev;
		sLastUsers = page2.m_user;
		sLastStates = page2.m_state;

		hasRev = page2.m_hasrev == TRUE;
		hasUsers = page2.m_hasuser == TRUE;
		hasDate = page2.m_hasdate == TRUE;
		hasStates = page2.m_hasstate == TRUE;

		page3.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Log, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_LogFilters(theDialog, hasDate, hasStates, hasRev, hasUsers,
		sLastDate, sLastRev, sLastUsers, sLastStates, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_LogSettings(theDialog, noRecurs, defBranch, headerOnly, noTags, onlyRCSfile, true);

	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_LogSettings(theDialog, noRecurs, defBranch, headerOnly, noTags, onlyRCSfile, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_LogFilters(theDialog, hasDate, hasStates, hasRev, hasUsers,
		sLastDate, sLastRev, sLastUsers, sLastStates, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev)
			rev = sLastRev;
		if(hasUsers)
			users = sLastUsers;
		if(hasStates && !sLastStates.empty())
			states = sLastStates;

		gCvsPrefs.save();
	}

	return userHitOK;
}
