/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- April 1998
 */

/*
 * MacBinMaps.h --- class to store the mac binary encoding mappings
 */

#ifndef MACBINMAPS_H
#define MACBINMAPS_H

#include "CvsPrefs.h"

typedef struct
{
#	define MAX_MACBIN_DESC 63
	OSType sig;
	char desc[MAX_MACBIN_DESC + 1];
	MACENCODING encod;
	bool plainBin;
	bool useDefault;
} MACBINMAP;

typedef struct
{
	int numMaps;
	MACBINMAP maps[1];
} MACBINMAPENTRIES;

class MacBinMaps
{
public:
	MacBinMaps();
	~MacBinMaps();

	void LoadDefaults(void);
		// fill with the persistent defaults
	
	void SaveDefaults(void);
		// store as defaults
	
	const MACBINMAP *AddEntry(OSType sig, const char *desc, MACENCODING encod, bool plainBin, bool useDefault);
		// an an entry
	
	void RemoveEntry(OSType sig);
		// remove an entry

	MacBinMaps & operator=(const MacBinMaps & otherMap);
		// replace by this map
	
	inline const MACBINMAPENTRIES * Entries(void) const {return entries;}
		// return the entries
	
	static const char *GetEnvPlainTypes(void);
		// return all the plain binaries types with a semi-colon
		// between each ones.
	
	static const char *GetEnvTypes(MACENCODING type);
		// return all the plain binaries types with a semi-colon
		// between each ones.
protected:
	void Reset(void);
	
	MACBINMAPENTRIES *entries;
};

#endif /* MACBINMAPS_H */
