/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- July 1998
 */

/*
 * RtagDlg.h : the cvs rtag dialog
 */

#if !defined(AFX_RTAGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_RTAGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"

bool CompatRtagCreate(bool & noRecurs, bool & overwriteExisting, CPStr & tagName,
					 CPStr & modName, CPStr & date, CPStr & rev,
					 bool & useMostRecent, bool & lookAttic);
bool CompatRtagDelete(bool & noRecurs, bool & lookAttic,
					 CPStr & tagName, CPStr & modName);
bool CompatRtagBranch(bool & noRecurs, CPStr & branchName,
					 CPStr & modName, CPStr & date, CPStr & rev,
					 bool & useMostRecent, bool & lookAttic);
	// get the rtag options...

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CRtag_CREATE dialog

class CRtag_CREATE : public CPropertyPage
{
	DECLARE_DYNCREATE(CRtag_CREATE)

// Construction
public:
	CRtag_CREATE::CRtag_CREATE(const char * sLastModule, const char * sLastTag,
		bool hasDate, bool hasRev,
		const char * sLastDate, const char * sLastRev,
		bool noRecurs, bool overwriteExist,
		bool useMostRecent, bool lookAttic);
	CRtag_CREATE();
	~CRtag_CREATE();

// Dialog Data
	//{{AFX_DATA(CRtag_CREATE)
	enum { IDD = IDD_RTAG_CREATE };
	BOOL	m_attic;
	CString	m_date;
	CString	m_rev;
	CComboBox	m_revdef;
	CComboBox	m_datedef;
	BOOL	m_hasdate;
	BOOL	m_hasrev;
	BOOL	m_match;
	BOOL	m_norecurs;
	BOOL	m_overwrite;
	CString	m_modname;
	CString	m_tagname;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CRtag_CREATE)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CRtag_CREATE)
	afx_msg void OnDate();
	afx_msg void OnRev();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CRtag_DELETE dialog

class CRtag_DELETE : public CPropertyPage
{
	DECLARE_DYNCREATE(CRtag_DELETE)

// Construction
public:
	CRtag_DELETE::CRtag_DELETE(const char * sLastModule,
		const char * sLastBranch, bool noRecurs, bool lookAttic);
	CRtag_DELETE();
	~CRtag_DELETE();

// Dialog Data
	//{{AFX_DATA(CRtag_DELETE)
	enum { IDD = IDD_RTAG_DELETE };
	BOOL	m_attic;
	BOOL	m_norecurs;
	CString	m_modname;
	CString	m_tagname;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CRtag_DELETE)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CRtag_DELETE)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CRtag_BRANCH dialog

class CRtag_BRANCH : public CPropertyPage
{
	DECLARE_DYNCREATE(CRtag_BRANCH)

// Construction
public:
	CRtag_BRANCH::CRtag_BRANCH(const char * sLastModule, const char * sLastBranch,
		bool hasDate, bool hasRev,
		const char * sLastDate, const char * sLastRev,
		bool noRecurs, bool useMostRecent, bool lookAttic);
	CRtag_BRANCH();
	~CRtag_BRANCH();

// Dialog Data
	//{{AFX_DATA(CRtag_BRANCH)
	enum { IDD = IDD_RTAG_BRANCH };
	BOOL	m_attic;
	CString	m_date;
	CString	m_rev;
	CComboBox	m_revdef;
	CComboBox	m_datedef;
	BOOL	m_hasdate;
	BOOL	m_hasrev;
	BOOL	m_match;
	BOOL	m_norecurs;
	BOOL	m_overwrite;
	CString	m_modname;
	CString	m_branchname;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CRtag_BRANCH)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CRtag_BRANCH)
	afx_msg void OnDate();
	afx_msg void OnRev();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_RTAGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
