/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*
 * TclGlue.h --- glue to the TCL language
 */

#ifndef TCLGLUE_H
#define TCLGLUE_H

bool IsTclAvail(void);

class CStr;
class EntnodeData;

#ifndef _TCL
#	define TCL_OK		0
#	define TCL_ERROR	1
#	define TCL_RETURN	2
#	define TCL_BREAK	3
#	define TCL_CONTINUE	4
#endif

typedef int kTclRes;

#ifndef macintosh
#	define kTCLPathDelimiter '/'
#else
#	define kTCLPathDelimiter ':'
#endif

struct Tcl_Interp;

class CTcl_Interp
{
public:
	CTcl_Interp();
	~CTcl_Interp();

	static bool IsAvail(void);
		// tells if TCL is avalaible
	
	kTclRes DoScriptVar(const char *format, ...);
	kTclRes DoScript(const char *script);
	kTclRes DoFile(const char *file);
		// execute a TCL script, returns false on error
	
	inline operator Tcl_Interp *(void) {return fInterp;}

	static void Unixfy(CStr & path);
	static void Deunixfy(CStr & path);
		// changes the \ into a /
protected:
	Tcl_Interp *fInterp;
};

// browser filler
void TclBrowserReset(void);
void TclBrowserAppend(const char *path, EntnodeData *data);

// selection filler
void TclSelReset(void);
void TclSelAppend(const char *apath, const char *afile);
void TclSelAppend(const char *apath);

#endif /* TCLGLUE_H */
