/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*
 * dll_glue.h --- glue code for the dll to communicate with the caller
 */

#ifndef DLL_GLUE_H
#define DLL_GLUE_H

#include <stdlib.h>
#include "dll_process.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef macintosh
#	pragma export on
#endif /* macintosh */

int dllglue_main(const char *path, int argc, char **argv);
#ifdef macintosh
	int dllglue_setgetenv(UniversalProcPtr agetenv);
	int dllglue_setconsoleout(UniversalProcPtr aconsoleout);
	int dllglue_setconsoleerr(UniversalProcPtr aconsoleerr);
	int dllglue_setconsolein(UniversalProcPtr aconsolein);
	int dllglue_seteventdispatch(UniversalProcPtr adispatch);
	int dllglue_seteventhandler(UniversalProcPtr ahandler);
#else /* !macintosh */
	int dllglue_setgetenv(dllglue_getenv_func agetenv);
	int dllglue_setconsoleout(dllglue_consoleout_func aconsoleout);
	int dllglue_setconsoleerr(dllglue_consoleout_func aconsoleerr);
	int dllglue_setconsolein(dllglue_consolein_func aconsolein);
#endif /* !macintosh */

#ifdef macintosh
#	pragma export reset
#endif /* macintosh */

/* glue code to intercept the getenv and exit */
#define exit dllglue_exit
#define getenv dllglue_getenv

void dllglue_exit(int code);
char * dllglue_getenv(const char *);

#ifdef UNIX_SHL
#	ifdef HAVE_UNISTD_H
#		include <unistd.h>
#	endif
#	define getpass dllglue_getpass
	extern char *dllglue_getpass(const char *prompt);
#endif /* UNIX_SHL */

/* console management, captures stdout and stderr */
void dllglue_flushconsole(void);
void dllglue_saveconsole(void);
void dllglue_restoreconsole(void);

#ifdef __cplusplus
}
#endif

#endif /* DLL_GLUE_H */
