/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * CheckoutDlg.cpp : the cvs checkout dialog
 */

#if !defined(AFX_CHECKOUTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_CHECKOUTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "MultiString.h"

bool CompatGetCheckout(CPStr & modname, CPStr & path, bool & norecurs,
					   bool & toStdout, CPStr & date, CPStr & rev,
					   bool & useMostRecent, bool & doexport, bool & forceCvsroot,
					   bool & overrideCheckoutDir, CPStr & checkoutDir);
	// get the checkout module name and misc options...

extern CMString gOldModules;

#ifdef WIN32
class CCheckout_MAIN : public CPropertyPage
{
	DECLARE_DYNCREATE(CCheckout_MAIN)

// Construction
public:
	CCheckout_MAIN();
	CCheckout_MAIN(const char * modname, const char * path);
	~CCheckout_MAIN();

// Dialog Data
	//{{AFX_DATA(CCheckout_MAIN)
	enum { IDD = IDD_CHECKOUT_MAIN };
	CEdit	m_editPath;
	CComboBox	m_modcombo;
	CString	m_modname;
	CString	m_path;
	BOOL	m_norecurs;
	BOOL	m_stdout;
	BOOL	m_overrideCheckoutDir;
	CString	m_checkoutDir;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCheckout_MAIN)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCheckout_MAIN)
	afx_msg void OnBtnPath();
	afx_msg void OnCheckOverridecheckoutdir();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CCheckout_OPTIONS : public CPropertyPage
{
	DECLARE_DYNCREATE(CCheckout_OPTIONS)

// Construction
public:
	CCheckout_OPTIONS(const char *rev, const char *date);
	CCheckout_OPTIONS();
	~CCheckout_OPTIONS();

// Dialog Data
	//{{AFX_DATA(CCheckout_OPTIONS)
	enum { IDD = IDD_CHECKOUT_OPTIONS };
	CComboBox	m_revdef;
	CComboBox	m_datedef;
	CString	m_date;
	CString	m_rev;
	BOOL	m_hasdate;
	BOOL	m_match;
	BOOL	m_hasrev;
	BOOL	m_export;
	BOOL	m_forceroot;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCheckout_OPTIONS)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCheckout_OPTIONS)
	afx_msg void OnDate();
	afx_msg void OnRev();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
#endif /* WIN32 */

#endif // !defined(AFX_CHECKOUTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
