/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * MultiFiles.h --- class to store multiple files by directory
 */

#ifndef MULTIFILES_H
#define MULTIFILES_H

#ifdef macintosh
#	include <Files.h>
#else /* !macintosh */
	typedef int FSSpec;
#endif /* !macintosh */

#include "CPStr.h"
#include <vector>

#ifdef _MSC_VER
	using namespace std;
#endif

class CvsArgs;

// used internally
class FileEntry
{
public:
	FileEntry() {}
	FileEntry(const char *filename, const FSSpec *macspec = 0L)
	{
		file = filename;
		if(macspec != 0L)
			spec = *macspec;
	}
	FileEntry(const FileEntry & entry)
	{
		*this = entry;
	}

	FileEntry & operator=(const FileEntry & entry)
	{
		file = entry.file;
		spec = entry.spec;
		return *this;
	}

	CStr file;
	FSSpec spec;
};

// used internally
class MultiFilesEntry
{
public:
	MultiFilesEntry() {}
	MultiFilesEntry(const char *path)
	{
		dir = path;
	}
	MultiFilesEntry(const MultiFilesEntry & entries)
	{
		*this = entries;
	}

	MultiFilesEntry & operator=(const MultiFilesEntry & entries)
	{
		dir = entries.dir;
		files = entries.files;
		return *this;
	}

	void setdir(const char *newdir);
	void add(const char *file, const FSSpec *spec = 0L);

	CStr dir;
	std::vector<FileEntry> files;
};

class MultiFiles
{
public:
	MultiFiles() : pos(-1) {}

	void newdir(const char *dir);
		// add a new directory
	void newfile(const char *file, const FSSpec *spec = 0L);
		// add a new file to the current directory

	inline void rewind(void) {pos = -1;}
		// rewind to first directory
	bool next(void);
		// return false if no more directories
	char *add (CvsArgs & args);
		// add the files to a CvsArgs, return the directory
	bool get (int index, CStr & path, CStr & fileName);
		// return the file in the current directory (false if failed)

	int NumFiles(void) const;
		// number of files in the current dir

	void reset();
		// reset for reuse.
protected:
	int pos;
	std::vector<MultiFilesEntry> dirs;
};

#ifdef __MWERKS__
	SPECIALIZE_ITERATOR_TRAIT(FileEntry)
	SPECIALIZE_ITERATOR_TRAIT(MultiFilesEntry)
#endif /* __MWERKS__ */

#endif /* MULTIFILES_H */
