/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- October 2000
 */

/*
 * ReleaseDlg.cpp : the cvs release dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#include "ReleaseDlg.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CReleaseDlg dialog

CReleaseDlg::CReleaseDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CReleaseDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReleaseDlg)
	m_strDirectory = _T("");
	m_bRemoveDirectory = FALSE;
	//}}AFX_DATA_INIT
}


void CReleaseDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReleaseDlg)
	DDX_Text(pDX, IDC_DIRECTORY, m_strDirectory);
	DDX_Check(pDX, IDC_REMOVE, m_bRemoveDirectory);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CReleaseDlg, CDialog)
	//{{AFX_MSG_MAP(CReleaseDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CReleaseDlg message handlers

#endif /* WIN32 */

bool CompatGetRelease( const char* dir, bool& removeDirectory )
{
	bool userHitOK = false;

#ifdef WIN32
	CReleaseDlg oReleaseDlg;
	oReleaseDlg.m_strDirectory = dir;

	if(oReleaseDlg.DoModal() == IDOK)
	{
		removeDirectory = oReleaseDlg.m_bRemoveDirectory == TRUE;
		userHitOK = true;
	}
#endif /* WIN32 */

#ifdef qMacCvsPP
	userHitOK = true;
#endif /* qMacCvsPP */

#if qUnix
	userHitOK = true;
#endif // qUnix

	return userHitOK;
}
