/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- February 2000
 */

/*
 * 
 */

#include "stdafx.h"

#include "UCvsMenubar.h"
#include "UCvsCommands.h"
#include "MacrosSetup.h"

UIMPLEMENT_DYNAMIC(UCvsMenubar, UMenu)

UBEGIN_MESSAGE_MAP(UCvsMenubar, UMenu)
	ON_UDESTROY(UCvsMenubar)
	ON_UCREATE(UCvsMenubar)
UEND_MESSAGE_MAP()

UCvsMenubar::UCvsMenubar() : UMenu(kUCvsMenubarID)
{
}

UCvsMenubar::~UCvsMenubar()
{
}

void UCvsMenubar::OnDestroy(void)
{
	delete this;
}

void UCvsMenubar::OnCreate(void)
{
}

void CreateMainMenubar(int widid)
{
	std::vector<CMacroEntry>::const_iterator i;
	int cnt;

    UMENU menu = UMenuAddPulldown(widid, "&File", UMENU_NULL);
	UMenuAddButton(widid, "&Save\tCtrl+S", menu, 0L, cmdSAVE);
	UMenuAddButton(widid, "Save &As...", menu, 0L, cmdSAVE_AS);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Print...\tCtrl+P", menu, 0L, cmdPRINT);
	UMenuAddButton(widid, "Print Pre&view", menu, 0L, cmdPRINT_PREVIEW);
	UMenuAddButton(widid, "P&rint Setup...", menu, 0L, cmdPRINT_SETUP);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Sen&d...", menu, 0L, cmdSEND_MAIL);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "E&xit\tCtrl+Q", menu, 0L, cmdEXIT);

	menu = UMenuAddPulldown(widid, "&Edit", UMENU_NULL);
	UMenuAddButton(widid, "&Undo\tCtrl+Z", menu, 0L, cmdUNDO);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Cu&t\tCtrl+X", menu, 0L, cmdCUT);
	UMenuAddButton(widid, "&Copy\tCtrl+C", menu, 0L, cmdCOPY);
	UMenuAddButton(widid, "&Paste\tCtrl+V", menu, 0L, cmdPASTE);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Select &All\tCtrl+A", menu, 0L, cmdSELECT_ALL);
	UMenuAddButton(widid, "&Erase all", menu, 0L, cmdCLEAR_ALL);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Find...\tCtrl+F", menu, 0L, cmdFIND);
	UMenuAddButton(widid, "Find next\tF3", menu, 0L, cmdREPEAT);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "F&ont...", menu, 0L, cmdFONT);

	menu = UMenuAddPulldown(widid, "&View", UMENU_NULL);
	UMenuAddButton(widid, "&Toolbar", menu, 0L, cmdTOOLBAR);
	UMenuAddButton(widid, "&Status Bar", menu, 0L, cmdSTATUS_BAR);
	UMenuAddButton(widid, "&Browser Bar", menu, 0L, cmdBROWSER_BAR);
	UMenuAddButton(widid, "&Files Bar", menu, 0L, cmdFILES_BAR);
	UMenuAddButton(widid, "&Multi-Users Bar", menu, 0L, cmdMULTI_BAR);
	UMenuAddButton(widid, "T&ags Bar", menu, 0L, cmdTAGS_BAR);
	UMenuAddButton(widid, "&Console Bar", menu, 0L, cmdCONSOLE_BAR);
	UMenuAddButton(widid, "&Workspace Bar", menu, 0L, cmdWORKSPACE);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Change browser &location...", menu, 0L, cmdOPEN);
	UMenuAddButton(widid, "S&ave settings for location...", menu, 0L, cmdSAVESETTINGS);

	menu = UMenuAddPulldown(widid, "&Admin", UMENU_NULL);
	UMenuAddButton(widid, "Pr&eferences...\tCtrl+F1", menu, 0L, cmdPREFERENCES);
	UMenuAddButton(widid, "&Command Line...", menu, 0L, cmdCMDLINE);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Login...", menu, 0L, cmdLOGIN);
	UMenuAddButton(widid, "Lo&gout", menu, 0L, cmdLOGOUT);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Stop cvs", menu, 0L, cmdSTOPCVS);
	menu = UMenuAddPulldown(widid, "Macros admin", menu);
	for(cnt = 0, i = gMacrosAdmin.entries.begin(); i != gMacrosAdmin.entries.end(); ++i, cnt++)
	{
		UMenuAddButton(widid, (*i).name, menu, 0L, cmdMACROADMIN + cnt);
	}

	menu = UMenuAddPulldown(widid, "&Create", UMENU_NULL);
	UMenuAddButton(widid, "&Create a new repository...", menu, 0L, cmdINIT);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Import module...", menu, 0L, cmdIMPORT);
	UMenuAddButton(widid, "Checkout module...", menu, 0L, cmdCHECKOUT);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Create a tag by module...", menu, 0L, cmdRTAGCREATE);
	UMenuAddButton(widid, "&Delete a tag by module...", menu, 0L, cmdRTAGDELETE);
	UMenuAddButton(widid, "Create a &branch by module...", menu, 0L, cmdRTAGBRANCH);

	menu = UMenuAddPulldown(widid, "&Modify", UMENU_NULL);
	UMenuAddButton(widid, "&Update selection...\tCtrl+U", menu, 0L, cmdUPDATE);
	UMenuAddButton(widid, "Co&mmit selection...\tCtrl+M", menu, 0L, cmdCOMMIT);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Add selection", menu, 0L, cmdADD);
	UMenuAddButton(widid, "Add selection binar&y", menu, 0L, cmdADDB);
	UMenuAddButton(widid, "&Remove selection", menu, 0L, cmdRMV);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Erase &selection\tCtrl+Backspace", menu, 0L, cmdTRASH);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Create a tag on selection...", menu, 0L, cmdTAGNEW);
	UMenuAddButton(widid, "&Delete a tag on selection...", menu, 0L, cmdTAGDELETE);
	UMenuAddButton(widid, "Create a &branch on selection...", menu, 0L, cmdTAGBRANCH);

	menu = UMenuAddPulldown(widid, "&Query", UMENU_NULL);
	UMenuAddButton(widid, "E&xplore selection\tF2", menu, 0L, cmdEXPLORE);
	UMenuAddButton(widid, "&Query Update\tF4", menu, 0L, cmdQUERYUPDATE);
	UMenuAddButton(widid, "R&eload view\tF5", menu, 0L, cmdRELOAD);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "View selection\tF7", menu, 0L, cmdEDITSEL);
	UMenuAddButton(widid, "View default", menu, 0L, cmdEDITSELDEF);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&Diff selection\tAlt+=", menu, 0L, cmdDIFF);
	UMenuAddButton(widid, "&Log selection", menu, 0L, cmdLOG);
	UMenuAddButton(widid, "Status sele&ction", menu, 0L, cmdSTATUS);
	UMenuAddButton(widid, "Graph selection\tCtrl+G", menu, 0L, cmdGRAPH);

	menu = UMenuAddPulldown(widid, "&Trace", UMENU_NULL);
	UMenuAddButton(widid, "Lock selection", menu, 0L, cmdLOCKF);
	UMenuAddButton(widid, "Unlock selection", menu, 0L, cmdUNLOCKF);
	UMenuAddButton(widid, "Edit selection", menu, 0L, cmdEDIT);
	UMenuAddButton(widid, "Unedit selection", menu, 0L, cmdUNEDIT);
	UMenuAddButton(widid, "Add a Watch on selection", menu, 0L, cmdWATCHON);
	UMenuAddButton(widid, "Remove a watch from selection", menu, 0L, cmdWATCHOFF);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Release selection", menu, 0L, cmdRELEASE);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "Watchers of selection", menu, 0L, cmdWATCHERS);
	UMenuAddButton(widid, "Editors of selection", menu, 0L, cmdEDITORS);

	menu = UMenuAddPulldown(widid, "Macro&s", UMENU_NULL);
	for(cnt = 0, i = gMacrosSel.entries.begin(); i != gMacrosSel.entries.end(); ++i, cnt++)
	{
		UMenuAddButton(widid, (*i).name, menu, 0L, cmdSELMACRO + cnt);
	}

	menu = UMenuAddPulldown(widid, "&Window", UMENU_NULL);
	UMenuAddButton(widid, "&Cascade", menu, 0L, cmdCASCADE);
	UMenuAddButton(widid, "&Tile", menu, 0L, cmdTILE_HORZ);
	UMenuAddButton(widid, "&Arrange Icons", menu, 0L, cmdARRANGE);

	menu = UMenuAddPulldown(widid, "&Help", UMENU_NULL);
	UMenuAddButton(widid, "&Help Topics", menu, 0L, cmdFINDER);
	UMenuAddButton(widid, "Help on cvs-1.10", menu, 0L, cmdCVS);
	UMenuAddButton(widid, "Help on cvs client", menu, 0L, cmdCVSCLIENT);
	UMenuAddSeparator(widid, menu);
	UMenuAddButton(widid, "&About wincvs...", menu, 0L, cmdABOUT);
	UMenuAddButton(widid, "&Credits", menu, 0L, cmdCREDITS);
	UMenuAddButton(widid, "C&opyrights", menu, 0L, cmdCOPYRIGHTS);
}
