/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

// glade generated that
extern "C"
{
#include "support.h"
}

#include "CvsPrefs.h"
#include "AppConsole.h"
#include "UCvsApp.h"
#include "UCvsDialogs.h"
#include "UCvsConsole.h"
#include "UCvsFolders.h"
#include "UCvsFiles.h"
#include "UCvsFrame.h"
#include "UCvsToolbar.h"
#include "UCvsMenubar.h"

extern "C"
{
	static gint delete_event( GtkWidget *widget,
					   GdkEvent  *event,
					   gpointer   data )
	{
		static bool sSemaphore = false;
		USemaphore policeman(sSemaphore);
		if(policeman.IsEnteredTwice())
			return TRUE;

		if(UWidget::HasModal())
			return TRUE;

		/* If you return FALSE in the "delete_event" signal handler,
		 * GTK will emit the "destroy" signal. Returning TRUE means
		 * you don't want the window to be destroyed.
		 * This is useful for popping up 'are you sure you want to quit?'
		 * type dialogs. */

		UCvsFrame *frame = (UCvsFrame *)data;
		gint result = frame->AskForQuitting() ? FALSE : TRUE;

		return result;
	}

#if 0
	static gint idleApp(gpointer data)
	{
		UEventGiveTime();
		return true;
	}
#endif

	static gint idleApp2(gpointer data)
	{
		// the pseudo library is relying on that : it needs to get some time
		// in order to manage posted events or timers
		UEventGiveTime();
		if(UCvsApp::gCurCvs != 0L)
			cvs_process_give_time();
		return true;
	}
}

int
main (int argc, char *argv[])
{
	gtk_set_locale ();
	gtk_init (&argc, &argv);

	gtk_timeout_add(10, idleApp2, 0L);
#if 0
	// takes too much CPU
	gtk_idle_add(idleApp, 0L);
#endif
	
	// create the pseudo-application which contains our globals
	new UCvsApp(argc, argv);

	// Create the top window
	GtkWidget *mainWindow = GTK_WIDGET(UCreate_MainWindow());

	// create the pseudo-window and map this window to it.
	// the pseudo widget library will connect automatically
	// a bunch of events to our dispatch event mechanism
	UCvsFrame *frame = new UCvsFrame();
	UEventSendMessage(frame->GetWidID(), EV_INIT_WIDGET, kUMainWidget, mainWindow);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the 'close' option, or on the
     * titlebar), we ask it to call the delete_event () function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function. */
    gtk_signal_connect (GTK_OBJECT (mainWindow), "delete_event",
			GTK_SIGNAL_FUNC (delete_event), frame);

	UEventSendMessage(frame->GetWidID(), EV_SHOW_WIDGET, UMAKEINT(kUMainWidget, 1), 0L);

	// map the console
	UCvsConsole *cons = new UCvsConsole();
	UEventSendMessage(cons->GetWidID(), EV_INIT_WIDGET, kUMainWidget,
					  lookup_widget(mainWindow, "MainConsole"));

	// map the file view (before the folder one, so the folder has a chance
	// to set the file view on opening).
	UCvsFiles *files = new UCvsFiles();
	UEventSendMessage(files->GetWidID(), EV_INIT_WIDGET, kUMainWidget,
					  lookup_widget(mainWindow, "FilesView"));

	// map the folder view
	UCvsFolders *fold = new UCvsFolders();
	UEventSendMessage(fold->GetWidID(), EV_INIT_WIDGET, kUMainWidget,
					  lookup_widget(mainWindow, "FolderView"));

	// map and create the toolbar
	UCvsToolbar *toolbar = new UCvsToolbar();
	UEventSendMessage(toolbar->GetWidID(), EV_INIT_WIDGET, kUMainWidget,
					  lookup_widget(mainWindow, "MainToolbar"));

	CreateMainToolbar();

	// map and create the menubar
	UCvsMenubar *menubar = new UCvsMenubar();
	UEventSendMessage(menubar->GetWidID(), EV_INIT_WIDGET, kUMainWidget,
					  lookup_widget(mainWindow, "MainMenubar"));

	CreateMainMenubar(menubar->GetWidID());
	gtk_window_add_accel_group (GTK_WINDOW (mainWindow),
								(GtkAccelGroup *)menubar->GetAccelGroup());

	UCvsApp::gApp->SayWelcome();

	gtk_main ();

	return 0;
}
