/* LocaleInformation_ga.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ga extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "D\u00ednear Iord\u00e1nach|Mvdol Bolavach|\u00d3r|Kronur Oile\u00e1in Fhar\u00f3|Punt na Liob\u00e1ine|Euro|Dong V\u00edtneamach|Scilling na Tans\u00e1ine|Peso na Bolaive|Riel na Camb\u00f3ide|Aonad Airgeada\u00edochta na h\u00c1ise|Boliviano (1863-1962)|Sean-Riel na Camb\u00f3ide|Punt Saimbiach|Punt Astr\u00e1lach|CFA Franc BEAC|Punt Maltach|Cedi Athluachtha Gh\u00e1na|Kwacha Saimbiach|D\u00ednear \u00c1iseach Unit of Account|Punt Gh\u00e1na|Boliviano|Sean-Cedi Gh\u00e1na|Lira Maltach|Dollar Astr\u00e1lach|Dollar S.A.M. (an la c\u00e9anna)|Lira Iod\u00e1lach|Dollar S.A.M. (an ch\u00e9ad l\u00e1 eile)|Cedi Gh\u00e1na|Dollar Singeap\u00f3ir|Balboa Panamach|Kip Laosach|Som na Cirgeast\u00e1ine|Franc na hEilv\u00e9ise|Scilling Ostarach|Dollar S.A.M.|Dollar na hAet\u00f3ipe|Dollar Bhr\u00fain\u00e9|Punt Iam\u00e1cach|Birr na hAet\u00f3ipe|Franc Germinal Ailg\u00e9rach|Franc Nua Ailg\u00e9rach|D\u00ednear na hAilg\u00e9ire|Guarani Pharagua|Punt Libia|Dollar Iam\u00e1cach|Krona \u00cdoslannach|Peseta Sp\u00e1inneach|Punt Bheirmi\u00fada|D\u00ednear Libia|Lira \u00dadar\u00e1s M\u00edleata Briotanach Libia|Dollar Bheirmi\u00fada|Guilder \u00cdsilt\u00edreach|Ouguiya na Marat\u00e1ine|Rial Iar\u00e1nach|Krona Sualannach|Scilling C\u00e9iniach|CFA Franc Phoblacht na hAfraice L\u00e1ir|Peso na Airgint\u00edne|Peso na Airgint\u00edne (1983-1985)|Peso Moneda Nacional Airgint\u00edneach|Dollar Nua na T\u00e9av\u00e1ine|Punt na S\u00fad\u00e1ine|Lari na Gr\u00faise|Kupon Larit na Gr\u00faise|Franc Martinique|Punt Oile\u00e1in Fh\u00e1clainne|Austral Airgint\u00edneach|D\u00ednear na S\u00fad\u00e1ine|D\u00ednear Ir\u00e1cach|Dollar Tuvalu|R\u00faip\u00ed na S\u00e9is\u00e9il|R\u00fabal Laitviach|Punt Fhids\u00ed|Lats Laitviach|Zaire an Chong\u00f3|Franc Phoblacht an Chong\u00f3|Franc Congolais an Chong\u00f3|Dollar Fhids\u00ed|Cordoba Oro Nicearagua|Pataca Macao|Cordoba \u00d3r Nicearagua|Cordoba Nicearagua|R\u00fabal Inaistrithe COMECON|Markka Fionnlannach (1860-1962)|Markka Fionnlannach|Dollar Oile\u00e1in Solomon|Franc Lucsamburg|Sean-Dollar Oile\u00e1in na Tr\u00edon\u00f3ide agus Tob\u00e1ga|Escudo Ang\u00f3lach|Kwanza Reajustado Ang\u00f3lach (1995-1999)|Tugrik Mong\u00f3lach|Forint Ung\u00e1rach|Franc na Bur\u00faine|Kwanza Nua Ang\u00f3lach (1990-2000)|Kwanza Ang\u00f3lach (1977-1990)|Dollar Oile\u00e1in na Tr\u00edon\u00f3ide agus Tob\u00e1ga|Lilangeni na Suasalainne|CFP Franc Nua-Inse Ghall|Punt Steirling|Riyal S\u00e1dach|Talonas Liotu\u00e1nach|R\u00faip\u00ed India|Escudo Portaing\u00e9lach|Kwanza Ang\u00f3lach|Conto Portaing\u00e9alach|Lita Liotu\u00e1nach|Tenge Casacst\u00e1nach|R\u00fabal Casacst\u00e1nach|Dollar Oile\u00e1in Bhriotanacha na Maighdean|Punt N\u00edg\u00e9arach|Teastais Airgeadra Dollar Mhaenmar|Naira N\u00edg\u00e9arach|Gourde H\u00e1it\u00ed|Punt Siria|Punt Pailist\u00edneach|D\u00ednear na Bair\u00e9ine|Kyat Mhaenmar|Guilder na nAntill\u00ed \u00cdsilt\u00edreach|Koruna Phoblacht na Seice|Punt Steirling Oile\u00e1n Mhanann|Teastais Airgeadra\u00ed Lev Bulg\u00e1rach|Loti Leos\u00f3ta|CFA Franc na Gab\u00faine|Lev Bulg\u00e1rach (1879-1952)|Lev Nua Bulg\u00e1rach|Lev Bulg\u00e1rach S\u00f3isiala\u00edoch|Dollar Ceanada|Lev Bulg\u00e1rach Crua|Lira Turcach|Dollar Oile\u00e1in Cayman|Punt na Cipire|Sheqel Nua Iosraelach|Dollar na Gu\u00e1ine|Dram Airm\u00e9anach|Punt Iosraelach|Franc Mhail\u00ed|Sheqel Iosraelach|Bolivar Veinis\u00e9ala|Teastais Airgeadra\u00ed Dollar na hAlb\u00e1ine|Dollar na Lib\u00e9ire|Lek Valute Alb\u00e1nach|Kuna Cr\u00f3tach|Franc R\u00e9union|D\u00ednear na Cr\u00f3ite|Lek Alb\u00e1nach|Punt Steirling Gheirs\u00ed|Lek Alb\u00e1nach (1946-1961)|Denar na Macad\u00f3ine (1992-1993)|Viet Minh Piastre Dong Viet V\u00edtneam Thuaidh|Dong Nua V\u00edtneam Thuaidh|Denar na Macad\u00f3ine|Piastre Dong Viet V\u00edtneam Thuaidh|Pataca T\u00edom\u00f3ir|CFP Franc|Franc Beilgeach (airgead\u00fail)|Peso Guine-Bhissau|D\u00ednear Cu\u00e1tach|Mil Reis na Guine Portaing\u00e9ala\u00ed|Franc Beilgeach|Escudo T\u00edom\u00f3ir|Franc Beilgeach (inathraithe)|Escudo na Guine Portaing\u00e9ala\u00ed|Colon na Salvad\u00f3ire|Guilder Curacao|Taka Bhanglaid\u00e9iseach|Punt Steirling Tonga|Pa\u02bbanga Tonga|CFA Franc BCEAO|R\u00fabal S\u00f3v\u00e9adach|R\u00fabal Nua S\u00f3v\u00e9adach|Franc Germinal na Nua-Chalad\u00f3ine|Escudo na Rinne Verde|CFA Franc na nAntill\u00ed Francach|Rand na hAfraice Theas|Peso Doimineacach|Teastais Airgeadra\u00ed Ch\u00faba|Punt na hAfraice Theas|Rand na hAfraice Theas (airgead\u00fail)|D\u00ednear na T\u00fain\u00e9ise|Peso C\u00faba|Franc Guiana na Gu\u00e1ine Franca\u00ed|Scilling Uganda|R\u00faip\u00ed na Sioli\u00f3ne|Franc Affars agus Issas|Lira na Vatac\u00e1ine|Escudo Sao Tome agus Principe|Scilling Uganda (1966-1987)|Dobra Sao Tome agus Principe|Dollar Oile\u00e1in Marshall|Punt na Nua-Sh\u00e9alainne|Tala Sam\u00f3 Thiar|Punt Sam\u00f3 Thiar|Lempira Hond\u00farais|Nouveau Franc Ceannchathartha Francach|Manat na An Tuircm\u00e9anast\u00e1ine|Quetzal Guatamala|Dollar na Nua-Sh\u00e9alainne|Punt Albanach|Dollar Bharbad\u00f3is|Dollar na Namaibe|Franc Madagascar|Ariary Madagascar|Punt na h\u00c9igipte|Dollar Hond\u00farais Bhriotanaigh|Zloty Polannach (1950-1995)|D\u00ednear Nua Bhoisnia-Heirseagaiv\u00e9in|Teastais Airgeadra Dollar SAM Polannach|Marc Inathraithe Bhoisnia-Heirseagaiv\u00e9in|Dollar na Beil\u00edse|D\u00ednear Bhoisnia-Heirseagaiv\u00e9in|Zloty Polannach|Rial \u00c9imin|Guilder Shuranaim|Koruna Crua na Seicsl\u00f3vaice|Won na C\u00f3ir\u00e9 Theas|R\u00fabal B\u00e9alar\u00faiseach|Imadi Riyal \u00c9imin|R\u00fabal B\u00e9alar\u00faiseach (1992-1994)|Koruna na Seicsl\u00f3vaice|Sean-Won na C\u00f3ir\u00e9 Theas|Hwan na C\u00f3ir\u00e9 Theas|R\u00fabal Nua B\u00e9alar\u00faiseach (1994-1999)|Drachma Nua Gr\u00e9agach|R\u00faip\u00ed na Pacast\u00e1ine|Afgain\u00ed|Dollar Siomb\u00e1bach|R\u00faip\u00ed Sr\u00ed Lanca|Drachma Gr\u00e9agach|Punt \u00c9ireannach|Afgain\u00ed (1927-2002)|D\u00ednear \u00c9imin|Franc Ruanda|Colon Ch\u00f3sta R\u00edce|Somoni na T\u00e1ids\u00edceast\u00e1ine|R\u00fabal na T\u00e1ids\u00edceast\u00e1ine|Kroon na hEast\u00f3ine|Peseta Guineana na Guine Me\u00e1nchriosa\u00ed|R\u00fabal C\u00fap\u00f3in Mold\u00f3vach|Dollar Hong Cong|Krone Danmhargach|Leu Mold\u00f3vach|Franco na Guine Me\u00e1nchriosa\u00ed|Ekwele Guineana na Guine Me\u00e1nchriosa\u00ed|Rupiah Indin\u00e9iseach|Dirham Aontas na n\u00c9im\u00edr\u00edochta\u00ed Arabacha|Won na C\u00f3ir\u00e9 Thuaidh|Rupiah Nua Indin\u00e9iseach|Pula Botsu\u00e1nach|Leu C\u00fap\u00f3in Mold\u00f3vach|Java Rupiah Indin\u00e9iseach|Won Na nDaoine na C\u00f3ir\u00e9 Thuaidh|Nica Guilder Indin\u00e9iseach|Vatu Vanuat\u00fa|D\u00ednear Ioslamach|Scilling na S\u00f3m\u00e1ile|Peseta And\u00f3ra|R\u00fabal R\u00faiseach (1991-1998)|Franc Guadeloupe|Franc Djibouti|D\u00ednear And\u00f3ra|Franc Germinal Mhonac\u00f3|Franc Nouveau Mhonac\u00f3|Unidad de Valor Constante (UVC) Eacuad\u00f3ir|Sucre Eacuad\u00f3ir|Franc Lichtinst\u00e9in|R\u00fabal R\u00faiseach|Peso Filip\u00edneach|Sum na h\u00daisb\u00e9iceast\u00e1ine|Peso na Col\u00f3ime|Baht na T\u00e9alainne|Punt Thuaisceart \u00c9ireann|R\u00faip\u00ed Bhurma|CFA Franc Chong\u00f3|Kyat Burmach|Peso P\u00e1ip\u00e9ir na Col\u00f3ime|Som C\u00fap\u00f3in na h\u00daisb\u00e9iceast\u00e1ine|Karbovanetz \u00dacr\u00e1nach|Rial Catarach|Hryvnia \u00dacr\u00e1nach|Syli Guine|Yuan Renminbi S\u00edneach|Metical M\u00f3saimb\u00edce|Teastais Airgeadra\u00ed Dollar SAM S\u00edneach|Peso Uruguayo Uragua|Franc Guine (1960-1972)|Lira San Marino|Jen Min Piao Yuan S\u00edneach|Escudo M\u00f3saimb\u00edce|Franc Guine|Rial Saidi Omain|Kina Nua-Ghuine Phapua|Rial Omain|Peso Uragua (1975-1993)|UIC-Franc Francach|R\u00faip\u00ed na B\u00fat\u00e1ine|Zaire S\u00e1\u00edreach|Franc Mharac\u00f3|Dirham Mharac\u00f3|Ngultrum B\u00fat\u00e1nach|Franc \u00d3r Francach|Peso Fuerte Uragua|Ringgit Malaeisia|Zaire Nua S\u00e1\u00edreach|Manat Asarbaise\u00e1nach|Punt Gaimbia|Franc Chom\u00f3ra|Leone Shiarra Leon|Dalasi Gaimbia|Aonad Airgeadra Eorpach|Punt na mBah\u00e1ma\u00ed|CFA Franc Chamar\u00fain|Unidad de Inversion (UDI) Meicsiceo|CFA Franc BCEAEC|Dollar na mBah\u00e1ma\u00ed|Peso Airgid Meicsiceo (1861-1992)|Peso Meicsiceo|Sol Pheiri\u00fa|Krone na Graonlainne|Cruzeiro Brasa\u00edleach (1942-1967)|Sol Nuevo Pheiri\u00fa|Peso na Sile|Koruna na Sl\u00f3vaice|Inti Pheiri\u00fa|Cruzeiro Brasa\u00edleach|Cearta Speisialta Tarraingthe|Franc Germinal Francach/Franc Poincare|Franc Francach|Cruzado Novo Brasa\u00edleach|Unidades de Fomento na Sile|Escudo na Sile|Real Brasa\u00edleach|Condor na Sile|Cruzeiro Brasa\u00edleach (1990-1993)|Sperrmark Gearm\u00e1nach|Punt na Mal\u00e1ive|Cruzado Brasa\u00edleach|Cruzeiro Novo Brasa\u00edleach (1967-1986)|Kwacha na Mal\u00e1ive|Transdniestria R\u00fabal|Deutsche Mark|CFA Franc Sead|R\u00fabal Nua Transdniestria|R\u00fabal Cup\u00f3in Transdniestria|R\u00faip\u00ed Neipe\u00e1il|Dollar Oile\u00e1in Cook|Yen Seap\u00e1nach|Maldive Islands Rufiyaa|CFA Nouveau Franc|Maldive Islands R\u00faip\u00ed|Dollar Oirthear na Cairibe|Tolar Sl\u00f3v\u00e9nach|D\u00ednear Leasaithe I\u00fagslavach|Guilder Aruba|D\u00ednear Dheireadh F\u00f3mhar I\u00fagslavach|Ostmark na hOirGhearm\u00e1ine|D\u00ednear Inathraithe I\u00fagslavach|Noviy Dinar I\u00fagslavach|D\u00ednear 1994 I\u00fagslavach|D\u00ednear Ch\u00f3naidhm na hI\u00fagslaive|Leu Nua R\u00f3m\u00e1nach|D\u00ednear Crua I\u00fagslavach|Leu R\u00f3m\u00e1nach|Tolar Bons Sl\u00f3v\u00e9anach|Krone Ioruach|R\u00faip\u00ed Oile\u00e1n Mhuir\u00eds|Aonad Cuntais Eorpach (XBD)|Punt Ghiobr\u00e1ltair|Dong N\u00e1isi\u00fanta V\u00edtneamach|Aonad Cuntais Eorpach (XBC)|Dong Phoblacht V\u00edtneaim|Aonad Airgeada\u00edochta Eorpach|Aonad Ilchodach Eorpach|Dollar Chireabait\u00ed|Punt San H\u00e9ilin|Dong Nua V\u00edtneamach";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|A$|USS|USN|GHC|S$|PAB|LAK|som|CHF|ATS|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|A\u00cd f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|MZE|CNP|PGK|OMS|GF|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Ean",
    "Feabh",
    "M\u00e1rta",
    "Aib",
    "Beal",
    "Meith",
    "I\u00fail",
    "L\u00fan",
    "MF\u00f3mh",
    "DF\u00f3mh",
    "Samh",
    "Noll",
    null,
  };

  private static final String[] months = {
    "Ean\u00e1ir",
    "Feabhra",
    "M\u00e1rta",
    "Aibre\u00e1n",
    "Bealtaine",
    "Meitheamh",
    "I\u00fail",
    "L\u00fanasa",
    "Me\u00e1n F\u00f3mhair",
    "Deireadh F\u00f3mhair",
    "Samhain",
    "Nollaig",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Domh",
    "Luan",
    "M\u00e1irt",
    "C\u00e9ad",
    "D\u00e9ar",
    "Aoine",
    "Sath",
  };

  private static final String[] weekdays = {
    null,
    "D\u00e9 Domhnaigh",
    "D\u00e9 Luain",
    "D\u00e9 M\u00e1irt",
    "D\u00e9 C\u00e9adaoin",
    "D\u00e9ardaoin",
    "D\u00e9 hAoine",
    "D\u00e9 Sathairn",
  };

  private static final String[] eras = {
    "RC",
    "AD",
  };

  private static final String[] ampms = {
    "a.m.",
    "p.m.",
  };

  private static final String[][] zoneStrings =
  {
    { "MAG", "Me\u00e1n-Am Greenwich", "MAG", "Me\u00e1n-Am Greenwich",  "Etc/GMT" },
    { "MAG", "Me\u00e1n-Am Greenwich", "AS\u00c9", "Am Samhraidh na h\u00c9ireann",  "Europe/Dublin" },
    { "MAG", "Me\u00e1n-Am Greenwich", "ASB", "Am Samhraidh na Breataine",  "Europe/Belfast" },
    { "MAG", "Me\u00e1n-Am Greenwich", "ASB", "Am Samhraidh na Breataine",  "Europe/London" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "T\u00edom\u00f3r-Leste|T\u00f3cal\u00e1|An T\u00e1ids\u00edceast\u00e1in|An T\u00e9alainn|T\u00f3ga|Cr\u00edocha Francacha Theas|An Ghu\u00e1in|Sead|Oile\u00e1in Turks agus Caicos|An Ghuine-Bhissau|Guam|Guatamala|An tSeoirsia Theas agus Oile\u00e1in Sandwich Theas|An Ghr\u00e9ig|An Ghuine Mhe\u00e1nchriosach|Guadal\u00faip|An tSuasalainn|An tSiria|An Ghuine|An Ghaimbia|An Ghraonlainn|An tSalvad\u00f3ir|Sao Tome agus Principe|Giobr\u00e1ltar|G\u00e1na|Suranam|An Ghu\u00e1in Fhrancach|An tSeirbia|An tSeoirsia|An tSom\u00e1il|Grenada|An tSeineag\u00e1il|San Mair\u00edne|An R\u00edocht Aontaithe|Siarra Leon|An Ghab\u00fain|An tSl\u00f3vaic|Svalbard agus Jan Mayen|An tSl\u00f3v\u00e9in|San H\u00e9ilin|Singeap\u00f3r|An tSualainn|An tS\u00fad\u00e1in|Na S\u00e9is\u00e9il|Oile\u00e1in Solomon|An Araib Sh\u00e1dach|An Fhrainc|Oile\u00e1in Fhar\u00f3|An Mhicrin\u00e9is|Ruanda|Oile\u00e1in Fh\u00e1clainne|C\u00f3naidhm na R\u00faise|Fids\u00ed|An Fhionlainn|An R\u00f3m\u00e1in|R\u00e9union|An Aet\u00f3ip|An Sp\u00e1inn|Eritrea|An Sah\u00e1ra Thiar|An \u00c9igipt|An East\u00f3in|Eacuad\u00f3r|An Ailg\u00e9ir|Catar|An Phoblacht Dhoiminiceach|Paragua|Doiminice|Palau|An Danmhairg|Djibouti|An Phortaing\u00e9il|Na Cr\u00edocha Pailist\u00edneacha|Port\u00f3 R\u00edce|An Ghearm\u00e1in|Pitcairn|Saint Pierre agus Miquelon|An Pholainn|An Phacast\u00e1in|Na hOile\u00e1in Fhilip\u00edneacha|Nua-Ghuine Phapua|An Pholain\u00e9is Fhrancach|Poblacht na Seice|Peiri\u00fa|An Chipir|Oile\u00e1n na Nollag|Rinn Verde|Panama|C\u00faba|C\u00f3sta R\u00edce|An Chol\u00f3im|An tS\u00edn|Camar\u00fan|An tSile|Oile\u00e1in Cook|An C\u00f3sta Eabhair|An Eilv\u00e9is|An Cong\u00f3|Poblacht na hAfraice L\u00e1ir|Poblacht Dhaonlathach an Chong\u00f3|Oile\u00e1in Cocos (Keeling)|Oman|Ceanada|An Bheil\u00eds|An Bhealar\u00fais|An Bhotsu\u00e1in|Oile\u00e1in Bouvet|An Bh\u00fat\u00e1in|Na Bah\u00e1ma\u00ed|An Bhrasa\u00edl|An Nua-Sh\u00e9alainn|An Bholaiv|Br\u00fain\u00e9|Beirmi\u00fada|Niue|Beinin|An Bhur\u00fain|Bair\u00e9in|N\u00e1r\u00fa|An Bhulg\u00e1ir|Buirc\u00edne Fas\u00f3|Neipeal|An Bheilg|An Iorua|An Bhanglaid\u00e9is|Barbad\u00f3s|An tSiomb\u00e1ib|An \u00cdsilt\u00edr|An Bhoisnia-Heirseagaiv\u00e9in|Nicearagua|An Nig\u00e9ir|Oile\u00e1n Norfolk|An Asarbaise\u00e1in|An N\u00edgir|An Nua-Chalad\u00f3in|Aruba|An tSaimbia|An Namaib|An Astr\u00e1il|An Ostair|Sam\u00f3 Meirice\u00e1nach|An Airgint\u00edn|An Antartaice|M\u00f3saimb\u00edc|Ang\u00f3la|An Mhalaeisia|Antill\u00ed na h\u00cdsilt\u00edre|Meicsiceo|An Airm\u00e9in|An Mhal\u00e1iv|An Alb\u00e1in|Mhaildiv\u00ed|An Afraic Theas|Oile\u00e1n Mhuir\u00eds|M\u00e1lta|Anguilla|Montsarat|An Mharat\u00e1in|Antigua agus Barbuda|Martinique|An Afganast\u00e1in|Oile\u00e1in Mariana Thuaidh|Aontas na n\u00c9im\u00edr\u00edochta\u00ed Arabacha|Mac\u00e1\u00f3 (R.R.S. na S\u00edne)|And\u00f3ra|An Mhong\u00f3il|Maenmar|Mail\u00ed|An Mhacad\u00f3in|An I\u00fagslaiv|Mayotte|Oile\u00e1in Marshall|Madagascar|An Mhold\u00f3iv|Monac\u00f3|Marac\u00f3|\u00c9imin|An Libia|An Laitvia|Lucsamburg|An Liotu\u00e1in|Leos\u00f3ta|An Lib\u00e9ir|Sr\u00ed Lanca|Lichtinst\u00e9in|Saint Lucia|An Liob\u00e1in|Laos|An Chasacst\u00e1in|Oile\u00e1in Cayman|Cu\u00e1it|An Ch\u00f3ir\u00e9 Theas|An Ch\u00f3ir\u00e9 Thuaidh|Saint Kitts agus Nevis|Oile\u00e1in Chom\u00f3ra|Cireabait\u00ed|Sam\u00f3|An Chamb\u00f3id|An Chirgeast\u00e1in|An Ch\u00e9inia|Oile\u00e1in Vail\u00eds agus Fut\u00fana|An tSeap\u00e1in|An Iord\u00e1in|Iam\u00e1ice|Vanuat\u00fa|V\u00edtneam|Oile\u00e1in na Maighdean S.A.M.|Oile\u00e1in Bhriotanacha na Maighdean|Veinis\u00e9ala|Saint Vincent agus na Grenadines|An Chathaoir Naofa (St\u00e1t Chathair na Vatac\u00e1ine)|An Iod\u00e1il|An \u00cdoslainn|An Iar\u00e1in|An Iar\u00e1ic|\u00daisb\u00e9iceast\u00e1in|Cr\u00edocha Briotanacha an Aig\u00e9in Indiagh|Urugua|An India|Iosrael|St\u00e1it Aontaithe Mheirice\u00e1|\u00c9ire|An Indin\u00e9is|Mion-Oile\u00e1in Imeallacha S.A.M.|Uganda|An \u00dacr\u00e1in|An Ung\u00e1ir|H\u00e1it\u00ed|An Chr\u00f3it|An Tans\u00e1in|Hond\u00faras|Oile\u00e1n Heard agus Oile\u00e1in McDonald|An T\u00e9av\u00e1in|Tuval\u00fa|Hong Cong (R.R.S. na S\u00edne)|Oile\u00e1in na Tr\u00edon\u00f3ide agus Tob\u00e1ga|An Tuirc|Tonga|An T\u00fain\u00e9is|An Tuircm\u00e9anast\u00e1in";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|kw|eo|ks|en|el|qu|ko|kn|kk|ka|wa|jv|pt|ps|de|pl|da|ja|vi|cy|pa|cv|cu|cs|cr|iu|it|co|is|haw|uz|io|os|ik|ce|ur|ca|ie|id|uk|ia|oc|hy|bs|br|hu|bo|bn|hr|nv|ty|bg|tt|no|be|nn|hi|tr|nl|zu|ba|he|tl|ne|az|th|nb|na|zh|as|ar|ta|gv|gu|my|mt|sw|mr|sv|af|mo|ae|mn|sr|sq|ml|ab|mk|aa|so|mi|gd|sm|sl|mg|sk|ga|sh|se|yi|sd|fy|sc|sa|fr|lv|lt|fo|ru|lo|fj|fi|ro|fa|lb|la|eu|ky|et";

  private static final String languagesValues = "Sp\u00e1innis|Cornais|Esperanto|Caism\u00edris|B\u00e9arla|Gr\u00e9igis|Ceatsuais|C\u00f3ir\u00e9is|Cannadais|Casachais|Seoirsis|Vall\u00fanais|I\u00e1vais|Portaing\u00e9ilis|Paisteo|Gearm\u00e1inis|Polainnis|Danmhairgis|Seap\u00e1inis|V\u00edtneamais|Breatnais|Puinseaibis|Suvaisis|Slavais na hEaglaise|Seicis|Cra\u00edais|Ion\u00faitis|Iod\u00e1ilis|Corsaicis|\u00cdoslainnais|Hav\u00e1\u00edais|\u00daisb\u00e9icis|Ido|\u00d3is\u00e9itis|Inupiaq|Sisinis|Urdais|Catal\u00f3inis|Interlingue|Indin\u00e9isis|\u00dacr\u00e1inis|Interlingua|Ocat\u00e1inis (tar \u00e9is 1500); Proven\u00e7al|Airm\u00e9inis|Boisnis|Briot\u00e1inis|Ung\u00e1iris|Tib\u00e9adais|Beang\u00e1lais|Cr\u00f3itis|Navach\u00f3is|Taih\u00edtis|Bulg\u00e1iris|Tatarais|Ioruais|Bealar\u00faisis|Ioruais Nynorsk|Hiond\u00fais|Tuircis|Ollainnais|S\u00fal\u00fais|Baisc\u00edris|Eabhrais|Tag\u00e1laigis|Neipealais|Asarbaise\u00e1inis|T\u00e9alainnis|Ioruais Bokm\u00e5l|N\u00e1r\u00fais|S\u00ednis|Asaimis|Araibis|Tamailis|Mannainis|G\u00faisear\u00e1itis|Burmais|Maltais|Svaha\u00edlis|Maraitis|Sualainnis|Afrac\u00e1inis|Mold\u00e1ivis|Aiv\u00e9istis|Mong\u00f3ilis|Seirbis|Alb\u00e1inis|Mail\u00e9alaimis|Abc\u00e1isis|Macad\u00f3inis|Afar|Som\u00e1lais|Maorais|Gaeilge na hAlban|Sam\u00f3is|Sl\u00f3v\u00e9inis|Malag\u00e1sais|Sl\u00f3vacais|Gaeilge|Seirbea-Chr\u00f3itis|S\u00e1imis Thuaidh|Gi\u00fadais|Sindis|Freaslainnais|Saird\u00ednis|Sanscrait|Fraincis|Laitvis|Liotu\u00e1inis|Far\u00f3is|R\u00faisis|Laosais|Fidsis|Fionnlainnis|Rom\u00e1inis|Peirsis|Leitseabuirgis|Laidin|Bascais|Cirgeasais|East\u00f3inis";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "localPatternChars", "RbMLkUnsSElFtTauKcBeyrAC" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
