/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.jce.prng;

import gnu.crypto.prng.CSPRNG;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import java.net.MalformedURLException;
import java.security.SecureRandomSpi;

public class CSPRNGSpi
extends SecureRandomSpi {
    private final IRandom adaptee = CSPRNG.getSystemInstance();

    protected byte[] engineGenerateSeed(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be nonnegative");
        }
        byte[] buf = new byte[count];
        if (count == 0) {
            return buf;
        }
        this.engineNextBytes(buf);
        return buf;
    }

    protected void engineNextBytes(byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        try {
            this.adaptee.nextBytes(buffer, 0, buffer.length);
        }
        catch (LimitReachedException lre) {
            throw new RuntimeException("random-number generator has been exhausted");
        }
    }

    protected void engineSetSeed(byte[] seed) {
        if (seed == null) {
            throw new NullPointerException();
        }
        this.adaptee.addRandomBytes(seed, 0, seed.length);
    }
}

