/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// wincvs.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "wincvs.h"

#include "MainFrm.h"
#include "wincvsDoc.h"
#include "GraphDoc.h"
#include "LogFrm.h"
#include "GraphFrm.h"
#include "wincvsView.h"
#include "GraphView.h"
#include "WinCvsBrowser.h"
#include "BrowseFileView.h"
#include "AppGlue.h"
#include "CvsPrefs.h"
#include "AppConsole.h"
#include "Splash.h"
#include "TextBinary.h"
#include "MacrosSetup.h"
#include "MultiString.h"
#include "CvsCommands.h"
#include "Authen.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// to handle auto-logout
class CLogoutThread : public CWinThread
{
public:
	DECLARE_DYNAMIC(CLogoutThread)

	CLogoutThread();
	virtual ~CLogoutThread();
	virtual void Delete();

	void KillThread(void) { m_term = true; }
		// terminate

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CLogoutThread)
	//}}AFX_VIRTUAL

protected:
	bool m_term;

	virtual BOOL InitInstance();

	// Generated message map functions
	//{{AFX_MSG(CLogoutThread)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

CLogoutThread::CLogoutThread() : m_term(false)
{
}

CLogoutThread::~CLogoutThread()
{
}

void CLogoutThread::Delete()
{
	CWinThread::Delete();
}

BOOL CLogoutThread::InitInstance()
{
	for(;;)
	{
		Sleep(300);

		if(m_term)
			return FALSE;

		CWincvsApp* app = (CWincvsApp *)AfxGetApp();
		if(gAuthen.kind() != pserver || !gCvsPrefs.HasLoogedIn() ||
			gCvsPrefs.LogoutTimeOut() <= 0 || app->gCvsRunning)
				continue;

		DWORD time = ::GetTickCount();
		if(app->GetIdleTime() != 0 &&
			(time - app->GetIdleTime()) >= (gCvsPrefs.LogoutTimeOut() * 60 * 1000))
		{
			app->ResetIdleTime();
			cvs_err("Making automatic logout after %d minute(s):\n", gCvsPrefs.LogoutTimeOut());
			CvsCmdLogout();
		}
	}

	return FALSE;
}

IMPLEMENT_DYNAMIC(CLogoutThread, CWinThread);

BEGIN_MESSAGE_MAP(CLogoutThread, CWinThread)
	//{{AFX_MSG_MAP(CLogoutThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static CLogoutThread *sLogout = 0L;

/////////////////////////////////////////////////////////////////////////////
// CWincvsApp

BEGIN_MESSAGE_MAP(CWincvsApp, CWinApp)
	ON_COMMAND(CG_IDS_TIPOFTHEDAY, ShowTipOfTheDay)
	//{{AFX_MSG_MAP(CWincvsApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_APP_COPYRIGHTS, OnAppCopyrights)
	ON_COMMAND(ID_APP_CREDITS, OnAppCredits)
	ON_UPDATE_COMMAND_UI(ID_APP_COPYRIGHTS, OnLogWindowIsPresent)
	ON_UPDATE_COMMAND_UI(ID_APP_CREDITS, OnLogWindowIsPresent)
	ON_COMMAND(ID_HELP_CVS, OnHelpCvs)
	ON_COMMAND(ID_HELP_CVSCLIENT, OnHelpCvsclient)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWincvsApp construction

CWincvsApp::CWincvsApp()
{
	gCvsRunning = false;
	gCvsStopping = false;
	gLastCvsResult = 0;
	m_idletime = 0;
}

void CWincvsApp::OnLogWindowIsPresent(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(GetConsoleView() != 0L);
}

void CWincvsApp::OnFileNew()
{
	gLogTempl->OpenDocumentFile(NULL);
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWincvsApp object

CWincvsApp theApp;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.

// {D2D77DC2-8299-11D1-8949-444553540000}
static const CLSID clsid =
{ 0xd2d77dc2, 0x8299, 0x11d1, { 0x89, 0x49, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

/////////////////////////////////////////////////////////////////////////////
// CWincvsApp initialization

BOOL CWincvsApp::InitInstance()
{
#if qDebug
	int tmpDbgFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);
	tmpDbgFlag |= _CRTDBG_LEAK_CHECK_DF;
	_CrtSetDbgFlag(tmpDbgFlag);
#endif

	// CG: The following block was added by the Splash Screen component.
	{
		CCommandLineInfo cmdInfo;
		ParseCommandLine(cmdInfo);

		CSplashWnd::EnableSplashScreen(
			(!(m_nCmdShow & SW_SHOWMINIMIZED)) && cmdInfo.m_bShowSplash);
	}

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	InitializeCriticalSection(&CCvsThread::m_lock);

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings(5);  // Load standard INI file options (including MRU)
	gCvsPrefs.load();

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	gLogTempl = new CMultiDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CWincvsDoc),
		RUNTIME_CLASS(CLogFrame),
		RUNTIME_CLASS(CWincvsView));
	AddDocTemplate(gLogTempl);

	gLogGraph = new CMultiDocTemplate(
		IDR_GRAPH,
		RUNTIME_CLASS(CGraphDoc),
		RUNTIME_CLASS(CGraphFrame),
		RUNTIME_CLASS(CGraphView));
	AddDocTemplate(gLogGraph);

	// Connect the COleTemplateServer to the document template.
	//  The COleTemplateServer creates new documents on behalf
	//  of requesting OLE containers by using information
	//  specified in the document template.
	m_server.ConnectTemplate(clsid, gLogTempl, TRUE);
		// Note: SDI applications register server objects only if /Embedding
		//   or /Automation is present on the command line.

	// Register all OLE server factories as running.  This enables the
	//  OLE libraries to create objects from other applications.
	COleTemplateServer::RegisterAll();
		// Note: MDI applications register all server objects without regard
		//  to the /Embedding or /Automation on the command line.

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_CNTR_INPLACE))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Check to see if launched as OLE server
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
#if 0
		// Register all OLE server (factories) as running.  This enables the
		//  OLE libraries to create objects from other applications.
		COleTemplateServer::RegisterAll();
#endif

		// Application was run with /Embedding or /Automation.  Don't show the
		//  main window in this case.
		return TRUE;
	}

	// When a server application is launched stand-alone, it is a good idea
	//  to update the system registry in case it has been damaged.
	m_server.UpdateRegistry(OAT_DISPATCH_OBJECT);
	COleObjectFactory::UpdateRegistryAll();

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	pMainFrame/*m_pMainWnd*/->InitialShowWindow(m_nCmdShow);
	pMainFrame/*m_pMainWnd*/->UpdateWindow();

	pMainFrame/*m_pMainWnd*/->DragAcceptFiles();
	//CWincvsView *cons = GetConsoleView();
	//if(cons != 0L)
	//	cons->DragAcceptFiles();

	MacrosReloadAll();

	// CG: This line inserted by 'Tip of the Day' component.
	ShowTipAtStartup();

	// auto-logout thread
	sLogout = new CLogoutThread();
	if (sLogout == 0L)
	{
		cvs_err("Impossible to create the auto-logout thread !\n");
	}
	else
	{
		ASSERT_VALID(sLogout);

		// Create Thread in a suspended state so we can set the Priority 
		// before it starts getting away from us
		if (!sLogout->CreateThread(CREATE_SUSPENDED))
		{
			cvs_err("Impossible to start the auto-logout thread (error %d)!\n", GetLastError());
			delete sLogout;
			sLogout = 0L;
		}

		if(sLogout != 0L)
		{
			// If you want to make the sample more sprightly, set the thread priority here 
			// a little higher. It has been set at idle priority to keep from bogging down 
			// other apps that may also be running.
			VERIFY(sLogout->SetThreadPriority(THREAD_PRIORITY_NORMAL));
			// Now the thread can run wild
			sLogout->ResumeThread();
		}
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_vers;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_vers = _T("WinCvs ");
	//}}AFX_DATA_INIT

	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	CStr vers;

	if(app->GetAppVersion(vers))
	{
		m_vers += vers;
	}
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_WINCVSVER, m_vers);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CWincvsApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

CWincvsView *CWincvsApp::GetConsoleView(void)
{
	// There are several console views, so this one
	// searchs first in the top window...
#if 0 // doesn't work
	CWnd *hWnd = CWnd::GetActiveWindow();
	if(hWnd != 0L)
	{
		CFrameWnd *fwnd = hWnd->GetTopLevelFrame();
		if(fwnd != 0L)
		{
			CFrameWnd *afwnd = fwnd->GetActiveFrame();
			if(afwnd != 0L)
			{
				CDocument *doc = afwnd->GetActiveDocument();
				if(doc != 0L)
				{
					CDocTemplate *tmpl = doc->GetDocTemplate();
					if(tmpl != 0L)
					{
						POSITION posd = tmpl->GetFirstDocPosition();
						while(posd != NULL)
						{
							doc = tmpl->GetNextDoc(posd);
							POSITION posv = doc->GetFirstViewPosition();
							CView* view;
							while(posv != NULL)
							{
								view = doc->GetNextView(posv);
								if(view->IsKindOf(RUNTIME_CLASS(CWincvsView)))
									return (CWincvsView *)view;
							}
						}
					}
				}
			}
		}
	}
#endif

	// ... and if it fails it searches in the doc templates
	// for the main console view.
	POSITION post = GetFirstDocTemplatePosition();
	CDocTemplate* tmpl;
	while(post != NULL)
	{
		tmpl = GetNextDocTemplate(post);
		if(!tmpl->IsKindOf(RUNTIME_CLASS(CMultiDocTemplate)))
			continue;
		POSITION posd = tmpl->GetFirstDocPosition();
		CDocument* doc;
		while(posd != NULL)
		{
			doc = tmpl->GetNextDoc(posd);
			if(!doc->IsKindOf(RUNTIME_CLASS(CWincvsDoc)))
				continue;
			POSITION posv = doc->GetFirstViewPosition();
			CView* view;
			while(posv != NULL)
			{
				view = doc->GetNextView(posv);
				if(view->IsKindOf(RUNTIME_CLASS(CWincvsView)))
					return (CWincvsView *)view;
			}
		}
	}
	return NULL;
}

CWinCvsBrowser *CWincvsApp::GetBrowserView(void)
{
	POSITION post = GetFirstDocTemplatePosition();
	CDocTemplate* tmpl;
	while(post != NULL)
	{
		tmpl = GetNextDocTemplate(post);
		if(!tmpl->IsKindOf(RUNTIME_CLASS(CMultiDocTemplate)))
			continue;
		POSITION posd = tmpl->GetFirstDocPosition();
		CDocument* doc;
		while(posd != NULL)
		{
			doc = tmpl->GetNextDoc(posd);
			if(!doc->IsKindOf(RUNTIME_CLASS(CWincvsDoc)))
				continue;
			POSITION posv = doc->GetFirstViewPosition();
			CView* view;
			while(posv != NULL)
			{
				view = doc->GetNextView(posv);
				if(view->IsKindOf(RUNTIME_CLASS(CWinCvsBrowser)))
					return (CWinCvsBrowser *)view;
			}
		}
	}
	return NULL;
}

CBrowseFileView *CWincvsApp::GetFileView(void)
{
	POSITION post = GetFirstDocTemplatePosition();
	CDocTemplate* tmpl;
	while(post != NULL)
	{
		tmpl = GetNextDocTemplate(post);
		if(!tmpl->IsKindOf(RUNTIME_CLASS(CMultiDocTemplate)))
			continue;
		POSITION posd = tmpl->GetFirstDocPosition();
		CDocument* doc;
		while(posd != NULL)
		{
			doc = tmpl->GetNextDoc(posd);
			if(!doc->IsKindOf(RUNTIME_CLASS(CWincvsDoc)))
				continue;
			POSITION posv = doc->GetFirstViewPosition();
			CView* view;
			while(posv != NULL)
			{
				view = doc->GetNextView(posv);
				if(view->IsKindOf(RUNTIME_CLASS(CBrowseFileView)))
					return (CBrowseFileView *)view;
			}
		}
	}
	return NULL;
}

/////////////////////////////////////////////////////////////////////////////
// CWincvsApp commands

// this one should be in MFC
void AFXAPI DDV_MinChars(CDataExchange* pDX, CString const& value, int nChars)
{
	ASSERT(nChars > 0);        // allow them something
	if (pDX->m_bSaveAndValidate && value.GetLength() < nChars)
	{
		TCHAR szT[255];
		wsprintf(szT, _T("Please enter more than %d character"), nChars);
		CString prompt;
		AfxMessageBox(szT, MB_ICONEXCLAMATION, AFX_IDP_PARSE_STRING_SIZE);
		prompt.Empty(); // exception prep
		pDX->Fail();
	}
}

void AFXAPI DDX_ComboMString(CDataExchange* pDX, int nIDC,
							 CMString & mstr, CComboBox & combo)
{
	if(!pDX->m_bSaveAndValidate)
	{
		combo.ResetContent();
		const vector<CStr> & list = mstr.GetList();
		vector<CStr>::const_iterator i;
		for(i = list.begin(); i != list.end(); ++i)
		{
			combo.AddString(*i);
		}
	}
	else
	{
		CString value;
		DDX_CBString(pDX, nIDC, value);
		if(!value.IsEmpty())
		{
			mstr.Insert(value);
		}
	}
}
	
int CWincvsApp::ExitInstance() 
{
	DeleteCriticalSection(&CCvsThread::m_lock);
	
	return CWinApp::ExitInstance();
}

void CWincvsApp::OnAppCopyrights() 
{
	cvs_out("\nBoth WinCVS and CVS are distributed under the terms of\n");
	cvs_out("the GNU General Public Licence (GPL).\n\n");
	cvs_out("* MacCVS/WinCvs : maintained by Alexandre Parenteau (aubonbeurre@geocities.com)\n");
	cvs_out("* CVS : Copyright  1989-1998 Brian Berliner, david d `zoo' zuhn,\n");
	cvs_out("        Jeff Polk, and other authors\n");
	cvs_out("* Kerberos : Copyright  1997 the Massachusetts Institute of Technology\n");
	cvs_out("* TCL : Copyright  Sun Microsystems Inc.\n");
	cvs_out("* MFC : Copyright  1992-1997 Microsoft Corporation\n");
	cvs_out("\nSome others copyrights may apply, check the source code for details.\n");
}

void CWincvsApp::OnAppCredits() 
{
	CStr vers;

	if(GetAppVersion(vers))
		cvs_out("\nWinCvs %s - Client/Local\n", (const char *)vers);
	else
		cvs_out("\nWinCvs 1.0 - Client/Local/\n");
	cvs_out("MacCVS/WinCVS are maintained by Alexandre Parenteau\n");
	cvs_out("- WinCvs page : http://www.wincvs.org\n");
	cvs_out("- cvs page : http://www.cyclic.com\n");
	cvs_out("- WinHelp cvs documentation : Norbert Klamann.\n");
	cvs_out("- Special thanks to :\n");
	cvs_out("\t* The Strata Inc. developpers who are so patients with WinCvs\n");
	cvs_out("\t  and help to identify a lot of problems.\n");
	cvs_out("\t* Jim Kingdon of Cylic Software <http://www.cyclic.com>\n");
	cvs_out("\t  who has always time to reply to (my) stupids questions about cvs.\n");
	cvs_out("- Bug reports, suggestions :\n");
	cvs_out("\t* Richard Wesley, Alain Aslag Roy, Eric Aubourg and many others\n");
	cvs_out("- Cvs contributors :\n");
	cvs_out("\t* Too many to be listed here, see the 'ChangeLog' instead !\n");
}

void CWincvsApp::ShowTipAtStartup(void)
{
	// CG: This function added by 'Tip of the Day' component.

	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	if (cmdInfo.m_bShowSplash)
	{
		CTipDlg dlg;
		if (dlg.m_bStartup)
			dlg.DoModal();
	}

}

void CWincvsApp::ShowTipOfTheDay(void)
{
	// CG: This function added by 'Tip of the Day' component.

	CTipDlg dlg;
	dlg.DoModal();

}

BOOL CWincvsApp::PreTranslateMessage(MSG* pMsg)
{
	// CG: The following lines were added by the Splash Screen component.
	if (CSplashWnd::PreTranslateAppMessage(pMsg))
		return TRUE;

	DWORD time = ::GetTickCount();
	if (m_idletime == 0 ||
		pMsg->message == WM_KEYDOWN ||
	    pMsg->message == WM_SYSKEYDOWN ||
	    pMsg->message == WM_LBUTTONDOWN ||
	    pMsg->message == WM_RBUTTONDOWN ||
	    pMsg->message == WM_MBUTTONDOWN ||
	    pMsg->message == WM_NCLBUTTONDOWN ||
	    pMsg->message == WM_NCRBUTTONDOWN ||
	    pMsg->message == WM_NCMBUTTONDOWN)
	{
		m_idletime = time;
	}

	return CWinApp::PreTranslateMessage(pMsg);
}

void CWincvsApp::GetAppPath(CStr & path)
{
	path = "";
	HINSTANCE hInst = ::AfxGetInstanceHandle();
	if(hInst != 0L)
	{
		char apath[512];
		DWORD len = ::GetModuleFileName(hInst, apath, 512);
		CStr uppath;
		CStr exefile;
		if(len > 0 && ::SplitPath(apath, uppath, exefile))
		{
			path = uppath;
		}
	}
}

void CWincvsApp::OnHelpCvs() 
{
	CWincvsApp* pApp = (CWincvsApp *)AfxGetApp();
	CStr hlp;
	pApp->GetAppPath(hlp);
	if(!hlp.empty() && !hlp.endsWith(kPathDelimiter))
	{
		hlp << kPathDelimiter;
	}
	hlp << "cvs.hlp";
	::WinHelp(*AfxGetMainWnd(), hlp, HELP_CONTENTS, 0L);
}

void CWincvsApp::OnHelpCvsclient() 
{
	CWincvsApp* pApp = (CWincvsApp *)AfxGetApp();
	CStr hlp;
	pApp->GetAppPath(hlp);
	if(!hlp.empty() && !hlp.endsWith(kPathDelimiter))
	{
		hlp << kPathDelimiter;
	}
	hlp << "cvscli.hlp";
	::WinHelp(*AfxGetMainWnd(), hlp, HELP_CONTENTS, 0L);
}

bool CWincvsApp::GetAppVersion(CStr & vers)
{
	bool bRet=false;
	char  szFullPath[_MAX_PATH]; 
    DWORD len = ::GetModuleFileName(AfxGetInstanceHandle(), szFullPath, sizeof(szFullPath)); 
	DWORD dwVerHnd; 
    DWORD dwVerInfoSize = GetFileVersionInfoSize(szFullPath, &dwVerHnd); 
    if (dwVerInfoSize && len)
    { 
        // If we were able to get the information, process it: 
        HANDLE  hMem; 
        LPVOID  lpvMem; 
        char    szGetName[256]; 
        int     cchRoot; 
 
        hMem = GlobalAlloc(GMEM_MOVEABLE, dwVerInfoSize); 
        lpvMem = GlobalLock(hMem); 
        GetFileVersionInfo(szFullPath, dwVerHnd, dwVerInfoSize, lpvMem); 
        lstrcpy(szGetName, "\\StringFileInfo\\040904b0\\"); 
        cchRoot = lstrlen(szGetName); 
 
        BOOL  fRet; 
        UINT  cchVer = 0; 
        LPVOID lszVer = NULL; 
        char  szResult[256]; 

        lstrcpy(&szGetName[cchRoot], "ProductVersion");
        fRet = VerQueryValue(lpvMem, szGetName, &lszVer, &cchVer); 

        if (fRet && cchVer && lszVer) 
        { 
            // Replace dialog item text with version info 
            lstrcpy(szResult, (char *)lszVer); 

			int v1, v2, v3, v4;
			if(sscanf(szResult, "%d,%d,%d,%d", &v1, &v2, &v3, &v4) == 4)
			{
				if(v3 != 0)
				{
					if(v3 < 0)
						sprintf(szResult, "Version %d.%db%d", v1, v2, -v3);
					else
						sprintf(szResult, "Version %d.%d.%d", v1, v2, v3);
				}
				else if(v4 != 0)
					sprintf(szResult, "Version %d.%da%d", v1, v2, v4);
				else
					sprintf(szResult, "Version %d.%d", v1, v2);

				vers = szResult;
				bRet=true;
			}
        }
        GlobalUnlock(hMem); 
        GlobalFree(hMem); 
    }
	return bRet;
}

BOOL CWincvsApp::SaveAllModified() 
{
	// prevent from exiting when cvs is running
	if(gCvsRunning)
	{
		gCvsStopping = true;
		return TRUE;
	}

	if(sLogout != 0L)
	{
		HANDLE hdl = sLogout->m_hThread;
		sLogout->KillThread();
		WaitForSingleObject(hdl, INFINITE);
		//delete sLogout;
		sLogout = 0L;
	}

	// auto-logout
	if(gAuthen.kind() == pserver && gCvsPrefs.HasLoogedIn() &&
		gCvsPrefs.LogoutTimeOut() > 0)
	{
		cvs_err("Making automatic logoutbefore quitting:\n");
		CvsCmdLogout();
		WaitForCvs();
	}

	return CWinApp::SaveAllModified();
}

CMenu* CWincvsApp::GetSubCMenu(int nStartId,CView* pThis)
{
	CMenu* pTopMenu = AfxGetMainWnd()->GetMenu();
	ASSERT(pTopMenu != 0L);
	if(pTopMenu == 0L)
		return NULL;

	CMenu* pMyMenu=NULL;
	int iPos;
	for (iPos = pTopMenu->GetMenuItemCount()-1; iPos >= 0; iPos--)
	{
		CMenu* pMenu = pTopMenu->GetSubMenu(iPos);
		if (pMenu && pMenu->GetMenuItemID(0) == nStartId)
		{
			pMyMenu = pMenu;
			break;
		}
	}
	ASSERT(pMyMenu != 0L);
	if(pMyMenu == 0L)
		return NULL;

	CCmdUI state;
	state.m_pMenu = pMyMenu;

	state.m_nIndexMax = pMyMenu->GetMenuItemCount();
	for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax;
	  state.m_nIndex++)
	{
		state.m_nID = pMyMenu->GetMenuItemID(state.m_nIndex);
		if (state.m_nID == 0)
			continue; // menu separator or invalid cmd - ignore it

		ASSERT(state.m_pOther == NULL);
		ASSERT(state.m_pMenu != NULL);
		if (state.m_nID == (UINT)-1)
		{
			// possibly a popup menu, route to first item of that popup
			state.m_pSubMenu = pMyMenu->GetSubMenu(state.m_nIndex);
			if (state.m_pSubMenu == NULL ||
				(state.m_nID = state.m_pSubMenu->GetMenuItemID(0)) == 0 ||
				state.m_nID == (UINT)-1)
			{
				continue;       // first item of popup can't be routed to
			}
			state.DoUpdate(pThis, FALSE);    // popups are never auto disabled
		}
		else
		{
			// normal menu item
			// Auto enable/disable if frame window has 'm_bAutoMenuEnable'
			//    set and command is _not_ a system command.
			state.m_pSubMenu = NULL;
			state.DoUpdate(pThis, TRUE);
		}

#	if 0 /* ??? */
		// adjust for menu deletions and additions
		UINT nCount = pMyMenu->GetMenuItemCount();
		if (nCount < state.m_nIndexMax)
		{
			state.m_nIndex -= (state.m_nIndexMax - nCount);
			while (state.m_nIndex < nCount &&
				pMyMenu->GetMenuItemID(state.m_nIndex) == state.m_nID)
			{
				state.m_nIndex++;
			}
		}
		state.m_nIndexMax = nCount;
#	endif
	}
	return pMyMenu;
}
