/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// wincvs.h : main header file for the WINCVS application
//

#if !defined(AFX_WINCVS_H__D2D77DC7_8299_11D1_8949_444553540000__INCLUDED_)
#define AFX_WINCVS_H__D2D77DC7_8299_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols
#include "MultiString.h"

/////////////////////////////////////////////////////////////////////////////
// CWincvsApp:
// See wincvs.cpp for the implementation of this class
//

class CWincvsView;
class CWinCvsBrowser;
class CBrowseFileView;
class CStr;

class CWincvsApp : public CWinApp
{
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	CWincvsApp();

	CWincvsView *GetConsoleView(void);
		// get the top console

	CWinCvsBrowser *GetBrowserView(void);
		// get the browser

	CBrowseFileView *GetFileView(void);
		// get the browser

	bool gCvsRunning;
		// the dll is running

	bool gCvsStopping;
		// the dll is about to stop

	int gLastCvsResult;
		// last know exit() return value of cvs

	CMultiDocTemplate* gLogTempl;
	CMultiDocTemplate* gLogGraph;

	void GetAppPath(CStr & path);
		// return the application path

	bool GetAppVersion(CStr & vers);
		// return false if an error occured

	inline DWORD GetIdleTime(void) const { return m_idletime; }
	inline void ResetIdleTime(void) { m_idletime = 0; }

	static CMenu* GetSubCMenu(int nStartId,CView* pThis);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWincvsApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	virtual BOOL SaveAllModified();
	//}}AFX_VIRTUAL

protected:
	afx_msg void OnFileNew();

	DWORD m_idletime;

// Implementation
	COleTemplateServer m_server;
		// Server object for document creation

	//{{AFX_MSG(CWincvsApp)
	afx_msg void OnAppAbout();
	afx_msg void OnAppCopyrights();
	afx_msg void OnAppCredits();
	afx_msg void OnLogWindowIsPresent(CCmdUI* pCmdUI);
	afx_msg void OnHelpCvs();
	afx_msg void OnHelpCvsclient();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	void ShowTipAtStartup(void);
private:
	void ShowTipOfTheDay(void);
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

void AFXAPI DDV_MinChars(CDataExchange* pDX, CString const& value, int nChars);
void AFXAPI DDX_ComboMString(CDataExchange* pDX, int nIDC,
							 CMString & mstr, CComboBox & combo);

#endif // !defined(AFX_WINCVS_H__D2D77DC7_8299_11D1_8949_444553540000__INCLUDED_)
