/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*
 * Authen.cpp --- class to manage CVS authentication kind
 */

#include "stdafx.h"

#include <string.h>
#include "Authen.h"
#include "CvsPrefs.h"

static CPersistentT<AuthenKind> gAuthenKind("P_Authen",
#ifdef macintosh
	rhosts
#else /* !macintosh */
	local
#endif /* !macintosh */
		);

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

Authen gAuthen;

// authentication class
AuthenKind Authen::kind(void)
{
	return gAuthenKind;
}

void Authen::setkind(AuthenKind newkind)
{
	gAuthenKind = newkind;
}

const char * Authen::kindstr(void)
{
	static CStr res;
	bool canProxy = false;

	switch(kind())
	{
		case pserver : canProxy = true; res = "password authentication"; break;

		case kserver : res = "kerberos authentication"; break;
		case ssh : res = "ssh authentication"; break;
		case local : res = "local mounted directory"; break;
		default :
		case rhosts : res = ".rhosts authentication"; break;
	}

	if(canProxy && gCvsPrefs.UseProxy())
	{
		res << " using a proxy";
	}

	return res;
}

const char * Authen::token(void)
{
	static CStr res;

	switch(kind())
	{
		case local : return ":local:"; break;
		default :
		case rhosts : return ""; break;
		case kserver : return ":kserver:"; break;
		case ssh : return ":ext:"; break;

		case pserver : res = ":pserver"; break;
	}

	if(gCvsPrefs.UseProxy())
	{
		res << ";proxy=";
		res << gCvsPrefs.ProxyHost();
		res << ";proxyport=";
		res << gCvsPrefs.ProxyPort();
	}
	res << ':';
	return res;
}

const char * Authen::skiptoken(const char *cvsroot)
{
	const char *secondColon;
	if(cvsroot[0] != ':' || (secondColon = strchr(cvsroot + 1, ':')) == NULL)
		return cvsroot;
	return secondColon + 1;
}

bool Authen::isdlgitem(short itemid)
{
	return itemid == kItemRHosts || itemid == kItemPServer || itemid == kItemKServer;
}

short Authen::dlgitem(void)
{
	switch(kind())
	{
		case pserver : return kItemPServer; break;
		case kserver : return kItemKServer; break;
		default :
		case rhosts : return kItemRHosts; break;
	}
	return -1;
}

void Authen::setkindbyitem(short itemid)
{
	switch(itemid)
	{
		case kItemRHosts : setkind(rhosts); break;
		case kItemPServer : setkind(pserver); break;
		case kItemKServer : setkind(kserver); break;
	}
}
