/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- February 1998
 */

/*
 * CommitDlg.cpp : the cvs commit dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#	include <ctype.h>
#	include "QCommitTab.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include <LCheckBox.h>
#	include <LTextEditView.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "CommitDlg.h"
#include "CvsPrefs.h"
#include "getline.h"
#include "TextBinary.h"
#include "MultiString.h"

static CMString gCommitLogs(10, "P_CommitLogs");

void combozify(CStr & str)
{
	// extract the first xxx words
	char *tmp = str;
	CStr result;
	int numWords = 0;
#	define HOWMUCH_WORDS 5
	while(*tmp != '\0' && numWords < HOWMUCH_WORDS)
	{
		while(*tmp != '\0' && isspace(*tmp))
			tmp++;

		while(*tmp != '\0' && !isspace(*tmp))
			result << *tmp ++;

		if(*tmp != '\0')
			result << ' ';

		numWords++;
	}

	if(*tmp != '\0')
	{
		result << "...";
	}
	str = result;
}

#ifdef WIN32
#	include "GetPrefs.h"
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CCommit_MAIN, CPropertyPage)

CCommit_MAIN::CCommit_MAIN() : CPropertyPage(CCommit_MAIN::IDD)
{
}

CCommit_MAIN::CCommit_MAIN(const char *logmsg, const char *pathTmpl) :
	CPropertyPage(CCommit_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CCommit_MAIN)
	m_logmsg = logmsg;
	m_norecurs = FALSE;
	//}}AFX_DATA_INIT
	m_tmplPath = pathTmpl;
	if(!m_tmplPath.empty())
	{
		if(!m_tmplPath.endsWith(kPathDelimiter))
			m_tmplPath << kPathDelimiter;
		m_tmplPath << "CVS";
		m_tmplPath << kPathDelimiter;
		m_tmplPath << "Template";
	}
}

CCommit_MAIN::~CCommit_MAIN()
{
}

void CCommit_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCommit_MAIN)
	DDX_Control(pDX, IDC_LOGMSG, m_rich);
	DDX_Control(pDX, IDC_COMBO, m_combodef);
	DDX_Text(pDX, IDC_LOGMSG, m_logmsg);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	//}}AFX_DATA_MAP

	if(!pDX->m_bSaveAndValidate)
	{
		m_combodef.ResetContent();
		m_combodef.AddString("Insert CVS/Template");
		const NAMESPACE(std) vector<CStr> & list = gCommitLogs.GetList();
		NAMESPACE(std) vector<CStr>::const_iterator i;
		for(i = list.begin(); i != list.end(); ++i)
		{
			CStr str = *i;
			combozify(str);
			m_combodef.AddString(str);
		}
	}
	else
	{
		if(!m_logmsg.IsEmpty())
		{
			gCommitLogs.Insert(m_logmsg);
		}
	}
}

void CCommit_MAIN::OnSelchangeCombo() 
{
	int sel = m_combodef.GetCurSel();
	if(sel == CB_ERR)
		return;

	m_rich.SetSel(0, -1);
	if(sel == 0)
	{
		bool gotIt = false;
		FILE *output;

		if(!m_tmplPath.empty() && (output = fopen(m_tmplPath, "r")) != 0L)
		{
			char *line = 0L;
			size_t line_chars_allocated = 0;
			int line_length;
			while ((line_length = getline (&line, &line_chars_allocated, output)) > 0)
			{
				m_rich.ReplaceSel(line);
				//m_rich.ReplaceSel("\r\n");
			}

			gotIt = true;
			if (line_length < 0 && !feof (output))
				gotIt = false;

			if(line != 0L)
				free (line);

			fclose(output);
		}
		if(!gotIt)
			m_rich.ReplaceSel("*found no CVS/Template file*");
	}
	else
	{
		const NAMESPACE(std) vector<CStr> & list = gCommitLogs.GetList();
		m_rich.ReplaceSel(list[sel - 1]);
	}
}

BEGIN_MESSAGE_MAP(CCommit_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CCommit_MAIN)
	ON_CBN_SELCHANGE(IDC_COMBO, OnSelchangeCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif /* WIN32 */

#ifdef qMacCvsPP
class LLogFillerWrapper : public LFillerWrapper
{
public:
	LLogFillerWrapper(LMenuController *menu, CMString & mstr, const char *pathTmpl) :
		LFillerWrapper(menu), fMStr(mstr), fFirstTime(true)
	{
		fTmplPath = pathTmpl;
		if(!fTmplPath.empty())
		{
			if(!fTmplPath.endsWith(kPathDelimiter))
				fTmplPath << kPathDelimiter;
			fTmplPath << "CVS";
			fTmplPath << kPathDelimiter;
			fTmplPath << "Template";
		}

	}
	
	virtual void OnAddingItem(CStr & str)
	{
		if(fFirstTime)
		{
			fMenu->InsertMenuItem("\pInsert CVS/Template", max_Int16);
			fMenu->InsertMenuItem("\p(-", max_Int16, false);
			fFirstTime = false;
		}
		
		combozify(str);
		CPStr pstr(str);
		fMenu->InsertMenuItem(pstr, max_Int16);
	}
	
	virtual bool OnSelectingItem(Int32 inItem, CStr & str)
	{
		str = "";
		if(inItem == 2)
		{
			bool gotIt = false;
			FILE *output;
			if(!fTmplPath.empty() && (output = fopen(fTmplPath, "r")) != 0L)
			{
				char *line = 0L;
				size_t line_chars_allocated = 0;
				int line_length;
				while ((line_length = getline (&line, &line_chars_allocated, output)) > 0)
				{
					char *tmp = line;
					while((tmp = strchr(tmp, '\n')) != 0L)
					{
						*tmp++ = '\r';
					}
					str << line;
				}

				gotIt = true;
				if (line_length < 0 && !feof (output))
					gotIt = false;

				if(line != 0L)
					free (line);

				fclose(output);
			}
			if(!gotIt)
				str << "*found no CVS/Template file*";
			return true;
		}
		else if(inItem >= 4)
		{
			str = fMStr.GetList()[inItem - 4];
			return true;
		}
		
		return false;
	}
protected:
	CMString & fMStr;
	CStr fTmplPath;
	bool fFirstTime;
};

static void DoDataExchange_Commit(LWindow *theDialog, CStr & commit, bool & norecurs,
	const char *pathTmpl, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LTextEditView *editLog = dynamic_cast<LTextEditView*>
		(theDialog->FindPaneByID(item_LogMsg));
	LPopupFiller *fillLog = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LLogFillerWrapper *wrapper = putValue ? new LLogFillerWrapper(fillLog, gCommitLogs, pathTmpl) : 0L;
	
	fillLog->DoDataExchange(gCommitLogs, putValue, wrapper);
	
	if(putValue)
	{
		chkNoRecurs->SetValue(norecurs ? Button_On : Button_Off);
		editLog->SetTextPtr((Ptr)(const char *)commit, commit.length());	
		theDialog->SetLatentSub(editLog);
	}
	else
	{
		norecurs = chkNoRecurs->GetValue() == Button_On;
		Handle hdl = editLog->GetTextHandle();
		Assert_(hdl != 0L);
		commit.set(*hdl, GetHandleSize(hdl));
		
	}
}
#endif /* qMacCvsPP */

bool CompatGetCommit(CStr & commit, bool & norecurs, const char *pathTmpl)
{
	bool userHitOK = false;
	norecurs = false;
	commit = "";
	
	static CStr sLastMsg;

#ifdef WIN32
	CPropertySheet pages("Commit settings");
	CCommit_MAIN page1(sLastMsg, pathTmpl);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		commit = (const char *)page1.m_logmsg;
		sLastMsg = (const char *)page1.m_logmsg;
		norecurs = page1.m_norecurs ? true : false;
		page2.StoreValues();

		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Commit, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_Commit(theDialog, sLastMsg, norecurs, pathTmpl, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_Commit(theDialog, sLastMsg, norecurs, pathTmpl, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		commit = sLastMsg;
		commit.replace('\015', '\012');
		userHitOK = true;
	}
#endif /* qMacCvsPP */
#ifdef qQT
	QCommitTab dlg;
	dlg.fDlg1.DoDataExchange(true, sLastMsg, norecurs, pathTmpl, gCommitLogs);
	dlg.fDlg2.DoDataExchange(true);
	if(dlg.exec() == QDialog::Accepted)
	{
		dlg.fDlg1.DoDataExchange(false, sLastMsg, norecurs, pathTmpl, gCommitLogs);
		dlg.fDlg2.DoDataExchange(false);
		commit = sLastMsg;
		userHitOK = true;
	}
#endif /* qQT */

	if(userHitOK)
	{
		if(commit.length() == 0)
			commit = "no message";
		gCvsPrefs.save();
	}
	return userHitOK;
}
