/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// GetPrefs.cpp : implementation file
//

#include "stdafx.h"

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>

#	include "MacCvsApp.h"
#	include "MacBinEncoding.h"
#endif /* qMacCvsPP */

#ifdef qQT
#	include "qcvsapp.h"
#	include "QGetPrefsTab.h"
#endif /* qQT */

#ifdef WIN32
#	include "wincvs.h"
#	include <afxdao.h>
#	include "PromptFiles.h"
#	include "MultiFiles.h"
#	include "CvsArgs.h"
#	include "FileTraversal.h"
#endif /* WIN32 */

#include "GetPrefs.h"
#include "CvsPrefs.h"
#include "Authen.h"
#include "AppConsole.h"

#ifdef WIN32

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

// CVSROOT page
IMPLEMENT_DYNCREATE(CGetPrefs_CVSROOT, CPropertyPage)

CGetPrefs_CVSROOT::CGetPrefs_CVSROOT() : CPropertyPage(CGetPrefs_CVSROOT::IDD)
{
	//{{AFX_DATA_INIT(CGetPrefs_CVSROOT)
	m_cvsroot = (const char *)gCvsPrefs;
	m_cvsvers = _T("Use cvs 1.10");
	m_passwdport = 0;
	m_authen = gAuthen.kind();
	//}}AFX_DATA_INIT
}

CGetPrefs_CVSROOT::~CGetPrefs_CVSROOT()
{
}

BOOL CGetPrefs_CVSROOT::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();

	for(int i =0; i < NUM_CVSROOT; i++)
	{
		const CPStr & strroot =
			(*(const CvsPrefs *)&gCvsPrefs).get_cvsroot_list(i);
		if(!strroot.empty())
			m_ctrlroot.InsertString(-1, (const char *)strroot);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGetPrefs_CVSROOT::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CGetPrefs_CVSROOT)
	DDX_Control(pDX, IDC_AUTHEN, m_comboauthen);
	DDX_Control(pDX, IDC_COMBOROOT, m_ctrlroot);
	DDX_CBString(pDX, IDC_COMBOROOT, m_cvsroot);
	DDV_MinChars(pDX, m_cvsroot, 1);
	DDX_CBString(pDX, IDC_CVSVERS, m_cvsvers);
	//}}AFX_DATA_MAP

	if(pDX->m_bSaveAndValidate)
	{
		switch(m_comboauthen.GetCurSel())
		{
			default:
			case 0: m_authen = local; break;
			case 1: m_authen = rhosts; break;
			case 2: m_authen = pserver; break;
			case 3: m_authen = ssh; break;
		}
	}
	else
	{
		switch(m_authen)
		{
			default:
			case local: m_comboauthen.SetCurSel(0); break;
			case rhosts: m_comboauthen.SetCurSel(1); break;
			case pserver: m_comboauthen.SetCurSel(2); break;
			case ssh: m_comboauthen.SetCurSel(3); break;
		}
	}
}

void CGetPrefs_CVSROOT::StoreValues()
{
	gCvsPrefs = (const char *)m_cvsroot;
	gAuthen.setkind(m_authen);
}

BEGIN_MESSAGE_MAP(CGetPrefs_CVSROOT, CPropertyPage)
	//{{AFX_MSG_MAP(CGetPrefs_CVSROOT)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Globals options page
IMPLEMENT_DYNCREATE(CGetPrefs_GLOBALS, CPropertyPage)

CGetPrefs_GLOBALS::CGetPrefs_GLOBALS() : CPropertyPage(CGetPrefs_GLOBALS::IDD)
{
	//{{AFX_DATA_INIT(CGetPrefs_GLOBALS)
	m_checkoutro = gCvsPrefs.CheckoutRO();
	m_prune = gCvsPrefs.PruneOption();
	m_tcpip = gCvsPrefs.Z9Option();
	m_quiet = gCvsPrefs.QuietOption();
	m_cntladd = gCvsPrefs.AddControl();
	m_dirty = gCvsPrefs.DirtySupport();
	m_alwaysroot = gCvsPrefs.AlwaysUseCvsroot();
	m_logout = gCvsPrefs.LogoutTimeOut() > 0;
	m_editlogout = gCvsPrefs.LogoutTimeOut();
	//}}AFX_DATA_INIT
}

CGetPrefs_GLOBALS::~CGetPrefs_GLOBALS()
{
}

void CGetPrefs_GLOBALS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CGetPrefs_GLOBALS)
	DDX_Control(pDX, IDC_SPINLOGOUT, m_spin);
	DDX_Check(pDX, IDC_CHECKOUTRO, m_checkoutro);
	DDX_Check(pDX, IDC_PRUNE, m_prune);
	DDX_Check(pDX, IDC_TCPIP, m_tcpip);
	DDX_Check(pDX, IDC_QUIET, m_quiet);
	DDX_Check(pDX, IDC_CTNLADD, m_cntladd);
	DDX_Check(pDX, IDC_DIRTYSUPPORT, m_dirty);
	DDX_Check(pDX, IDC_ALWAYSROOT, m_alwaysroot);
	DDX_Check(pDX, IDC_LOGOUT, m_logout);
	DDX_Text(pDX, IDC_EDITLOGOUT, m_editlogout);
	DDV_MinMaxUInt(pDX, m_editlogout, 0, 999999);
	//}}AFX_DATA_MAP

	if(!pDX->m_bSaveAndValidate)
	{
		CWnd* wnd = (CButton *)GetDlgItem(IDC_EDITLOGOUT);
		m_spin.SetBase(10);
		m_spin.SetRange(0, 30000);
		m_spin.SetBuddy(wnd);
		OnLogout();
	}
}

void CGetPrefs_GLOBALS::StoreValues()
{
	gCvsPrefs.SetCheckoutRO(m_checkoutro ? true : false);
	gCvsPrefs.SetPruneOption(m_prune ? true : false);
	gCvsPrefs.SetZ9Option(m_tcpip ? true : false);
	gCvsPrefs.SetQuietOption(m_quiet ? true : false);
	gCvsPrefs.SetAddControl(m_cntladd ? true : false);
	gCvsPrefs.SetDirtySupport(m_dirty ? true : false);
	gCvsPrefs.SetAlwaysUseCvsroot(m_alwaysroot ? true : false);
	gCvsPrefs.SetLogoutTimeOut(m_logout ? (int)m_editlogout : 0);
}

BEGIN_MESSAGE_MAP(CGetPrefs_GLOBALS, CPropertyPage)
	//{{AFX_MSG_MAP(CGetPrefs_GLOBALS)
	ON_BN_CLICKED(IDC_LOGOUT, OnLogout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGetPrefs_GLOBALS::OnLogout() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_LOGOUT);
	CWnd* wnd = (CButton *)GetDlgItem(IDC_EDITLOGOUT);
	wnd->EnableWindow(but->GetCheck() == 1);
	wnd = (CButton *)GetDlgItem(IDC_SPINLOGOUT);
	wnd->EnableWindow(but->GetCheck() == 1);
}

IMPLEMENT_DYNCREATE(CGetPrefs_PORTS, CPropertyPage)

CGetPrefs_PORTS::CGetPrefs_PORTS() : CPropertyPage(CGetPrefs_PORTS::IDD)
{
	//{{AFX_DATA_INIT(CGetPrefs_PORTS)
	m_checkkserver = gCvsPrefs.KserverPort() != -1;
	m_checkpserver = gCvsPrefs.PserverPort() != -1;
	m_checkrhost = gCvsPrefs.RhostPort() != -1;
	m_portkserver = gCvsPrefs.KserverPort() != -1 ? gCvsPrefs.KserverPort() : 0;
	m_portpserver = gCvsPrefs.PserverPort() != -1 ? gCvsPrefs.PserverPort() : 0;
	m_portrhost = gCvsPrefs.RhostPort() != -1 ? gCvsPrefs.RhostPort() : 0;
	m_checksname = gCvsPrefs.ServerName() != 0L;
	m_sname = gCvsPrefs.ServerName() == 0L ? _T("cvs") : gCvsPrefs.ServerName();
	m_checkrsh = gCvsPrefs.RshName() != 0L;
	m_rshname = gCvsPrefs.RshName() == 0L ? _T("ssh") : gCvsPrefs.RshName();
	//}}AFX_DATA_INIT
}

CGetPrefs_PORTS::~CGetPrefs_PORTS()
{
}

void CGetPrefs_PORTS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetPrefs_PORTS)
	DDX_Check(pDX, IDC_CHECKKSERVERPORT, m_checkkserver);
	DDX_Check(pDX, IDC_CHECKPSERVERPORT, m_checkpserver);
	DDX_Check(pDX, IDC_CHECKRHOSTPORT, m_checkrhost);
	DDX_Text(pDX, IDC_KSERVERPORT, m_portkserver);
	DDV_MinMaxUInt(pDX, m_portkserver, 0, 999999);
	DDX_Text(pDX, IDC_PSERVERPORT, m_portpserver);
	DDV_MinMaxUInt(pDX, m_portpserver, 0, 999999);
	DDX_Text(pDX, IDC_RHOSTPORT, m_portrhost);
	DDV_MinMaxUInt(pDX, m_portrhost, 0, 999999);
	DDX_Check(pDX, IDC_CHECKSERVERNAME, m_checksname);
	DDX_Text(pDX, IDC_SERVERNAME, m_sname);
	DDX_Check(pDX, IDC_CHECKRSHNAME, m_checkrsh);
	DDX_Text(pDX, IDC_RSHNAME, m_rshname);
	//}}AFX_DATA_MAP

	if(!pDX->m_bSaveAndValidate)
	{
		OnCheckkserverport();
		OnCheckpserverport();
		OnCheckrhostport();
		OnCheckservername();
		OnCheckrshname();
	}
}

BEGIN_MESSAGE_MAP(CGetPrefs_PORTS, CPropertyPage)
	//{{AFX_MSG_MAP(CGetPrefs_PORTS)
	ON_BN_CLICKED(IDC_CHECKKSERVERPORT, OnCheckkserverport)
	ON_BN_CLICKED(IDC_CHECKPSERVERPORT, OnCheckpserverport)
	ON_BN_CLICKED(IDC_CHECKRHOSTPORT, OnCheckrhostport)
	ON_BN_CLICKED(IDC_CHECKSERVERNAME, OnCheckservername)
	ON_BN_CLICKED(IDC_CHECKRSHNAME, OnCheckrshname)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetPrefs_PORTS message handlers

void CGetPrefs_PORTS::OnCheckkserverport() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_CHECKKSERVERPORT);
	CWnd* wnd = (CButton *)GetDlgItem(IDC_KSERVERPORT);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CGetPrefs_PORTS::OnCheckpserverport() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_CHECKPSERVERPORT);
	CWnd* wnd = (CButton *)GetDlgItem(IDC_PSERVERPORT);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CGetPrefs_PORTS::OnCheckrhostport() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_CHECKRHOSTPORT);
	CWnd* wnd = (CButton *)GetDlgItem(IDC_RHOSTPORT);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CGetPrefs_PORTS::OnCheckservername() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_CHECKSERVERNAME);
	CWnd* wnd = (CButton *)GetDlgItem(IDC_SERVERNAME);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CGetPrefs_PORTS::OnCheckrshname() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_CHECKRSHNAME);
	CWnd* wnd = (CButton *)GetDlgItem(IDC_RSHNAME);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CGetPrefs_PORTS::StoreValues()
{
	gCvsPrefs.SetKserverPort(m_checkkserver ? (int)m_portkserver : -1);
	gCvsPrefs.SetPserverPort(m_checkpserver ? (int)m_portpserver : -1);
	gCvsPrefs.SetRhostPort(m_checkrhost ? (int)m_portrhost : -1);
	gCvsPrefs.SetServerName(m_checksname ? (const char *)m_sname : 0L);
	gCvsPrefs.SetRshName(m_checkrsh ? (const char *)m_rshname : 0L);
}

/////////////////////////////////////////////////////////////////////////////
// CGetPrefs_PROXY property page

IMPLEMENT_DYNCREATE(CGetPrefs_PROXY, CPropertyPage)

CGetPrefs_PROXY::CGetPrefs_PROXY() : CPropertyPage(CGetPrefs_PROXY::IDD)
{
	//{{AFX_DATA_INIT(CGetPrefs_PROXY)
	m_useproxy = gCvsPrefs.UseProxy();
	m_host = gCvsPrefs.ProxyHost();
	m_port = gCvsPrefs.ProxyPort();
	//}}AFX_DATA_INIT
}

CGetPrefs_PROXY::~CGetPrefs_PROXY()
{
}

void CGetPrefs_PROXY::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetPrefs_PROXY)
	DDX_Check(pDX, IDC_CHECKPROXY, m_useproxy);
	DDX_Text(pDX, IDC_EDITHOST, m_host);
	DDX_Text(pDX, IDC_EDITPORT, m_port);
	DDV_MinMaxUInt(pDX, m_port, 0, 999999);
	//}}AFX_DATA_MAP
	if(!pDX->m_bSaveAndValidate)
	{
		OnCheckproxy();
	}
}

BEGIN_MESSAGE_MAP(CGetPrefs_PROXY, CPropertyPage)
	//{{AFX_MSG_MAP(CGetPrefs_PROXY)
	ON_BN_CLICKED(IDC_CHECKPROXY, OnCheckproxy)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGetPrefs_PROXY::OnCheckproxy() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_CHECKPROXY);
	CWnd* wnd = (CButton *)GetDlgItem(IDC_EDITHOST);
	wnd->EnableWindow(but->GetCheck() == 1);
	wnd = (CButton *)GetDlgItem(IDC_EDITPORT);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CGetPrefs_PROXY::StoreValues()
{
	gCvsPrefs.SetUseProxy(m_useproxy != 0);
	gCvsPrefs.SetProxyHost(m_host);
	gCvsPrefs.SetProxyPort(m_port);
}

// WinCvs options page
IMPLEMENT_DYNCREATE(CGetPrefs_WINCVS, CPropertyPage)

CGetPrefs_WINCVS::CGetPrefs_WINCVS() : CPropertyPage(CGetPrefs_WINCVS::IDD)
{
	//{{AFX_DATA_INIT(CGetPrefs_WINCVS)
	m_viewer = gCvsPrefs.Viewer() != 0L ? gCvsPrefs.Viewer() : "";
	m_diffprog = gCvsPrefs.ExtDiff() != 0L ? gCvsPrefs.ExtDiff() : "";
	m_chkdiff = gCvsPrefs.ExtDiff() != 0L;
	m_home = gCvsPrefs.Home() != 0L ? gCvsPrefs.Home() : "";
	//}}AFX_DATA_INIT
}

CGetPrefs_WINCVS::~CGetPrefs_WINCVS()
{
}

void CGetPrefs_WINCVS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CGetPrefs_WINCVS)
	DDX_Text(pDX, IDC_PROGRAM, m_viewer);
	DDX_Text(pDX, IDC_DIFFPROG, m_diffprog);
	DDX_Check(pDX, IDC_EXTDIFF, m_chkdiff);
	DDX_Text(pDX, IDC_HOME, m_home);
	//}}AFX_DATA_MAP
	if(!pDX->m_bSaveAndValidate)
	{
		OnExtdiff();
	}
}

void CGetPrefs_WINCVS::StoreValues()
{
	if(!m_viewer.IsEmpty())
		gCvsPrefs.SetViewer(m_viewer);
	else
		gCvsPrefs.SetViewer(0L);
	if(m_chkdiff && !m_diffprog.IsEmpty())
		gCvsPrefs.SetExtDiff(m_diffprog);
	else
		gCvsPrefs.SetExtDiff(0L);
	if(!m_home.IsEmpty())
		gCvsPrefs.SetHome(m_home);
}

BEGIN_MESSAGE_MAP(CGetPrefs_WINCVS, CPropertyPage)
	//{{AFX_MSG_MAP(CGetPrefs_WINCVS)
	ON_BN_CLICKED(IDC_BTNPROGRAM, OnBtnviewer)
	ON_BN_CLICKED(IDC_EXTDIFFSEL, OnExtdiffsel)
	ON_BN_CLICKED(IDC_EXTDIFF, OnExtdiff)
	ON_BN_CLICKED(IDC_BTNHOME, OnBtnhome)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGetPrefs_WINCVS::OnBtnviewer()
{
	MultiFiles mf;
	if(!BrowserGetMultiFiles("Select a program :", mf))
		return;

	CvsArgs args(false);
	mf.next();
	const char *dir = mf.add(args);
	char * const *argv = args.Argv();
	CStr fullpath;
	fullpath = dir;
	if(!fullpath.endsWith(kPathDelimiter))
		fullpath << kPathDelimiter;
	fullpath << argv[0];

	SetDlgItemText(IDC_PROGRAM, fullpath);
}

void CGetPrefs_WINCVS::OnExtdiffsel()
{
	MultiFiles mf;
	if(!BrowserGetMultiFiles("Select a diff program :", mf))
		return;

	CvsArgs args(false);
	mf.next();
	const char *dir = mf.add(args);
	char * const *argv = args.Argv();
	CStr fullpath;
	fullpath = dir;
	if(!fullpath.endsWith(kPathDelimiter))
		fullpath << kPathDelimiter;
	fullpath << argv[0];

	SetDlgItemText(IDC_DIFFPROG, fullpath);
}

void CGetPrefs_WINCVS::OnExtdiff() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_EXTDIFF);
	CWnd* wnd = GetDlgItem(IDC_DIFFPROG);
	wnd->EnableWindow(but->GetCheck() == 1);
	wnd = GetDlgItem(IDC_EXTDIFFSEL);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CGetPrefs_WINCVS::OnBtnhome()
{
	const char *dir = BrowserGetDirectory("Select a directory to be the HOME :");
	if(dir != NULL)
		SetDlgItemText(IDC_HOME, dir);
}

#endif /* WIN32 */

void CompatGetPrefs(void)
{
#ifdef WIN32
	CPropertySheet pages("WinCvs Preferences");
	CGetPrefs_CVSROOT page1;
	CGetPrefs_GLOBALS page2;
	CGetPrefs_PORTS page3;
	CGetPrefs_PROXY page3b;
	CGetPrefs_WINCVS page4;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	pages.AddPage(&page3b);
	pages.AddPage(&page4);
	if(pages.DoModal() == IDOK)
	{
		page1.StoreValues();
		page2.StoreValues();
		page3.StoreValues();
		page3b.StoreValues();
		page4.StoreValues();
		gCvsPrefs.save();
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	MacBinMaps maps;
	maps.LoadDefaults();
	CMacBinTable::SetCurrentMap(&maps);

	StDialogHandler	theHandler(dlg_Prefs, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(6);
	DoDataExchange_Fonts(theDialog, true);
	multiView->SwitchToPanel(5);
	DoDataExchange_Ports(theDialog, true);
	multiView->SwitchToPanel(4);
	DoDataExchange_BinFiles(theDialog, maps, true);
	multiView->SwitchToPanel(3);
	DoDataExchange_TextFiles(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_Cvsroot(theDialog, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_Cvsroot(theDialog, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_TextFiles(theDialog, false);
		multiView->SwitchToPanel(4);
		DoDataExchange_BinFiles(theDialog, maps, false);
		multiView->SwitchToPanel(5);
		DoDataExchange_Ports(theDialog, false);
		multiView->SwitchToPanel(6);
		DoDataExchange_Fonts(theDialog, false);

		maps.SaveDefaults();
	}
#endif /* qMacCvsPP */
#ifdef qQT
	QGetPrefsTab dlg;
	dlg.fDlg1.DoDataExchange(true);
	dlg.fDlg2.DoDataExchange(true);
	dlg.fDlg3.DoDataExchange(true);
	if(dlg.exec() == QDialog::Accepted)
	{
		dlg.fDlg1.DoDataExchange(false);
		dlg.fDlg2.DoDataExchange(false);
		dlg.fDlg3.DoDataExchange(false);
	}
#endif /* qQT */
	if(!gCvsPrefs.empty())
	{
		cvs_out("NEW CVSROOT: %s (%s)\n", (const char *)gCvsPrefs, gAuthen.kindstr());
		gCvsPrefs.save();
	}
}
