/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// GetValue.cpp : implementation file
//

#include "stdafx.h"

#ifdef macintosh
#	define kDlgIdGetValue 128
#	include <Dialogs.h>
#	include <TextUtils.h>
#	include <string.h>
#	include "MacMisc.h"
#endif /* macintosh */

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#include "GetValue.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// GetValue dialog


GetValue::GetValue(const char *defvalue, const char *title, CWnd* pParent /*=NULL*/)
	: CDialog(GetValue::IDD, pParent)
{
	//{{AFX_DATA_INIT(GetValue)
	m_value = defvalue != NULL ? defvalue : "";
	m_prompt = title != NULL ? title : "";
	//}}AFX_DATA_INIT
}

//BOOL GetValue::OnInitDialog()
//{
//	BOOL result = CDialog::OnInitDialog();
//
//	if (result)
//		GotoDlgCtrl(GetDlgItem(IDC_PROMPTEDIT));
//
//	return result;
//}

void GetValue::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(GetValue)
	DDX_Text(pDX, IDC_PROMPTVALUE, m_prompt);
	DDX_Text(pDX, IDC_PROMPTEDIT, m_value);
	DDV_MinChars(pDX, m_value, 1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(GetValue, CDialog)
	//{{AFX_MSG_MAP(GetValue)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// GetValue message handlers
#endif /* WIN32 */

bool CompatGetValue(char *value, const char *defvalue, const char *title)
{
#ifdef WIN32
	GetValue gv(defvalue, title);
	if(gv.DoModal() == IDOK)
	{
		strcpy(value, gv.m_value);
		return true;
	}
	return false;
#endif /* WIN32 */
#ifdef macintosh
	GrafPtr		OldPort;
	DialogPtr	alertDialog;
	short		WhichItem = 0;
	Str255 pdef = {'\0'}, ptitle = {'\0'}, pvalue;
	
	if(defvalue != NULL)
	{
		strcpy((char *)pdef, defvalue);
		c2pstr((char *)pdef);
	}
	if(title != NULL)
	{
		strcpy((char *)ptitle, title);
		c2pstr((char *)ptitle);
	}

	GetPort(&OldPort);
	alertDialog = GetNewDialog(kDlgIdGetValue, NULL, (WindowPtr)-1);
	SetPort(alertDialog);
	
	SetDialogItemText(GetDItemHdl(alertDialog, 3), pdef);
	SetDialogItemText(GetDItemHdl(alertDialog, 4), ptitle);

	while(WhichItem != 1 && WhichItem != 2)
	{
		ModalDialog(NULL, &WhichItem);

		if(WhichItem == 1)
		{
			GetDialogItemText(GetDItemHdl(alertDialog, 3), pvalue);
			if(pvalue[0] == '\0')
				WhichItem = 0;
		}
	}
	
	if(WhichItem == 1)
	{
		GetDialogItemText(GetDItemHdl(alertDialog, 3), pvalue);
		p2cstr(pvalue);
		strcpy(value, (char *)pvalue);
	}

	DisposeDialog(alertDialog);
	SetPort(OldPort);
	
	return WhichItem == 1;
#endif /* macintosh */
#ifdef UNIX_CVS
	return false;
#endif /* UNIX_CVS */
}
