/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- August 1998
 */

/*
 * MacrosSetup.cpp --- hook the macros files
 */

#include "stdafx.h"

#ifdef macintosh
#	include <GUSI.h>
#endif

#ifdef qQT
#	include "qcvsapp.h"
#	include <ctype.h>
#endif /* qQT */

#ifdef HAVE_ERRNO_H
#	include <errno.h>
#endif

#include "MacrosSetup.h"
#include "AppConsole.h"
#include "FileTraversal.h"
#include "getline.h"
#include "CvsArgs.h"

#ifdef macintosh
#	include "MacMisc.h"
#	include <errno.h>
#endif

#ifdef qMacCvsPP
#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "getopt.h"

#ifdef WIN32
#	include "wincvs.h"
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

CMacroSet gMacrosAdmin;
CMacroSet gMacrosFiles;
CMacroSet gMacrosFolder;
CMacroSet gMacrosSel;

static void GetMacrosLoc(CStr & path)
{
	path = "";
#ifndef qQT
#	ifdef WIN32
	CWincvsApp* pApp = (CWincvsApp *)AfxGetApp();
	pApp->GetAppPath(path);
#	endif /* WIN32 */
#	ifdef qMacCvsPP
	path = CMacCvsApp::GetAppPath();
#	endif /* qMacCvsPP */

	if(!path.empty() && !path.endsWith(kPathDelimiter))
	{
		path << kPathDelimiter;
	}
	path << MACROS_FOLDER;
#else /* qQT */
	path = QCvsApp::qApp->GetPkgDataDir();
#endif /* qQT */
}

static void MacrosFlushAll(void)
{
	gMacrosAdmin.Flush();
	gMacrosFiles.Flush();
	gMacrosFolder.Flush();
	gMacrosSel.Flush();
}

class MacroTraversal : public TraversalReport
{
public:
	virtual kTraversal OnError(const char *err, int errcode)
	{
		cvs_err(err);
		return kTraversalError;
	}

	virtual kTraversal OnFile(const char *fullpath,
		const char *fullname,
		const char *name,
		const struct stat & dir, FSSpec * macspec);
};

kTraversal MacroTraversal::OnFile(const char *fullpath,
	const char *fullname,
	const char *name,
	const struct stat & dir, FSSpec * macspec)
{
	if(stricmp(name + strlen(name) - 4, ".tcl"))
		return kContinueTraversal;

	FILE *fpin = fopen(fullname, "r");
	if(fpin == 0L)
	{
		cvs_err("Impossible to open '%s' (error %d)\n", fullname, errno);
		return kContinueTraversal;
	}

	char *oldline = 0L;
	int line_length;
	size_t line_chars_allocated = 0;
	CvsArgs args(false);
	args.add("dummy");

	if((line_length = getline (&oldline, &line_chars_allocated, fpin)) > 0 &&
		strnicmp(oldline, "#!CVSGUI1.0", strlen("#!CVSGUI1.0")) == 0)
	{
		char *line = oldline + strlen("#!CVSGUI1.0");

		while(*line)
		{
			int hasQuote = 0;
			char *temp;

			// Search for the non space char
			while(*line && isspace(*line))
				++line;

			// handle the quote
			if((*line) == '"')
			{
				hasQuote = 1;
				line++;
			}
			for(temp=line;*line;++line)
			{
				if((*line) == '"')
				{
					if(hasQuote)
					{
						hasQuote = 0; /* ok doc */
						break;
					}
				}
				if(isspace(*line) && !hasQuote)
					break;
			}
			if(hasQuote) /* mismatch quote */
				temp = line;

			if(temp != line)
			{
				CStr arg;
				arg.set(temp, line - temp);
				args.add(arg);
			}
		}

		static struct option long_options[] =
		{
			{"files", no_argument, 0L, 1},
			{"admin", no_argument, 0L, 2},
			{"folder", no_argument, 0L, 3},
			{"selection", no_argument, 0L, 4},
			{"name", required_argument, 0L, 5},
			{0, 0, 0, 0}
		};
		bool hasFiles = false;
		bool hasAdmin = false;
		bool hasFolder = false;
		bool hasSel = false;
		CStr dispname;

		optind = 0;
		int option_index = 0, c;
		while ((c = getopt_long
			(args.Argc(), args.Argv(), "+", long_options, &option_index)) != EOF)
		{
			switch (c)
			{
			case 1:
				hasFiles = true;
				break;
			case 2:
				hasAdmin = true;
				break;
			case 3:
				hasFolder = true;
				break;
			case 4:
				hasSel = true;
				break;
			case 5:
				dispname = optarg;
				break;
			default:
				cvs_err("Warning : unknown option in the file '%s'\n", fullname);
				break;
			}
		}

		if(dispname.empty())
		{
			dispname = name;
		}

		if(hasFiles)
		{
			gMacrosFiles.Add(fullname, dispname);
		}
		else if(hasAdmin)
		{
			gMacrosAdmin.Add(fullname, dispname);
		}
		else if(hasFolder)
		{
			gMacrosFolder.Add(fullname, dispname);
		}
		else if(hasSel)
		{
			gMacrosSel.Add(fullname, dispname);
		}
		else
		{
			cvs_err("Warning : no option <files|admin|selection|folder> in the file '%s'\n", fullname);
		}
	}

	free (oldline);

	fclose(fpin);

	return kContinueTraversal;
}

void MacrosReloadAll(void)
{
	MacrosFlushAll();

	// get the macro folder
	CStr path;
#if qDebug && defined(WIN32)
	struct stat sb;
	path = "c:\\cvsgui\\Macros";
	if (stat(path, &sb) != -1 && S_ISDIR(sb.st_mode))
		goto ok;
	path = "d:\\cvsgui\\Macros";
	if (stat(path, &sb) != -1 && S_ISDIR(sb.st_mode))
		goto ok;
	path = "e:\\cvsgui\\Macros";
	if (stat(path, &sb) != -1 && S_ISDIR(sb.st_mode))
		goto ok;
	path = "e:\\cvsgui\\Macros";
	if (stat(path, &sb) != -1 && S_ISDIR(sb.st_mode))
		goto ok;
ok:
#else
	GetMacrosLoc(path);
#endif

	// traverse the macro folder
	MacroTraversal traverse;
	FileTraverse(path, traverse);
}
