/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*
 * PromptFiles.cpp --- class to pick set of files and folder
 */

#include "stdafx.h"

#ifdef macintosh
#	include <string.h>
#	include <TextUtils.h>
#	include <LowMem.h>
#	include "stdfolder.h"
#	include "stdmfiles.h"
#	include "VolsPaths.h"
#endif /* macintosh */

#include "PromptFiles.h"
#include "MultiFiles.h"
#include "AppConsole.h"

#ifdef qQT
#	include "qcvsapp.h"
#	include "CPStr.h"
#	include "TextBinary.h"
#	include <qfiledialog.h>
#	include <vector>
#	include <stdlib.h>
#endif /* qQT */

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef macintosh
	static Boolean
	chdirSystemBrowser(const char *path)
	{
		WDPBRec pb;
		char ppath[512];
		
		strcpy(ppath, path);
		c2pstr(ppath);
		pb.ioNamePtr = (StringPtr) ppath;
		pb.ioCompletion = NULL;
		pb.ioWDVRefNum = 0;
		pb.ioWDDirID = 0;
		if (PBHSetVolSync(&pb) != noErr) return false;
		if (PBHGetVolSync(&pb) != noErr) return false;
		
		LMSetSFSaveDisk(-pb.ioWDVRefNum);
		LMSetCurDirStore(pb.ioWDDirID);
		
		return true;
	}

	const char *
	BrowserGetDirectory(const char *prompt)
	{
		FSSpec folderReply;
		Point apt = {-1, -1};
		Str255 pprompt;
		
		strcpy((char *)pprompt, prompt);
		c2pstr((char *)pprompt);
		if(!SF_PromptForFolder(apt, pprompt, &folderReply))
			return NULL;

		folderReply.parID = SF_GetFSSubDirID(&folderReply);
		
		static Str255 aPath;
		if(PathNameFromDirID(folderReply.parID, folderReply.vRefNum, (char *)aPath) != noErr)
		{
			cvs_err("MacCvs: Unable to convert path name\n");
			return NULL;
		}
		
		/*if(spec != nil)
		{
			*spec = folderReply;
		}*/

		return (char *)aPath;
	}

	// enumerate the multiple files
	extern "C" {
		static void
		MacEnumFiles_hook(FSSpec *newFile, MultiFiles *mf)
		{
			char cname[64];
			memcpy(cname, newFile->name, sizeof(Str63));
			p2cstr((unsigned char *)cname);
			mf->newfile(cname, newFile);
		}
	}

	// prompt for multiple files
	bool
	BrowserGetMultiFiles(const char *prompt, MultiFiles & mf)
	{
		StandardFileReply newFileReply;
		Point apt = {-1, -1};
		Str255 pprompt;
		
		strcpy((char *)pprompt, prompt);
		c2pstr((char *)pprompt);
		
		if(!SF_PromptForMFiles(apt, pprompt))
			return false;
		
		SF_PFMF_INFO info;
		FSSpec dirSpec;
		
		SF_PFMF_BeginTraversal(&info);
		while(1)
		{
			if(!SF_PFMF_GetCurrentDir(&info, &dirSpec))
				break;
			
			char aPath[255];
			if(PathNameFromDirID(dirSpec.parID, dirSpec.vRefNum, (char *)aPath) != noErr)
			{
				cvs_err("MacCvs: Unable to convert path name\n");
				return false;
			}
			mf.newdir(aPath);
			
			if(!SF_PFMF_DoTraversal(&info, true, NULL, (SF_PFMF_HOOK)MacEnumFiles_hook, &mf))
				return false;
		}
		SF_PFMF_EndTraversal(&info);

		return true;
	}
#endif /* macintosh */

#ifdef WIN32
	static char sDefaultPath[MAX_PATH];
	static const char *sPrompt;

	static BOOL CALLBACK APIENTRY
	MyDirOpen(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
	{
		switch (message)
		{
			case WM_INITDIALOG:
				if(sPrompt != NULL)
					SetDlgItemText (hDlg, 1090, sPrompt);
				return TRUE;

			case WM_COMMAND:
				{
					if (LOWORD(wParam) == IDOK)
					{
						EndDialog(hDlg, wParam);
						return TRUE;
					}
				}
		}
		return FALSE;
	}

	const char *
	BrowserGetDirectory(const char *prompt)
	{
		static char fileName[MAX_PATH];
		OPENFILENAME ofn;

		// set default informations
		sPrompt = prompt;
		memset(&ofn, 0, sizeof(OPENFILENAME));
		memset(fileName, 0, sizeof(fileName));
		ofn.lStructSize     = sizeof(OPENFILENAME);
		ofn.hwndOwner       = *AfxGetMainWnd();
		ofn.lpstrFilter     = NULL;
		ofn.nFilterIndex    = 0;
		ofn.lpstrFile       = fileName;
		ofn.nMaxFile        = sizeof(fileName);
		ofn.lpstrFileTitle  = NULL;
		ofn.nMaxFileTitle   = 0;
		ofn.lpstrInitialDir = sDefaultPath[0] != '\0' ? sDefaultPath : NULL;
		ofn.lpstrTitle = prompt;
		ofn.lpTemplateName  = "MYFOLDEROPENORD";
		ofn.hInstance       = AfxGetResourceHandle();
		ofn.lpfnHook        =  (LPOFNHOOKPROC)MyDirOpen;
		ofn.Flags = OFN_ENABLEHOOK | OFN_ENABLETEMPLATE;

		if (GetOpenFileName( &ofn ))
		{
			GetCurrentDirectory( sizeof(fileName), fileName );
			strcpy(sDefaultPath, fileName);
			return fileName;
		}
		else
		{
			// LM
			TRACE("Retrun error of GetOpenFileName() = %0x\n", CommDlgExtendedError());
			// CDERR_DIALOGFAILURE
		}

		return NULL;
	}

	bool BrowserGetMultiFiles(const char *prompt, MultiFiles & mf)
	{
		bool result = false;
		CFileDialog fd(true, NULL, NULL,
			OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_ALLOWMULTISELECT |
			OFN_FILEMUSTEXIST);

		fd.m_ofn.nMaxFile = 38000 * sizeof(char);
		fd.m_ofn.lpstrFile = (char *)malloc(fd.m_ofn.nMaxFile * sizeof(char));
		fd.m_ofn.lpstrTitle = prompt;
		fd.m_ofn.lpstrInitialDir = sDefaultPath[0] != '\0' ? sDefaultPath : NULL;
		fd.m_ofn.nMaxFileTitle   = 38000;
		fd.m_ofn.lpstrFileTitle  = (char *)malloc(fd.m_ofn.nMaxFileTitle * sizeof(char));
		if(fd.m_ofn.lpstrFile == NULL || fd.m_ofn.lpstrFileTitle == NULL)
		{
			cvs_err("Impossible to allocate %d bytes !\n", 38000 * sizeof(char));
			exit(1);
		}

		// add the directory and the files
		fd.m_ofn.lpstrFile[0] = '\0';
		fd.m_ofn.lpstrFileTitle[0] = '\0';
		if(fd.DoModal() == IDOK)
		{
			GetCurrentDirectory(sizeof(sDefaultPath), sDefaultPath);
			const char *tmp = fd.m_ofn.lpstrFile;
			if(fd.m_ofn.lpstrFileTitle[0] == '\0')
			{
				mf.newdir(tmp);
				tmp += strlen(tmp) + 1;
				while(tmp[0] != '\0')
				{
					mf.newfile(tmp);
					tmp += strlen(tmp) + 1;
				}
			}
			else
			{
				mf.newdir(sDefaultPath);
				mf.newfile(tmp + fd.m_ofn.nFileOffset);
			}
			result = true;
		}

		free(fd.m_ofn.lpstrFile);
		free(fd.m_ofn.lpstrFileTitle);
		return result;
	}
#endif /* WIN32 */

#ifdef qQT
	const char *
	BrowserGetDirectory(const char *prompt)
	{
		QFileDialog::Mode mode = QFileDialog::Directory;
		CStr start(QDir::currentDirPath());
		CStr filter("*");
		CStr caption(prompt);

		QFileDialog fd( 0, filter, 0, 0, TRUE );
		fd.setMode(mode);
		fd.setCaption(caption);
		fd.setSelection(start);
		if (fd.exec() == QDialog::Accepted)
		{
			static CStr result;
			result = fd.dirPath();
			return result;
		}
		return 0L;
	}

	extern "C"
	{
		static int compareCStr(const CStr *s1, const CStr *s2)
		{
			return strcmp(*s1, *s2);
		}
	}

	bool
	BrowserGetMultiFiles(const char *prompt, MultiFiles & mf)
	{
		QStrList s(QFileDialog::getOpenFileNames());
		vector <CStr> allpaths;
		for (const char* f = s.first(); f; f = s.next())
		{
			allpaths.push_back(CStr(f));
		}
		if(allpaths.size() == 0)
			return false;

		qsort(&allpaths[0], allpaths.size(), sizeof(CStr), (int (*)(const void *, const void *))compareCStr);

		vector<CStr>::const_iterator i;
		CStr uppath, file, oldpath;
		for(i = allpaths.begin(); i != allpaths.end(); ++i)
		{
			SplitPath(*i, uppath, file);
			if(strcmp(uppath, oldpath) != 0)
				mf.newdir(uppath);
			oldpath = uppath;
			mf.newfile(file);
		}
		return true;
	}
#endif /* qQT */
