/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- May 1998
 */

/*
 * TclGlue.cpp --- glue to the TCL language
 */

#include "stdafx.h"

#ifdef macintosh
#	include <GUSI.h>
#	include "MacMisc.h"
#endif

#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include "tcl.h"
#include "TclGlue.h"
#include "AppConsole.h"
#include "AppGlue.h"
#include "CvsArgs.h"
#include "CvsEntries.h"
#include "dll_loader.h"
#include "FileTraversal.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifndef macintosh
#	define DEC_GLUE(f) (*f##_glue)

	Tcl_Command	DEC_GLUE(Tcl_CreateCommand)
		_ANSI_ARGS_((Tcl_Interp *interp, char *cmdName, Tcl_CmdProc *proc,
			ClientData clientData, Tcl_CmdDeleteProc *deleteProc));
	Tcl_Interp * DEC_GLUE(Tcl_CreateInterp) _ANSI_ARGS_((void));
	void DEC_GLUE(Tcl_AppendResult) _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp));
	void DEC_GLUE(Tcl_SetResult) _ANSI_ARGS_((Tcl_Interp *interp, char *string, Tcl_FreeProc *freeProc));
	void DEC_GLUE(Tcl_DeleteInterp) _ANSI_ARGS_((Tcl_Interp *interp));
	int DEC_GLUE(Tcl_Eval) _ANSI_ARGS_((Tcl_Interp *interp, char *string));
	int DEC_GLUE(Tcl_EvalFile) _ANSI_ARGS_((Tcl_Interp *interp, char *fileName));
	char *		DEC_GLUE(Tcl_Alloc) _ANSI_ARGS_((unsigned int size));
	void		DEC_GLUE(Tcl_Free) _ANSI_ARGS_((char *ptr));
	char *		DEC_GLUE(Tcl_Realloc) _ANSI_ARGS_((char *ptr,
					unsigned int size));
	int		DEC_GLUE(Tcl_ExprLong) _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, long *ptr));
	char *		DEC_GLUE(Tcl_Concat) _ANSI_ARGS_((int argc, char **argv));
	char *		DEC_GLUE(Tcl_SetVar2) _ANSI_ARGS_((Tcl_Interp *interp,
			    char *part1, char *part2, char *newValue,
			    int flags));
	void		DEC_GLUE(Tcl_DStringStartSublist) _ANSI_ARGS_((
			    Tcl_DString *dsPtr));
	void		DEC_GLUE(Tcl_DStringEndSublist) _ANSI_ARGS_((Tcl_DString *dsPtr));
	void		DEC_GLUE(Tcl_DStringFree) _ANSI_ARGS_((Tcl_DString *dsPtr));
	void		DEC_GLUE(Tcl_DStringInit) _ANSI_ARGS_((Tcl_DString *dsPtr));
	void		DEC_GLUE(Tcl_DStringResult) _ANSI_ARGS_((Tcl_Interp *interp,
			    Tcl_DString *dsPtr));
	char *		DEC_GLUE(Tcl_DStringAppendElement) _ANSI_ARGS_((
			    Tcl_DString *dsPtr, CONST char *string));
	void		DEC_GLUE(TclFreeObj) _ANSI_ARGS_((Tcl_Obj *objPtr));
	void		DEC_GLUE(Tcl_SetObjResult) _ANSI_ARGS_((Tcl_Interp *interp,
			    Tcl_Obj *resultObjPtr));
	Tcl_Obj *	DEC_GLUE(Tcl_NewStringObj) _ANSI_ARGS_((CONST char *bytes,
			    int length));
	Tcl_Obj *	DEC_GLUE(Tcl_NewListObj) _ANSI_ARGS_((int objc,
			    Tcl_Obj *CONST objv[]));
	int		DEC_GLUE(Tcl_ListObjAppendElement) _ANSI_ARGS_((
			    Tcl_Interp *interp, Tcl_Obj *listPtr,
			    Tcl_Obj *objPtr));


#	define GLUE_WRAP(f) f##_glue
#	define Tcl_CreateCommand GLUE_WRAP(Tcl_CreateCommand)
#	define Tcl_CreateInterp GLUE_WRAP(Tcl_CreateInterp)
#	define Tcl_AppendResult GLUE_WRAP(Tcl_AppendResult)
#	define Tcl_SetResult GLUE_WRAP(Tcl_SetResult)
#	define Tcl_DeleteInterp GLUE_WRAP(Tcl_DeleteInterp)
#	define Tcl_Eval GLUE_WRAP(Tcl_Eval)
#	define Tcl_EvalFile GLUE_WRAP(Tcl_EvalFile)
#	define Tcl_Alloc GLUE_WRAP(Tcl_Alloc)
#	define Tcl_Free GLUE_WRAP(Tcl_Free)
#	define Tcl_Realloc GLUE_WRAP(Tcl_Realloc)
#	define Tcl_ExprLong GLUE_WRAP(Tcl_ExprLong)
#	define Tcl_Concat GLUE_WRAP(Tcl_Concat)
#	define Tcl_SetVar2 GLUE_WRAP(Tcl_SetVar2)
#	define Tcl_DStringStartSublist GLUE_WRAP(Tcl_DStringStartSublist)
#	define Tcl_DStringEndSublist GLUE_WRAP(Tcl_DStringEndSublist)
#	define Tcl_DStringFree GLUE_WRAP(Tcl_DStringFree)
#	define Tcl_DStringInit GLUE_WRAP(Tcl_DStringInit)
#	define Tcl_DStringResult GLUE_WRAP(Tcl_DStringResult)
#	define Tcl_DStringAppendElement GLUE_WRAP(Tcl_DStringAppendElement)
#	define TclFreeObj GLUE_WRAP(TclFreeObj)
#	define Tcl_SetObjResult GLUE_WRAP(Tcl_SetObjResult)
#	define Tcl_NewStringObj GLUE_WRAP(Tcl_NewStringObj)
#	define Tcl_NewListObj GLUE_WRAP(Tcl_NewListObj)
#	define Tcl_ListObjAppendElement GLUE_WRAP(Tcl_ListObjAppendElement)
#endif /* !macintosh */

extern "C"
{
	static int tclCvsProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
	static int tclHelpProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
	static int tclCvsOutProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
	static int tclCvsErrProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
	static int tclCvsBrowserProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
	static int tclCvsEntriesProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
	static void tclCvsEntriesDeleteProc(ClientData clientData);
	static int tclCvsSelProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
#ifdef WIN32
	static int tclDirProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
#endif /* WIN32 */
}

// the tcl browser class entity
class CTCLBrowserEnt
{
public:
	CTCLBrowserEnt();
	CTCLBrowserEnt(const char *path, EntnodeData *data);
	CTCLBrowserEnt(const CTCLBrowserEnt & ent);
	~CTCLBrowserEnt();

	CTCLBrowserEnt & operator=(const CTCLBrowserEnt & ent);
	bool operator<(const CTCLBrowserEnt & ent) const;
	bool operator==(const CTCLBrowserEnt & ent) const;
	bool operator==(const char * unixpath) const;

	CStr fPath;
	EntnodeData *fData;
};

#ifdef __MWERKS__
	SPECIALIZE_ITERATOR_TRAIT(CTCLBrowserEnt)
#endif

static vector<CTCLBrowserEnt> sTclBrowser;
static vector<CStr> sTclSel;

class CTCLCvsConsole : public CCvsConsole
{
public:
	CTCLCvsConsole(Tcl_Interp *interp) : fInterp(interp)
	{
		fLen = 100;
		fAlloc = (char *)malloc((fLen + 1) * sizeof(char));
	}
	virtual ~CTCLCvsConsole()
	{
		if(fAlloc != 0L)
			free(fAlloc);
	}
	
	virtual long cvs_out(char *txt, long len)
	{
		if(fAlloc == 0L)
			return 0;
		
		if(len > fLen)
		{
			fLen = len;
			fAlloc = (char *)realloc(fAlloc, (fLen + 1) * sizeof(char));
		}
		if(fAlloc == 0L)
			return 0;

		memcpy(fAlloc, txt, len * sizeof(char));
		fAlloc[len] = '\0';
		
		::Tcl_AppendResult(fInterp, fAlloc, 0L);
		return len;
	}
	
	virtual long cvs_err(char *txt, long len)
	{
		return cvs_out(txt, len);
	}
protected:
	Tcl_Interp *fInterp;
	int fLen;
	char *fAlloc;
};

#ifdef _MSC_VER
extern "C"
#endif
static int tclCvsProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	CvsArgs args;
	
	for(int i = 1; i < argc; i++)
	{
		args.add(argv[i]);
	}

	CTCLCvsConsole console(interp);
	int exitc = launchCVS(0L, args.Argc(), args.Argv(), &console);

	return exitc == 0 ? TCL_OK : TCL_ERROR;
}

#ifdef _MSC_VER
extern "C"
#endif
static int tclHelpProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	::Tcl_AppendResult(interp, "Help :\n", 0L);
	::Tcl_AppendResult(interp, "   cvs  : the cvs tool.\n", 0L);
	::Tcl_AppendResult(interp, "   help : this help.\n", 0L);
	::Tcl_AppendResult(interp, "Others commands :\n", 0L);
	::Tcl_AppendResult(interp, "   cd   : change directory\n", 0L);
	::Tcl_AppendResult(interp, "   pwd  : print current directory\n", 0L);
	::Tcl_AppendResult(interp, "   ls   : list the current directory\n", 0L);
	::Tcl_AppendResult(interp, "   info ?  : misc. informations\n", 0L);
	::Tcl_AppendResult(interp, "   info commands : all the TCL commands\n", 0L);
	return TCL_OK;
}

#ifdef _MSC_VER
extern "C"
#endif
static int tclCvsOutProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	for(int i = 1; i < argc; i++)
	{
		cvs_outstr(argv[i], strlen(argv[i]));
	}
	return TCL_OK;
}

#ifdef _MSC_VER
extern "C"
#endif
static int tclCvsErrProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	for(int i = 1; i < argc; i++)
	{
		cvs_errstr(argv[i], strlen(argv[i]));
	}
	return TCL_OK;
}

#ifdef _MSC_VER
extern "C"
#endif
static int tclCvsBrowserProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	if(argc < 2)
	{
		::Tcl_AppendResult(interp, argv[0], " : Missing arguments\n", 0L);
		return TCL_ERROR;
	}

	vector<CTCLBrowserEnt> & browser = clientData != 0L ?
		*(vector<CTCLBrowserEnt> *)clientData : sTclBrowser;
	if(strcmp(argv[1], "get") == 0)
	{
		if(argc != 2)
		{
			char *str = ::Tcl_Concat(argc, argv);
			::Tcl_AppendResult(interp, argv[0], " : Too much arguments : '", str, "'\n", 0L);
			Tcl_Free(str);
			return TCL_ERROR;
		}

		Tcl_Obj *list = ::Tcl_NewListObj(0, 0L);
		vector<CTCLBrowserEnt>::const_iterator i;
		for(i = browser.begin(); i != browser.end(); ++i)
		{
			CStr path = (*i).fPath;
			CTcl_Interp::Unixfy(path);
			path << kTCLPathDelimiter;
			path << (*(*i).fData)[EntnodeData::kName];

			Tcl_Obj * obj = ::Tcl_NewStringObj(path, path.length());
			::Tcl_ListObjAppendElement(interp, list, obj);
			//::TclFreeObj(obj);
		}
		::Tcl_SetObjResult(interp, list);
		//::TclFreeObj(list);
	}
	else if(strcmp(argv[1], "info") == 0)
	{
		if(argc != 4)
		{
			char *str = ::Tcl_Concat(argc, argv);
			::Tcl_AppendResult(interp, argv[0], " : Too much arguments : '", str, "'\n", 0L);
			Tcl_Free(str);
			return TCL_ERROR;
		}

		vector<CTCLBrowserEnt>::const_iterator i;
		for(i = browser.begin(); i != browser.end(); ++i)
		{
			if((*i) == argv[2])
			{
				CStr value = (*(*i).fData)[EntnodeData::kName];
				char *res = ::Tcl_SetVar2(interp, argv[3], "name", value, 0);
				if(res == 0L)
					goto err1;

				value = (*i).fData->GetType() == ENT_FILE ? "file" : "folder";
				res = ::Tcl_SetVar2(interp, argv[3], "kind", value, 0);
				if(res == 0L)
					goto err1;

				value = (*i).fPath;
				CTcl_Interp::Unixfy(value);
				res = ::Tcl_SetVar2(interp, argv[3], "path", value, 0);
				if(res == 0L)
					goto err1;

				value = (*(*i).fData)[EntnodeData::kStatus];
				res = ::Tcl_SetVar2(interp, argv[3], "status", value, 0);
				if(res == 0L)
					goto err1;

				value = ((*i).fData)->IsMissing() ? "1" : "0";
				res = ::Tcl_SetVar2(interp, argv[3], "missing", value, 0);
				if(res == 0L)
					goto err1;

				value = ((*i).fData)->IsUnknown() ? "1" : "0";
				res = ::Tcl_SetVar2(interp, argv[3], "unknown", value, 0);
				if(res == 0L)
					goto err1;

				value = ((*i).fData)->IsIgnored() ? "1" : "0";
				res = ::Tcl_SetVar2(interp, argv[3], "ignored", value, 0);
				if(res == 0L)
					goto err1;

				value = ((*i).fData)->IsLocked() ? "1" : "0";
				res = ::Tcl_SetVar2(interp, argv[3], "locked", value, 0);
				if(res == 0L)
					goto err1;

				value = ((*i).fData)->IsUnmodified() ? "0" : "1";
				res = ::Tcl_SetVar2(interp, argv[3], "modified", value, 0);
				if(res == 0L)
					goto err1;

				value = ((*i).fData)->GetDesc();
				res = ::Tcl_SetVar2(interp, argv[3], "status", value, 0);
				if(res == 0L)
					goto err1;

				if((*i).fData->GetType() == ENT_FILE)
				{
					value = (*(*i).fData)[EntnodeFile::kVN];
					res = ::Tcl_SetVar2(interp, argv[3], "revision", value, 0);
					if(res == 0L)
						goto err1;

					value = (*(*i).fData)[EntnodeFile::kTS];
					res = ::Tcl_SetVar2(interp, argv[3], "timestamp", value, 0);
					if(res == 0L)
						goto err1;

					value = (*(*i).fData)[EntnodeFile::kOption];
					res = ::Tcl_SetVar2(interp, argv[3], "option", value, 0);
					if(res == 0L)
						goto err1;

					value = (*(*i).fData)[EntnodeFile::kTag];
					res = ::Tcl_SetVar2(interp, argv[3], "tag", value, 0);
					if(res == 0L)
						goto err1;

					value = (*(*i).fData)[EntnodeFile::kConflict];
					res = ::Tcl_SetVar2(interp, argv[3], "conflict", value, 0);
					if(res == 0L)
						goto err1;
				}

				goto ok1;
err1:
				::Tcl_AppendResult(interp, argv[0], " : Error while creating '", argv[3], "'\n", 0L);
				return TCL_ERROR;
ok1:			
				break;
			}
		}
	}
	else
	{
		char *str = ::Tcl_Concat(argc, argv);
		::Tcl_AppendResult(interp, argv[0], " : Wrong arguments : '", str, "'\n", 0L);
		Tcl_Free(str);
		return TCL_ERROR;
	}
	return TCL_OK;
}

class CFillTclEntries : public TraversalReport
{
public:
	CSortList<ENTNODE> & m_entries;
	vector<CStr> m_ignlist;

	CFillTclEntries(CSortList<ENTNODE> & entries) :
		m_entries(entries) {}

	virtual ~CFillTclEntries() {}

	virtual kTraversal EnterDirectory(const char *fullpath, const char *dirname)
	{
		if(chdir("CVS") == 0)
		{
			Entries_Open (m_entries, fullpath);
			if(chdir(fullpath) != 0)
				return kTraversalError;
			BuildIgnoredList(m_ignlist);
		}
		return kContinueTraversal;
	}

	virtual kTraversal ExitDirectory(const char *fullpath)
	{
		m_ignlist.erase(m_ignlist.begin(), m_ignlist.end());
		return kContinueTraversal;
	}

	virtual kTraversal OnError(const char *err, int errcode)
	{
		return kTraversalError;
	}

	virtual kTraversal OnIdle(const char *fullpath)
	{
		return kContinueTraversal;
	}

	virtual kTraversal OnDirectory(const char *fullpath,
		const char *fullname,
		const char *name,
		const struct stat & dir, FSSpec * macspec)
	{
#if defined(WIN32) || defined(macintosh)
		if(stricmp(name, "CVS") == 0)
#else
		if(strcmp(name, "CVS") == 0)
#endif
			return kSkipFile;

		/*EntnodeData *data = */Entries_SetVisited(m_entries, name, dir, true, &m_ignlist);

		return kSkipFile;
	}

	virtual kTraversal OnAlias(const char *fullpath,
		const char *fullname,
		const char *name,
		const struct stat & dir, FSSpec * macspec)
	{
		return OnFile(fullpath, fullname, name, dir, macspec);
	}

	virtual kTraversal OnFile(const char *fullpath,
		const char *fullname,
		const char *name,
		const struct stat & dir, FSSpec * macspec)
	{
		/*EntnodeData *data = */Entries_SetVisited(m_entries, name, dir, false, &m_ignlist);

		return kContinueTraversal;
	}
};


#ifdef _MSC_VER
extern "C"
#endif
static void tclCvsEntriesDeleteProc(ClientData clientData)
{
	if(clientData != 0L)
		delete (vector<CTCLBrowserEnt> *)clientData;
}

#ifdef _MSC_VER
extern "C"
#endif
static int tclCvsEntriesProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	if(argc != 3)
	{
		::Tcl_AppendResult(interp, argv[0], " : Wrong # of arguments\n", 0L);
		return TCL_ERROR;
	}

	CSortList<ENTNODE> entries(200, ENTNODE::Compare);

	// refetch all items
	CFillTclEntries traverse(entries);
	CStr path(argv[1]);
	CTcl_Interp::Deunixfy(path);
	/*kTraversal res = */FileTraverse(path, traverse);

	// add the missing files
	Entries_SetMissing(entries);

	// now make the TCL entries
	vector<CTCLBrowserEnt> *browser = new vector<CTCLBrowserEnt>;
	
	int numEntries = entries.NumOfElements();
	for(int i = 0; i < numEntries; i++)
	{
		const ENTNODE & theNode = entries.Get(i);
		EntnodeData *data = ((ENTNODE *)&theNode)->Data();
		browser->push_back(CTCLBrowserEnt(path, data));
	}

	Tcl_Command cmd = ::Tcl_CreateCommand (interp, argv[2], tclCvsBrowserProc,
		(ClientData)browser, tclCvsEntriesDeleteProc);
	
	return cmd != 0L ? TCL_OK : TCL_ERROR;
}

#ifdef _MSC_VER
extern "C"
#endif
static int tclCvsSelProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	if(argc != 1)
	{
		char *str = ::Tcl_Concat(argc, argv);
		::Tcl_AppendResult(interp, argv[0], " : Syntax error : '", str, "'\n", 0L);
		return TCL_ERROR;
	}

	Tcl_Obj *list = ::Tcl_NewListObj(0, 0L);
	vector<CStr>::const_iterator i;
	for(i = sTclSel.begin(); i != sTclSel.end(); ++i)
	{
		CStr path = (*i);
		Tcl_Obj * obj = ::Tcl_NewStringObj(path, path.length());
		::Tcl_ListObjAppendElement(interp, list, obj);
		//::TclFreeObj(obj);
	}
	::Tcl_SetObjResult(interp, list);
	//::TclFreeObj(list);
	return TCL_OK;
}

#ifdef WIN32
class LSReport : public TraversalReport
{
public:
	Tcl_Interp *fInterp;
	int fState;

	LSReport(Tcl_Interp *interp) : fInterp(interp), fState(TCL_OK) {}

	virtual kTraversal EnterDirectory(const char *fullpath, const char *dirname)
	{
		return kContinueTraversal;
	}

	virtual kTraversal ExitDirectory(const char *fullpath)
	{
		return kContinueTraversal;
	}

	virtual kTraversal OnError(const char *err, int errcode)
	{
		fState = TCL_ERROR;
		::Tcl_AppendResult(fInterp, err, "\n", 0L);
		return kTraversalError;
	}

	virtual kTraversal OnIdle(const char *fullpath)
	{
		return kContinueTraversal;
	}

	virtual kTraversal OnAnyDevice(const char *fullpath,
		const char *fullname,
		const char *name,
		const struct stat & dir, FSSpec * macspec)
	{
		::Tcl_AppendResult(fInterp, name, "\n", 0L);
		return kSkipFile;
	}
};

#ifdef _MSC_VER
extern "C"
#endif
static int tclDirProc (ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	LSReport report(interp);
	char path[256];
	getcwd(path, 256);
	kTraversal res = FileTraverse(path, report);
	return report.fState;
}
#endif /* WIN32 */

CTcl_Interp::CTcl_Interp()
{
	fInterp = 0L;
	
	if(!CTcl_Interp::IsAvail())
	{
		cvs_err("TCL is not avalaible !\n");
		return;
	}
	
	fInterp = ::Tcl_CreateInterp();
	if(fInterp == 0L)
	{
		cvs_err("Unable to create a new TCL interpreter !\n");
		return;
	}

	Tcl_Command cmd;
	
	cmd = ::Tcl_CreateCommand (fInterp, "cvs", tclCvsProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
	cmd = ::Tcl_CreateCommand (fInterp, "help", tclHelpProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
	cmd = ::Tcl_CreateCommand (fInterp, "cvsout", tclCvsOutProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
	cmd = ::Tcl_CreateCommand (fInterp, "cvserr", tclCvsErrProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
	cmd = ::Tcl_CreateCommand (fInterp, "cvsbrowser", tclCvsBrowserProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
	cmd = ::Tcl_CreateCommand (fInterp, "cvsentries", tclCvsEntriesProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
	cmd = ::Tcl_CreateCommand (fInterp, "cvssel", tclCvsSelProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
#ifdef WIN32
	cmd = ::Tcl_CreateCommand (fInterp, "ls", tclDirProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
	cmd = ::Tcl_CreateCommand (fInterp, "dir", tclDirProc,
		(ClientData)0L, (Tcl_CmdDeleteProc *)0L);
#endif /* WIN32 */
}

CTcl_Interp::~CTcl_Interp()
{
	if(fInterp != 0L)
		::Tcl_DeleteInterp(fInterp);
}

bool CTcl_Interp::IsAvail(void)
{
#ifdef macintosh
	return ::Tcl_CreateInterp != 0L;
#else /* !macintosh */
	static bool firstTime = true;
	static bool tclAvail = false;
	static CompatConnectID connID;
	if(firstTime)
	{
#	ifdef WIN32
		tclAvail = CompatLoadLibrary(&connID, "tcl80.dll") != 0 ||
			CompatLoadLibrary(&connID, "tcl81.dll") != 0;
#	else /* !WIN32 */
		tclAvail = CompatLoadLibrary(&connID, "libtcl8.0.so") != 0 ||
			CompatLoadLibrary(&connID, "libtcl8.1.so") != 0;
#	endif /* !WIN32 */
#	define LOAD_CODEFRAG(name) \
		if(tclAvail) \
			tclAvail = (*(void **)&name##_glue = \
				_CompatCallLibrary(connID, #name)) != 0L

		LOAD_CODEFRAG(Tcl_CreateCommand);
		LOAD_CODEFRAG(Tcl_CreateInterp);
		LOAD_CODEFRAG(Tcl_AppendResult);
		LOAD_CODEFRAG(Tcl_SetResult);
		LOAD_CODEFRAG(Tcl_DeleteInterp);
		LOAD_CODEFRAG(Tcl_Eval);
		LOAD_CODEFRAG(Tcl_EvalFile);
		LOAD_CODEFRAG(Tcl_Alloc);
		LOAD_CODEFRAG(Tcl_Free);
		LOAD_CODEFRAG(Tcl_Realloc);
		LOAD_CODEFRAG(Tcl_ExprLong);
		LOAD_CODEFRAG(Tcl_Concat);
		LOAD_CODEFRAG(Tcl_SetVar2);
		LOAD_CODEFRAG(Tcl_DStringStartSublist);
		LOAD_CODEFRAG(Tcl_DStringEndSublist);
		LOAD_CODEFRAG(Tcl_DStringFree);
		LOAD_CODEFRAG(Tcl_DStringInit);
		LOAD_CODEFRAG(Tcl_DStringResult);
		LOAD_CODEFRAG(Tcl_DStringAppendElement);
		LOAD_CODEFRAG(TclFreeObj);
		LOAD_CODEFRAG(Tcl_SetObjResult);
		LOAD_CODEFRAG(Tcl_NewStringObj);
		LOAD_CODEFRAG(Tcl_NewListObj);
		LOAD_CODEFRAG(Tcl_ListObjAppendElement);
	}
	firstTime = false;

	return tclAvail;
#endif /* !macintosh */
}

kTclRes CTcl_Interp::DoScript(const char *script)
{
	if(fInterp == 0L)
		return false;
	
	int exitc = ::Tcl_Eval(fInterp, (char *)script);
	size_t len = strlen(fInterp->result);
	if(exitc == TCL_ERROR)
	{
		cvs_errstr(fInterp->result, len);
		if(len != 0 && fInterp->result[len - 1] != '\n')
			cvs_errstr("\n", 1);
	}
	else
	{
		cvs_outstr(fInterp->result, len);
		if(len != 0 && fInterp->result[len - 1] != '\n')
			cvs_outstr("\n", 1);
	}
	
	return exitc;
}

kTclRes CTcl_Interp::DoScriptVar(const char *format, ...)
{
	if(fInterp == 0L)
		return false;
	
	va_list args;
	char script[1024] = {'\0'};

	va_start (args, format);
	vsprintf (script, format, args);
	va_end (args);
	
	return DoScript(script);
}

kTclRes CTcl_Interp::DoFile(const char *file)
{
	if(fInterp == 0L)
		return false;
	
	int exitc = ::Tcl_EvalFile(fInterp, (char *)file);
	size_t len = strlen(fInterp->result);
	if(exitc == TCL_ERROR)
	{
		cvs_errstr(fInterp->result, len);
		if(len != 0 && fInterp->result[len - 1] != '\n')
			cvs_errstr("\n", 1);
	}
	else
	{
		cvs_outstr(fInterp->result, len);
		if(len != 0 && fInterp->result[len - 1] != '\n')
			cvs_outstr("\n", 1);
	}
	
	return exitc;
}

void CTcl_Interp::Unixfy(CStr & path)
{
	char *ptr = path;
	while((ptr = strchr(ptr, kPathDelimiter)) != 0L)
	{
		*ptr++ = kTCLPathDelimiter;
	}
	ptr = &path[path.length() - 1];
	if(*ptr == kTCLPathDelimiter)
	{
		*ptr = '\0';
	}
}

void CTcl_Interp::Deunixfy(CStr & path)
{
	char *ptr = path;
	while((ptr = strchr(ptr, kTCLPathDelimiter)) != 0L)
	{
		*ptr++ = kPathDelimiter;
	}
}

CTCLBrowserEnt::CTCLBrowserEnt() : fData(0L)
{
}

CTCLBrowserEnt::CTCLBrowserEnt(const char *path, EntnodeData *data) : fPath(path)
{
	fData = data->Ref();
}

CTCLBrowserEnt::CTCLBrowserEnt(const CTCLBrowserEnt & ent) : fData(0L)
{
	*this = ent;
}

CTCLBrowserEnt::~CTCLBrowserEnt()
{
	if(fData != 0L)
		fData->UnRef();
}

CTCLBrowserEnt & CTCLBrowserEnt::operator=(const CTCLBrowserEnt & ent)
{
	if(fData != 0L)
	{
		fData->UnRef();
		fData = 0L;
	}
	fData = ent.fData != 0L ? ent.fData->Ref() : 0L;
	fPath = ent.fPath;
	return *this;
}

bool CTCLBrowserEnt::operator==(const char *pathstr) const
{
	CStr path = pathstr;
	CTcl_Interp::Deunixfy(path);

	CStr file = fPath;
	if(!file.endsWith(kPathDelimiter))
		file << kPathDelimiter;
	file << (*fData)[EntnodeData::kName];

	return path.compare(file) == 0;
}

void TclBrowserReset(void)
{
	sTclBrowser.erase(sTclBrowser.begin(), sTclBrowser.end());
}

void TclBrowserAppend(const char *path, EntnodeData *data)
{
	sTclBrowser.push_back(CTCLBrowserEnt(path, data));
}

void TclSelReset(void)
{
	sTclSel.erase(sTclSel.begin(), sTclSel.end());
}

void TclSelAppend(const char *apath, const char *afile)
{
	CStr path = apath;
	CTcl_Interp::Unixfy(path);
	path << kTCLPathDelimiter;
	path << afile;
	sTclSel.push_back(path);
}

void TclSelAppend(const char *apath)
{
	CStr path = apath;
	CTcl_Interp::Unixfy(path);
	sTclSel.push_back(path);
}
