/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- March 1998
 */

/*
 * UpdateDlg.cpp : the cvs update dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#	include "QUpdateTab.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LCheckBox.h>
#	include <LEditText.h>
#	include <LPopupGroupBox.h>
#	include <LRadioButton.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "UpdateDlg.h"
#include "CvsPrefs.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

char *sDefTagNames[] = 
{
	"1.1",
	"1.6.2.4",
	"HEAD",
	"branch-release-1-0",
	0L
};

char *sDefDateNames[] = 
{
	"1998-3",
	"1998-3-24",
	"1998-3-24 20:55",
	"24 Mar",
	"24 Mar 1998",
	"<=1998-3-24",
	0L
};

CMString gRevNames(10, "P_TagNames", sDefTagNames);
CMString gDateNames(10, "P_DateNames", sDefDateNames);

#ifdef WIN32
#include "GetPrefs.h"

IMPLEMENT_DYNCREATE(CUpdateMain, CPropertyPage)

CUpdateMain::CUpdateMain() : CPropertyPage(CUpdateMain::IDD)
{
	//{{AFX_DATA_INIT(CUpdateMain)
	m_delsticky = FALSE;
	m_norecurs = FALSE;
	m_stdout = FALSE;
	m_createmissdir = FALSE;
	//}}AFX_DATA_INIT
}

CUpdateMain::~CUpdateMain()
{
}

void CUpdateMain::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUpdateMain)
	DDX_Check(pDX, IDC_DELSTICKY, m_delsticky);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Check(pDX, IDC_STDOUT, m_stdout);
	DDX_Check(pDX, IDC_CREATEMISSDIR, m_createmissdir);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUpdateMain, CPropertyPage)
	//{{AFX_MSG_MAP(CUpdateMain)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

IMPLEMENT_DYNCREATE(CUpdateSticky, CPropertyPage)

CUpdateSticky::CUpdateSticky(const char *rev, const char *date) : CPropertyPage(CUpdateSticky::IDD)
{
	//{{AFX_DATA_INIT(CUpdateSticky)
	m_date = date;
	m_rev = rev;
	m_hasdate = FALSE;
	m_hasrev = FALSE;
	m_match = FALSE;
	//}}AFX_DATA_INIT
}

CUpdateSticky::CUpdateSticky() : CPropertyPage(CUpdateSticky::IDD)
{
}

CUpdateSticky::~CUpdateSticky()
{
}

void CUpdateSticky::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUpdateSticky)
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	DDX_Check(pDX, IDC_MATCH, m_match);
	//}}AFX_DATA_MAP
	if(m_hasrev)
		DDV_MinChars(pDX, m_rev, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDate();
		OnRev();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gDateNames, m_datedef);
}

BEGIN_MESSAGE_MAP(CUpdateSticky, CPropertyPage)
	//{{AFX_MSG_MAP(CUpdateSticky)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CUpdateSticky::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CUpdateSticky::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}

IMPLEMENT_DYNCREATE(CUpdateMerge, CPropertyPage)

CUpdateMerge::CUpdateMerge(const char *rev1, const char *rev2) : CPropertyPage(CUpdateMerge::IDD)
{
	//{{AFX_DATA_INIT(CUpdateMerge)
	m_rev1 = rev1;
	m_rev2 = rev2;
	m_merge = 0;
	//}}AFX_DATA_INIT
}

CUpdateMerge::CUpdateMerge() : CPropertyPage(CUpdateMerge::IDD)
{
}

CUpdateMerge::~CUpdateMerge()
{
}

void CUpdateMerge::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUpdateMerge)
	DDX_Control(pDX, IDC_COMBOREV2, m_comborevdef2);
	DDX_Control(pDX, IDC_COMBOREV, m_comborevdef);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev1);
	DDX_CBString(pDX, IDC_COMBOREV2, m_rev2);
	DDX_Radio(pDX, IDC_MERGE, m_merge);
	//}}AFX_DATA_MAP
	if(m_merge == 1 || m_merge == 2)
		DDV_MinChars(pDX, m_rev1, 1);
	if(m_merge == 2)
		DDV_MinChars(pDX, m_rev2, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnMerge();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_comborevdef);
	DDX_ComboMString(pDX, IDC_COMBOREV2, gRevNames, m_comborevdef2);
}

void CUpdateMerge::OnMerge() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_MERGE);
	CButton* but1 = (CButton *)GetDlgItem(IDC_MERGE1);
	CButton* but2 = (CButton *)GetDlgItem(IDC_MERGE2);
	CWnd* wnd1 = GetDlgItem(IDC_COMBOREV);
	CWnd* wnd2 = GetDlgItem(IDC_COMBOREV2);
	if(but->GetCheck() == 1)
	{
		wnd1->EnableWindow(FALSE);
		wnd2->EnableWindow(FALSE);
	}
	else if(but1->GetCheck() == 1)
	{
		wnd1->EnableWindow(TRUE);
		wnd2->EnableWindow(FALSE);
	}
	else
	{
		wnd1->EnableWindow(TRUE);
		wnd2->EnableWindow(TRUE);
	}
}

void CUpdateMerge::OnMerge1() 
{
	OnMerge();
}

void CUpdateMerge::OnMerge2() 
{
	OnMerge();
}

BEGIN_MESSAGE_MAP(CUpdateMerge, CPropertyPage)
	//{{AFX_MSG_MAP(CUpdateMerge)
	ON_BN_CLICKED(IDC_MERGE, OnMerge)
	ON_BN_CLICKED(IDC_MERGE1, OnMerge1)
	ON_BN_CLICKED(IDC_MERGE2, OnMerge2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_UpdateMerge(LWindow *theDialog, bool & merge1, bool & merge2,
	CPStr & sLastRev1, CPStr & sLastRev2, bool putValue)
{
	LRadioGroupView *groupButtons = dynamic_cast<LRadioGroupView*>
		(theDialog->FindPaneByID(item_GroupAuthen));

	LRadioButton *chkHasRev = dynamic_cast<LRadioButton*>
		(theDialog->FindPaneByID(item_CheckRevTag1));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag1));
	LRadioButton *chkHasRev2 = dynamic_cast<LRadioButton*>
		(theDialog->FindPaneByID(item_CheckRevTag2));
	LEditText *editRev2 = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag2));
	LPopupFiller *fill1 = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LPopupFiller *fill2 = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev2));
	
	fill1->DoDataExchange(gRevNames, putValue);
	fill2->DoDataExchange(gRevNames, putValue);
	
	if(putValue)
	{
		if(merge1 && merge2)
			groupButtons->SetCurrentRadioID(item_CheckRevTag2);
		else if(merge1)
			groupButtons->SetCurrentRadioID(item_CheckRevTag1);
		else
			groupButtons->SetCurrentRadioID(item_MergeNone);
		editRev->SetText((Ptr)(const char *)sLastRev1, sLastRev1.length());
		editRev2->SetText((Ptr)(const char *)sLastRev2, sLastRev2.length());
	}
	else
	{
		PaneIDT paneID = groupButtons->GetCurrentRadioID();
		if(paneID == item_CheckRevTag2)
		{
			merge1 = merge2 = true;
		}
		else if (paneID == item_CheckRevTag1)
		{
			merge1 = true;
			merge2 = false;
		}
		else
		{
			merge1 = merge2 = false;
		}

		char str[255];
		Size len;
		
		editRev->GetText(str, 254, &len);
		sLastRev1.set(str, len);
		editRev2->GetText(str, 254, &len);
		sLastRev2.set(str, len);
	}
}

static void DoDataExchange_UpdateSticky(LWindow *theDialog, bool & hasDate, bool & hasRev,
	CPStr & sLastDate, CPStr & sLastRev, bool & useMostRecent, bool putValue)
{
	LCheckBox *chkHasDate = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate));
	LCheckBox *chkHasRev = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckRevTag));
	LCheckBox *chkMostRecent = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_MostRecentRev));
	LEditText *editDate = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditDate));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerDate));
	
	fillTag->DoDataExchange(gRevNames, putValue);
	fillDate->DoDataExchange(gDateNames, putValue);

	if(putValue)
	{
		chkHasDate->SetValue(hasDate ? Button_On : Button_Off);
		chkHasRev->SetValue(hasRev ? Button_On : Button_Off);
		chkMostRecent->SetValue(useMostRecent ? Button_On : Button_Off);
		editDate->SetText((Ptr)(const char *)sLastDate, sLastDate.length());
		editRev->SetText((Ptr)(const char *)sLastRev, sLastRev.length());
	}
	else
	{
		hasDate = chkHasDate->GetValue() == Button_On;
		hasRev = chkHasRev->GetValue() == Button_On;
		useMostRecent = chkMostRecent->GetValue() == Button_On;

		char str[255];
		Size len;
		
		editDate->GetText(str, 254, &len);
		sLastDate.set(str, len);
		editRev->GetText(str, 254, &len);
		sLastRev.set(str, len);
	}
}

static void DoDataExchange_UpdateSettings(LWindow *theDialog, bool & toStdout, bool & noRecurs,
	bool & resetSticky, bool & createMissDir, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkToStdout = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_ToStout));
	LCheckBox *chkResetSticky = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_ResetSticky));
	LCheckBox *chkCreateMissDir = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CreateMissDir));
	
	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
		chkToStdout->SetValue(toStdout ? Button_On : Button_Off);
		chkResetSticky->SetValue(resetSticky ? Button_On : Button_Off);
		chkCreateMissDir->SetValue(createMissDir ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;
		toStdout = chkToStdout->GetValue() == Button_On;
		resetSticky = chkResetSticky->GetValue() == Button_On;
		createMissDir = chkCreateMissDir->GetValue() == Button_On;
	}
}
#endif /* qMacCvsPP */

bool CompatGetUpdate(bool & toStdout, bool & noRecurs, bool & resetSticky,
					 CPStr & date, CPStr & rev,
					 bool & useMostRecent,
					 CPStr & rev1, CPStr & rev2,
					 bool & createMissDir)
{
	bool userHitOK = false;

	static CPStr sLastDate;
	static CPStr sLastRev;
	static CPStr sLastRev1;
	static CPStr sLastRev2;

	bool hasDate = false;
	bool hasRev = false;
	bool merge1 = false;
	bool merge2 = false;

	date = "";
	rev = "";
	rev1 = "";
	rev2 = "";
	toStdout = false;
	noRecurs = false;
	resetSticky = false;
	useMostRecent = false;
	createMissDir = false;

#ifdef WIN32
	CPropertySheet pages("Update settings");
	CUpdateMain page1;
	CUpdateSticky page2(sLastRev, sLastDate);
	CUpdateMerge page3(sLastRev1, sLastRev2);
	CGetPrefs_GLOBALS page4;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	pages.AddPage(&page4);
	if(pages.DoModal() == IDOK)
	{
		toStdout = page1.m_stdout == TRUE;
		noRecurs = page1.m_norecurs == TRUE;
		resetSticky = page1.m_delsticky == TRUE;
		createMissDir = page1.m_createmissdir == TRUE;

		sLastDate = page2.m_date;
		sLastRev = page2.m_rev;
		hasDate = page2.m_hasdate == TRUE;
		hasRev = page2.m_hasrev == TRUE;
		useMostRecent = page2.m_match == TRUE;

		merge1 = page3.m_merge >= 1;
		merge2 = page3.m_merge == 2;
		sLastRev1 = page3.m_rev1;
		sLastRev2 = page3.m_rev2;

		page4.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Update, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(4);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(3);
	DoDataExchange_UpdateMerge(theDialog, merge1, merge2, sLastRev1, sLastRev2, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_UpdateSticky(theDialog, hasDate, hasRev, sLastDate, sLastRev, useMostRecent, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_UpdateSettings(theDialog, toStdout, noRecurs, resetSticky, createMissDir, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_UpdateSettings(theDialog, toStdout, noRecurs, resetSticky, createMissDir, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_UpdateSticky(theDialog, hasDate, hasRev, sLastDate, sLastRev, useMostRecent, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_UpdateMerge(theDialog, merge1, merge2, sLastRev1, sLastRev2, false);
		multiView->SwitchToPanel(4);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */
#ifdef qQT
	QUpdateTab dlg;
	dlg.fDlg1.DoDataExchange(true, toStdout, noRecurs, resetSticky, createMissDir);
	dlg.fDlg2.DoDataExchange(true, hasDate, hasRev, sLastDate, sLastRev, useMostRecent, gRevNames, gDateNames);
	dlg.fDlg3.DoDataExchange(true, merge1, merge2, sLastRev1, sLastRev2, gRevNames);
	dlg.fDlg4.DoDataExchange(true);
	if(dlg.exec() == QDialog::Accepted)
	{
		dlg.fDlg1.DoDataExchange(false, toStdout, noRecurs, resetSticky, createMissDir);
		dlg.fDlg2.DoDataExchange(false, hasDate, hasRev, sLastDate, sLastRev, useMostRecent, gRevNames, gDateNames);
		dlg.fDlg3.DoDataExchange(false, merge1, merge2, sLastRev1, sLastRev2, gRevNames);
		dlg.fDlg4.DoDataExchange(false);
		userHitOK = true;
	}
#endif /* qQT */

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev && !sLastRev.empty())
			rev = sLastRev;

		if(merge1 && merge2 && !sLastRev1.empty() && !sLastRev2.empty())
		{
			rev1 = sLastRev1;
			rev2 = sLastRev2;
		}
		if(merge1 && !merge2 && !sLastRev1.empty())
		{
			rev1 = sLastRev1;
		}

		gCvsPrefs.save();
	}

	return userHitOK;
}
